/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Embeddable
public class TrabalhadorTemporarioDocumento
implements Documento {
    private static final long serialVersionUID = 1L;
    @Size(max=16)
    @Column(name="DOCTEMP_NUMERO")
    private String numero;
    @Column(name="DOCTEMP_DATA")
    @Temporal(value=TemporalType.DATE)
    private Date data;
    @JoinColumn(name="DOCTEMP_TIPO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoDocumentoLegal;
    @Column(name="DOCTEMP_TIPO")
    private Integer tipoDocumentoLegalCodigo;

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoDocumentoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoDocumentoLegalCodigo = this.tipoDocumentoLegal != null ? value.getCodigo() : null;
        this.tipoDocumentoLegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoDocumentoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numero;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numero = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numero);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numero);
    }

    @Override
    public Date getData() {
        return this.data;
    }

    @Override
    public void setData(Date value) {
        this.data = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrabalhadorTemporarioDocumento that = (TrabalhadorTemporarioDocumento)o;
        return Objects.equals(this.numero, that.numero) && Objects.equals(this.data, that.data) && Objects.equals(this.tipoDocumentoLegal, that.tipoDocumentoLegal) && Objects.equals(this.tipoDocumentoLegalCodigo, that.tipoDocumentoLegalCodigo);
    }

    public int hashCode() {
        return Objects.hash(this.numero, this.data, this.tipoDocumentoLegal, this.tipoDocumentoLegalCodigo);
    }
}

