/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.ArrayList;
import java.util.List;

public enum TrabalhadorSituacao {
    DESATIVADO("0", "C\u00e1lculo desativado"),
    NORMAL("1", "Normal"),
    DESLIGAMENTO_SEM_RESCISAO("2", "Desligamento sem rescis\u00e3o"),
    AFASTADO("3", "Afastado"),
    AVISO_INDENIZADO("4", "Aviso indenizado"),
    AVISO_TRABALHADO("5", "Aviso trabalhado"),
    DESLIGADO("6", "Desligado");

    private final String codigo;
    private final String descricao;

    private TrabalhadorSituacao(String id, String label) {
        this.codigo = id;
        this.descricao = label;
    }

    public static final TrabalhadorSituacao get(String situacao) {
        for (TrabalhadorSituacao s : TrabalhadorSituacao.values()) {
            if (!s.codigo.equals(situacao)) continue;
            return s;
        }
        return DESATIVADO;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static TrabalhadorSituacao[] getAtivos() {
        return new TrabalhadorSituacao[]{DESATIVADO, NORMAL, AVISO_INDENIZADO, AVISO_TRABALHADO};
    }

    public static TrabalhadorSituacao[] getInativos() {
        return new TrabalhadorSituacao[]{DESLIGADO};
    }

    public static List<String> getCodigos(List<TrabalhadorSituacao> situacoes) {
        ArrayList<String> codigos = new ArrayList<String>();
        for (TrabalhadorSituacao s : situacoes) {
            codigos.add(s.getCodigo());
        }
        return codigos;
    }
}

