/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.sip.persistence.api.SearchCodigo;
import br.com.fiorilli.sip.persistence.api.SearchEntidade;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Embeddable
public class TrabalhadorPK
implements Serializable {
    private static final long serialVersionUID = -5807530502058467391L;
    @SearchEntidade
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @SearchCodigo
    @FilterConfig(label="Registro", order=1)
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String registro;

    public TrabalhadorPK() {
    }

    public TrabalhadorPK(String entidade, String registro) {
        this.entidade = entidade;
        this.registro = registro;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public int hashCode() {
        int hash = 0;
        hash += this.entidade != null ? this.entidade.hashCode() : 0;
        return hash += this.registro != null ? this.registro.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TrabalhadorPK)) {
            return false;
        }
        TrabalhadorPK other = (TrabalhadorPK)object;
        if (this.entidade == null && other.entidade != null || this.entidade != null && !this.entidade.equals(other.entidade)) {
            return false;
        }
        return (this.registro != null || other.registro == null) && (this.registro == null || this.registro.equals(other.registro));
    }

    public String toString() {
        return "TrabalhadorPK[" + this.entidade + "," + this.registro + "]";
    }

    public String toMatriculaEsocial() {
        return String.format("%s-%s", this.entidade, this.registro);
    }
}

