/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Embeddable
public class TrabalhadorLegislacaoAdmissaoDocumento
implements Documento {
    private static final long serialVersionUID = 1L;
    @Size(max=16)
    @Column(name="LEGADM_NUMERO")
    private String legadmNumero;
    @Column(name="LEGADM_DATA")
    @Temporal(value=TemporalType.DATE)
    private Date legadmData;
    @JoinColumn(name="LEGADM_TIPODOC", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal legadmTipodoc;
    @Column(name="LEGADM_TIPODOC")
    private Integer tipoLegalCodigo;

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.legadmNumero;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.legadmNumero = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.legadmNumero);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.legadmNumero);
    }

    @Override
    public Date getData() {
        return this.legadmData;
    }

    @Override
    public void setData(Date value) {
        this.legadmData = value;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.legadmTipodoc;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegalCodigo = this.legadmTipodoc != null ? value.getCodigo() : null;
        this.legadmTipodoc = value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.legadmData == null ? 0 : this.legadmData.hashCode());
        result = 31 * result + (this.legadmNumero == null ? 0 : this.legadmNumero.hashCode());
        result = 31 * result + (this.legadmTipodoc == null ? 0 : this.legadmTipodoc.hashCode());
        result = 31 * result + (this.tipoLegalCodigo == null ? 0 : this.tipoLegalCodigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrabalhadorLegislacaoAdmissaoDocumento other = (TrabalhadorLegislacaoAdmissaoDocumento)obj;
        if (this.legadmData == null ? other.legadmData != null : !this.legadmData.equals(other.legadmData)) {
            return false;
        }
        if (this.legadmNumero == null ? other.legadmNumero != null : !this.legadmNumero.equals(other.legadmNumero)) {
            return false;
        }
        if (this.legadmTipodoc == null ? other.legadmTipodoc != null : !this.legadmTipodoc.equals(other.legadmTipodoc)) {
            return false;
        }
        return !(this.tipoLegalCodigo == null ? other.tipoLegalCodigo != null : !this.tipoLegalCodigo.equals(other.tipoLegalCodigo));
    }

    public String toString() {
        return "TrabalhadorLegislacaoAdmissaoDocumento [legadmNumero=" + this.legadmNumero + ", legadmData=" + this.legadmData + ", legadmTipodoc=" + this.legadmTipodoc + ", tipoLegalCodigo=" + this.tipoLegalCodigo + "]";
    }
}

