/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Idioma;
import br.com.fiorilli.sip.persistence.entity.Pessoa;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="TRABCURRICULO_IDIOMA")
@Audited
public class TrabalhadorIdioma
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CPF = "SELECT i FROM TrabalhadorIdioma i WHERE i.cpf = :cpf";
    public static final String GENERATOR = "GEN_TRABCURRICULOIDIOMA";
    @Id
    private int id;
    @Size(max=11)
    @Column(name="CPF")
    private String cpf;
    @Column(name="IDIOMA")
    private Integer idioma;
    @Type(type="BooleanTypeSip")
    @Column(name="ENTENDE")
    private Boolean entende;
    @Type(type="BooleanTypeSip")
    @Column(name="ESCREVE")
    private Boolean escreve;
    @Type(type="BooleanTypeSip")
    @Column(name="FALA")
    private Boolean fala;
    @Type(type="BooleanTypeSip")
    @Column(name="LE")
    private Boolean leIdioma;
    @JoinColumn(name="CPF", referencedColumnName="CPF", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Pessoa pessoa;

    public Boolean getEntende() {
        return this.entende;
    }

    public void setEntende(Boolean entende) {
        this.entende = entende;
    }

    public Boolean getEscreve() {
        return this.escreve;
    }

    public void setEscreve(Boolean escreve) {
        this.escreve = escreve;
    }

    public Boolean getFala() {
        return this.fala;
    }

    public void setFala(Boolean fala) {
        this.fala = fala;
    }

    public Boolean getLeIdioma() {
        return this.leIdioma;
    }

    public void setLeIdioma(Boolean leIdioma) {
        this.leIdioma = leIdioma;
    }

    public Idioma getIdioma() {
        return Idioma.get(this.idioma);
    }

    public void setIdioma(Idioma idioma) {
        this.idioma = idioma != null ? Integer.valueOf(idioma.getCodigo()) : null;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrabalhadorIdioma other = (TrabalhadorIdioma)obj;
        return this.id == other.id;
    }

    public String toString() {
        return "TrabalhadorIdioma [id=" + this.id + "]";
    }

    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }
}

