/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.sip.persistence.entity.DocumentoProfissional;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentoCtps;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentoHabilitacao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentoRG;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentoReservista;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentoTituloEleitoral;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentosApresentados;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.swing.text.MaskFormatter;
import javax.validation.constraints.Size;

@Embeddable
public class TrabalhadorDocumentosPessoais {
    private static final long serialVersionUID = 1L;
    @FilterConfig(label="PIS", condition=FilterCondition.COMECE, order=6)
    @Size(max=11)
    @Column(name="PIS")
    private String pis;
    @FilterConfig(label="CPF", condition=FilterCondition.COMECE, order=5)
    @Size(max=11)
    @Column(name="CPF")
    private String cpf;
    @Embedded
    private TrabalhadorDocumentoRG rg;
    @Embedded
    private TrabalhadorDocumentoTituloEleitoral tituloEleitoral;
    @Embedded
    private TrabalhadorDocumentoReservista reservista;
    @Embedded
    private DocumentoProfissional documentoProfissional;
    @Embedded
    private TrabalhadorDocumentoCtps ctps;
    @Embedded
    private TrabalhadorDocumentoHabilitacao habilitacao;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TrabalhadorDocumentosApresentados> documentosApresentadosPdf;

    public TrabalhadorDocumentoRG getRg() {
        if (this.rg == null) {
            this.rg = new TrabalhadorDocumentoRG();
        }
        return this.rg;
    }

    public void setRg(TrabalhadorDocumentoRG rg) {
        this.rg = rg;
    }

    public TrabalhadorDocumentoTituloEleitoral getTituloEleitoral() {
        if (this.tituloEleitoral == null) {
            this.tituloEleitoral = new TrabalhadorDocumentoTituloEleitoral();
        }
        return this.tituloEleitoral;
    }

    public void setTituloEleitoral(TrabalhadorDocumentoTituloEleitoral tituloEleitoral) {
        this.tituloEleitoral = tituloEleitoral;
    }

    public String getPis() {
        return this.pis;
    }

    public void setPis(String pis) {
        this.pis = pis;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public TrabalhadorDocumentoReservista getReservista() {
        if (this.reservista == null) {
            this.reservista = new TrabalhadorDocumentoReservista();
        }
        return this.reservista;
    }

    public void setReservista(TrabalhadorDocumentoReservista reservista) {
        this.reservista = reservista;
    }

    public DocumentoProfissional getDocumentoProfissional() {
        if (this.documentoProfissional == null) {
            this.documentoProfissional = new DocumentoProfissional();
        }
        return this.documentoProfissional;
    }

    public void setDocumentoProfissional(DocumentoProfissional documentoProfissional) {
        this.documentoProfissional = documentoProfissional;
    }

    public TrabalhadorDocumentoCtps getCtps() {
        if (this.ctps == null) {
            this.ctps = new TrabalhadorDocumentoCtps();
        }
        return this.ctps;
    }

    public void setCtps(TrabalhadorDocumentoCtps ctps) {
        this.ctps = ctps;
    }

    public TrabalhadorDocumentoHabilitacao getHabilitacao() {
        if (this.habilitacao == null) {
            this.habilitacao = new TrabalhadorDocumentoHabilitacao();
        }
        return this.habilitacao;
    }

    public void setHabilitacao(TrabalhadorDocumentoHabilitacao habilitacao) {
        this.habilitacao = habilitacao;
    }

    public String getFormattedCPF() {
        try {
            MaskFormatter mf = new MaskFormatter("###.###.###-##");
            mf.setValueContainsLiteralCharacters(false);
            return mf.valueToString(this.cpf);
        }
        catch (Exception e) {
            return this.cpf;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cpf == null ? 0 : this.cpf.hashCode());
        result = 31 * result + (this.ctps == null ? 0 : this.ctps.hashCode());
        result = 31 * result + (this.documentoProfissional == null ? 0 : this.documentoProfissional.hashCode());
        result = 31 * result + (this.habilitacao == null ? 0 : this.habilitacao.hashCode());
        result = 31 * result + (this.pis == null ? 0 : this.pis.hashCode());
        result = 31 * result + (this.reservista == null ? 0 : this.reservista.hashCode());
        result = 31 * result + (this.rg == null ? 0 : this.rg.hashCode());
        result = 31 * result + (this.tituloEleitoral == null ? 0 : this.tituloEleitoral.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrabalhadorDocumentosPessoais other = (TrabalhadorDocumentosPessoais)obj;
        if (this.cpf == null ? other.cpf != null : !this.cpf.equals(other.cpf)) {
            return false;
        }
        if (this.ctps == null ? other.ctps != null : !this.ctps.equals(other.ctps)) {
            return false;
        }
        if (this.documentoProfissional == null ? other.documentoProfissional != null : !this.documentoProfissional.equals(other.documentoProfissional)) {
            return false;
        }
        if (this.habilitacao == null ? other.habilitacao != null : !this.habilitacao.equals(other.habilitacao)) {
            return false;
        }
        if (this.pis == null ? other.pis != null : !this.pis.equals(other.pis)) {
            return false;
        }
        if (this.reservista == null ? other.reservista != null : !this.reservista.equals(other.reservista)) {
            return false;
        }
        if (this.rg == null ? other.rg != null : !this.rg.equals(other.rg)) {
            return false;
        }
        return !(this.tituloEleitoral == null ? other.tituloEleitoral != null : !this.tituloEleitoral.equals(other.tituloEleitoral));
    }

    public List<TrabalhadorDocumentosApresentados> getDocumentosApresentadosPdf() {
        if (this.documentosApresentadosPdf == null) {
            this.documentosApresentadosPdf = new ArrayList<TrabalhadorDocumentosApresentados>();
        }
        return this.documentosApresentadosPdf;
    }

    public void setDocumentosApresentadosPdf(List<TrabalhadorDocumentosApresentados> documentosApresentadosPdf) {
        this.documentosApresentadosPdf = documentosApresentadosPdf;
    }

    public String toString() {
        return "TrabalhadorDocumentosPessoais{pis='" + this.pis + '\'' + ", cpf='" + this.cpf + '\'' + '}';
    }
}

