/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.EstadoCivil;
import br.com.fiorilli.sip.persistence.entity.Instrucao;
import br.com.fiorilli.sip.persistence.entity.Nacionalidade;
import br.com.fiorilli.sip.persistence.entity.TelefoneCelular;
import br.com.fiorilli.sip.persistence.entity.TelefoneComercial;
import br.com.fiorilli.sip.persistence.entity.TelefoneFixo;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorCaracteristicasFisicas;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorRegistroNascimento;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorRegistroObito;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@Embeddable
public class TrabalhadorDadosPessoais {
    private static final long serialVersionUID = 1L;
    @Column(name="ANOCHEGADA", insertable=false, updatable=false)
    private String anoChegada;
    @Size(min=1, max=2)
    @Column(name="INSTRUCAO")
    private String instrucaoCodigo;
    @JoinColumn(name="INSTRUCAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Instrucao instrucao;
    @Size(max=2)
    @Column(name="NACIONALIDADE")
    private String nacionalidadeCodigo;
    @JoinColumn(name="NACIONALIDADE", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Nacionalidade nacionalidade;
    @Column(name="ESTADOCIVIL")
    private Character estadoCivil;
    @Pattern(regexp="[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?", message="E-mail inv\u00e1lido")
    @Size(max=60)
    @Column(name="EMAIL")
    private String email;
    @Size(max=60)
    @Column(name="EMAIL_PESSOAL")
    private String emailPessoal;
    @Pattern(regexp="^[a-z0-9@_-]{3,60}$", message="Nome de usu\u00e1rio inv\u00e1lido")
    @Size(max=60)
    @Column(name="USUARIO_WEB")
    private String usuarioWeb;
    @Embedded
    private Endereco endereco;
    @Column(name="CODIGO_CIDADE_IBGE")
    private String codigoCidadeIBGE;
    @Embedded
    private TelefoneFixo telefone;
    @Embedded
    private TelefoneCelular celular;
    @Embedded
    private TelefoneComercial telefoneComercial;
    @Column(name="RAMAL", length=5)
    private String ramal;
    @Size(max=15)
    @Column(name="SENHAWEB")
    private String senhaweb;
    @Embedded
    private TrabalhadorCaracteristicasFisicas caracteristicasFisicas;
    @Embedded
    private TrabalhadorRegistroNascimento registroNascimento;
    @Embedded
    private TrabalhadorRegistroObito registroObito;

    public String getNacionalidadeCodigo() {
        return this.nacionalidadeCodigo;
    }

    public void setNacionalidadeCodigo(String nacionalidade) {
        this.nacionalidadeCodigo = nacionalidade;
    }

    public String getAnoChegada() {
        return this.anoChegada;
    }

    public void setAnoChegada(String anoChegada) {
        this.anoChegada = anoChegada;
    }

    public Instrucao getInstrucao() {
        return this.instrucao;
    }

    public void setInstrucao(Instrucao instrucao) {
        this.instrucaoCodigo = instrucao != null ? instrucao.getCodigo() : null;
        this.instrucao = instrucao;
    }

    public EstadoCivil getEstadoCivil() {
        return EstadoCivil.of(this.estadoCivil);
    }

    public void setEstadoCivil(EstadoCivil estadoCivil) {
        this.estadoCivil = estadoCivil.getCodigo();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public TelefoneFixo getTelefone() {
        if (this.telefone == null) {
            this.telefone = new TelefoneFixo();
        }
        return this.telefone;
    }

    public void setTelefone(TelefoneFixo telefone) {
        this.telefone = telefone;
    }

    public TelefoneCelular getCelular() {
        if (this.celular == null) {
            this.celular = new TelefoneCelular();
        }
        return this.celular;
    }

    public void setCelular(TelefoneCelular celular) {
        this.celular = celular;
    }

    public String getUsuarioWeb() {
        return this.usuarioWeb;
    }

    public void setUsuarioWeb(String usuarioWeb) {
        this.usuarioWeb = usuarioWeb;
    }

    public String getSenhaweb() {
        return this.senhaweb;
    }

    public void setSenhaweb(String senhaweb) {
        this.senhaweb = senhaweb;
    }

    public Nacionalidade getNacionalidade() {
        return this.nacionalidade;
    }

    public void setNacionalidade(Nacionalidade nacionalidade) {
        this.nacionalidade = nacionalidade;
    }

    public String getInstrucaoCodigo() {
        return this.instrucaoCodigo;
    }

    public void setInstrucaoCodigo(String instrucaoCodigo) {
        this.instrucaoCodigo = instrucaoCodigo;
    }

    public String getEmailPessoal() {
        return this.emailPessoal;
    }

    public void setEmailPessoal(String emailPessoal) {
        this.emailPessoal = emailPessoal;
    }

    public TelefoneComercial getTelefoneComercial() {
        if (this.telefoneComercial == null) {
            this.telefoneComercial = new TelefoneComercial();
        }
        return this.telefoneComercial;
    }

    public void setTelefoneComercial(TelefoneComercial comercial) {
        this.telefoneComercial = comercial;
    }

    public String getCodigoCidadeIBGE() {
        return this.codigoCidadeIBGE;
    }

    public void setCodigoCidadeIBGE(String codigoCidadeIBGE) {
        this.codigoCidadeIBGE = codigoCidadeIBGE;
    }

    public String getRamal() {
        return this.ramal;
    }

    public void setRamal(String ramal) {
        this.ramal = ramal;
    }

    public TrabalhadorCaracteristicasFisicas getCaracteristicasFisicas() {
        if (this.caracteristicasFisicas == null) {
            this.caracteristicasFisicas = new TrabalhadorCaracteristicasFisicas();
        }
        return this.caracteristicasFisicas;
    }

    public void setCaracteristicasFisicas(TrabalhadorCaracteristicasFisicas caracteristicasFisicas) {
        this.caracteristicasFisicas = caracteristicasFisicas;
    }

    public TrabalhadorRegistroNascimento getRegistroNascimento() {
        return this.registroNascimento;
    }

    public void setRegistroNascimento(TrabalhadorRegistroNascimento registroNascimento) {
        this.registroNascimento = registroNascimento;
    }

    public TrabalhadorRegistroObito getRegistroObito() {
        if (this.registroObito == null) {
            this.registroObito = new TrabalhadorRegistroObito();
        }
        return this.registroObito;
    }

    public void setRegistroObito(TrabalhadorRegistroObito registroObito) {
        this.registroObito = registroObito;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.anoChegada == null ? 0 : this.anoChegada.hashCode());
        result = 31 * result + (this.caracteristicasFisicas == null ? 0 : this.caracteristicasFisicas.hashCode());
        result = 31 * result + (this.celular == null ? 0 : this.celular.hashCode());
        result = 31 * result + (this.codigoCidadeIBGE == null ? 0 : this.codigoCidadeIBGE.hashCode());
        result = 31 * result + (this.email == null ? 0 : this.email.hashCode());
        result = 31 * result + (this.emailPessoal == null ? 0 : this.emailPessoal.hashCode());
        result = 31 * result + (this.endereco == null ? 0 : this.endereco.hashCode());
        result = 31 * result + (this.estadoCivil == null ? 0 : this.estadoCivil.hashCode());
        result = 31 * result + (this.instrucao == null ? 0 : this.instrucao.hashCode());
        result = 31 * result + (this.instrucaoCodigo == null ? 0 : this.instrucaoCodigo.hashCode());
        result = 31 * result + (this.nacionalidade == null ? 0 : this.nacionalidade.hashCode());
        result = 31 * result + (this.nacionalidadeCodigo == null ? 0 : this.nacionalidadeCodigo.hashCode());
        result = 31 * result + (this.ramal == null ? 0 : this.ramal.hashCode());
        result = 31 * result + (this.registroNascimento == null ? 0 : this.registroNascimento.hashCode());
        result = 31 * result + (this.registroObito == null ? 0 : this.registroObito.hashCode());
        result = 31 * result + (this.senhaweb == null ? 0 : this.senhaweb.hashCode());
        result = 31 * result + (this.telefone == null ? 0 : this.telefone.hashCode());
        result = 31 * result + (this.telefoneComercial == null ? 0 : this.telefoneComercial.hashCode());
        result = 31 * result + (this.usuarioWeb == null ? 0 : this.usuarioWeb.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrabalhadorDadosPessoais other = (TrabalhadorDadosPessoais)obj;
        if (this.anoChegada == null ? other.anoChegada != null : !this.anoChegada.equals(other.anoChegada)) {
            return false;
        }
        if (this.caracteristicasFisicas == null ? other.caracteristicasFisicas != null : !this.caracteristicasFisicas.equals(other.caracteristicasFisicas)) {
            return false;
        }
        if (this.celular == null ? other.celular != null : !this.celular.equals(other.celular)) {
            return false;
        }
        if (this.codigoCidadeIBGE == null ? other.codigoCidadeIBGE != null : !this.codigoCidadeIBGE.equals(other.codigoCidadeIBGE)) {
            return false;
        }
        if (this.email == null ? other.email != null : !this.email.equals(other.email)) {
            return false;
        }
        if (this.emailPessoal == null ? other.emailPessoal != null : !this.emailPessoal.equals(other.emailPessoal)) {
            return false;
        }
        if (this.endereco == null ? other.endereco != null : !this.endereco.equals(other.endereco)) {
            return false;
        }
        if (this.estadoCivil == null ? other.estadoCivil != null : !this.estadoCivil.equals(other.estadoCivil)) {
            return false;
        }
        if (this.instrucao == null ? other.instrucao != null : !this.instrucao.equals(other.instrucao)) {
            return false;
        }
        if (this.instrucaoCodigo == null ? other.instrucaoCodigo != null : !this.instrucaoCodigo.equals(other.instrucaoCodigo)) {
            return false;
        }
        if (this.nacionalidade == null ? other.nacionalidade != null : !this.nacionalidade.equals(other.nacionalidade)) {
            return false;
        }
        if (this.nacionalidadeCodigo == null ? other.nacionalidadeCodigo != null : !this.nacionalidadeCodigo.equals(other.nacionalidadeCodigo)) {
            return false;
        }
        if (this.ramal == null ? other.ramal != null : !this.ramal.equals(other.ramal)) {
            return false;
        }
        if (this.registroNascimento == null ? other.registroNascimento != null : !this.registroNascimento.equals(other.registroNascimento)) {
            return false;
        }
        if (this.registroObito == null ? other.registroObito != null : !this.registroObito.equals(other.registroObito)) {
            return false;
        }
        if (this.senhaweb == null ? other.senhaweb != null : !this.senhaweb.equals(other.senhaweb)) {
            return false;
        }
        if (this.telefone == null ? other.telefone != null : !this.telefone.equals(other.telefone)) {
            return false;
        }
        if (this.telefoneComercial == null ? other.telefoneComercial != null : !this.telefoneComercial.equals(other.telefoneComercial)) {
            return false;
        }
        return !(this.usuarioWeb == null ? other.usuarioWeb != null : !this.usuarioWeb.equals(other.usuarioWeb));
    }

    public String toString() {
        return "TrabalhadorDadosPessoais{anoChegada='" + this.anoChegada + '\'' + ", instrucaoCodigo='" + this.instrucaoCodigo + '\'' + ", instrucao=" + this.instrucao + ", nacionalidadeCodigo='" + this.nacionalidadeCodigo + '\'' + ", nacionalidade=" + this.nacionalidade + ", estadoCivil=" + this.estadoCivil + ", email='" + this.email + '\'' + ", emailPessoal='" + this.emailPessoal + '\'' + ", usuarioWeb='" + this.usuarioWeb + '\'' + ", endereco=" + this.endereco + ", codigoCidadeIBGE='" + this.codigoCidadeIBGE + '\'' + ", telefone=" + this.telefone + ", celular=" + this.celular + ", telefoneComercial=" + this.telefoneComercial + ", ramal='" + this.ramal + '\'' + ", senhaweb='" + this.senhaweb + '\'' + ", caracteristicasFisicas=" + this.caracteristicasFisicas + ", registroNascimento=" + this.registroNascimento + ", registroObito=" + this.registroObito + '}';
    }
}

