/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Agencia;
import br.com.fiorilli.sip.persistence.entity.Banco;
import br.com.fiorilli.sip.persistence.entity.Convenio;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorContaFormaCredito;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorContaPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType(query="SELECT $R{[tc.entidadeCodigo], [tc]} FROM TrabalhadorConta tc JOIN FETCH tc.banco ba WHERE $P{[agenciaCodigo], [tc.agenciaCodigo], [:agenciaCodigo]} AND $P{[ba],[ba],[:ba]}")
@Entity
@Table(name="CONTASTRABALHADOR")
@Audited
public class TrabalhadorConta
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_CONTA_ATIVA = "SELECT c FROM TrabalhadorConta c LEFT JOIN FETCH c.banco WHERE c.trabalhador.trabalhadorPK = :trabalhadorPK AND c.padrao = 'S'";
    public static final String GET_NEXT_ITEM = "select coalesce(max(c.trabalhadorContaPK.item), 0) + 1 from TrabalhadorConta c where c.convenio.convenioPK = :convenioPK and c.trabalhador.trabalhadorPK = :trabalhadorPK";
    public static final String FIND_BY_TRABALHADOR = "SELECT c FROM TrabalhadorConta c JOIN FETCH c.convenio co LEFT JOIN FETCH c.banco ct LEFT JOIN FETCH c.outroBanco JOIN FETCH c.trabalhador WHERE c.trabalhador.trabalhadorPK = :trabalhadorPK";
    public static final String FILTER_QUERY = "SELECT $R{[tc.entidadeCodigo], [tc]} FROM TrabalhadorConta tc JOIN FETCH tc.banco ba WHERE $P{[agenciaCodigo], [tc.agenciaCodigo], [:agenciaCodigo]} AND $P{[ba],[ba],[:ba]}";
    @EmbeddedId
    protected TrabalhadorContaPK trabalhadorContaPK;
    @Size(max=5)
    @Column(name="TIPO")
    private String tipo;
    @FilterConfig(label="Ag\u00eancia", condition=FilterCondition.COMECE)
    @Size(max=6)
    @Column(name="AGENCIA")
    private String agenciaCodigo;
    @Size(max=2)
    @Column(name="DVAGENCIA")
    private String agenciaDigitoVerificador;
    @Size(max=12)
    @Column(name="CONTA")
    private String contaCodigo;
    @Size(max=2)
    @Column(name="DVCONTA")
    private String contaDigitoVerificador;
    @Type(type="BooleanTypeSip")
    @Column(name="PADRAO")
    private Boolean padrao;
    @Type(type="BooleanTypeSip")
    @Column(name="PORTABILIDADE")
    private Boolean portabilidade;
    @Column(name="FORMA_CREDITO")
    private String formaCredito;
    @Column(name="EMPRESA", insertable=false, updatable=false)
    private String entidadeCodigo;
    @Column(name="REGISTRO", insertable=false, updatable=false)
    private String registro;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="BANCO", referencedColumnName="BANCO", insertable=false, updatable=false), @JoinColumn(name="ITEMAGENCIA", referencedColumnName="ITEMAGENCIA", insertable=false, updatable=false), @JoinColumn(name="ITEMCONTA", referencedColumnName="ITEMCONTA", insertable=false, updatable=false), @JoinColumn(name="ITEMCONVENIO", referencedColumnName="ITEM", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Convenio convenio;
    @JoinColumn(name="OUTRO_BANCO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Banco outroBanco;
    @Column(name="OUTRO_BANCO")
    private String outroBancoCodigo;
    @FilterConfig(label="Banco", inputType=FilterInputType.AUTO_COMPLETE, blockCondition=true)
    @FilterConfigSelect(query="SELECT b FROM Banco b WHERE (b.nome LIKE :param||'%') OR (b.codigo = :param)")
    @JoinColumn(name="BANCO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.EAGER)
    private Banco banco;
    @Column(name="BANCO", insertable=false, updatable=false)
    private String bancoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="BANCO", referencedColumnName="BANCO", insertable=false, updatable=false), @JoinColumn(name="ITEMAGENCIA", referencedColumnName="ITEM", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.EAGER)
    private Agencia agencia;

    public TrabalhadorConta() {
    }

    public TrabalhadorConta(TrabalhadorContaPK contastrabalhadorPK) {
        this.trabalhadorContaPK = contastrabalhadorPK;
    }

    public TrabalhadorConta(String entidade, String registro, String banco, short itemagencia, short itemconta, short itemconvenio, short item) {
        this.trabalhadorContaPK = new TrabalhadorContaPK(entidade, registro, banco, itemagencia, itemconta, itemconvenio, item);
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public String getContaCodigo() {
        return this.contaCodigo;
    }

    public void setContaCodigo(String conta) {
        this.contaCodigo = conta;
    }

    public String getContaDigitoVerificador() {
        return this.contaDigitoVerificador;
    }

    public void setContaDigitoVerificador(String dvconta) {
        this.contaDigitoVerificador = dvconta;
    }

    public Boolean getPadrao() {
        return this.padrao;
    }

    public void setPadrao(Boolean padrao) {
        this.padrao = padrao;
    }

    public String getAgenciaCodigo() {
        return this.agenciaCodigo;
    }

    public void setAgenciaCodigo(String agencia) {
        this.agenciaCodigo = agencia;
    }

    public String getAgenciaDigitoVerificador() {
        return this.agenciaDigitoVerificador;
    }

    public void setAgenciaDigitoVerificador(String dvagencia) {
        this.agenciaDigitoVerificador = dvagencia;
    }

    public TrabalhadorContaFormaCredito getFormaCredito() {
        return TrabalhadorContaFormaCredito.get(this.formaCredito);
    }

    public void setFormaCredito(TrabalhadorContaFormaCredito formaCredito) {
        this.formaCredito = formaCredito.getCodigo();
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.trabalhadorContaPK.setEntidadeCodigo(this.trabalhador.getTrabalhadorPK().getEntidade());
            this.trabalhadorContaPK.setRegistro(this.getTrabalhador().getTrabalhadorPK().getRegistro());
        } else {
            this.trabalhadorContaPK.setEntidadeCodigo(null);
            this.trabalhadorContaPK.setRegistro(null);
        }
    }

    public Convenio getConvenio() {
        return this.convenio;
    }

    public void setConvenio(Convenio convenio) {
        this.convenio = convenio;
        if (convenio != null) {
            this.trabalhadorContaPK.setBancoCodigo(convenio.getCodigoBanco());
            this.trabalhadorContaPK.setAgenciaItem(convenio.getConvenioPK().getItemAgencia());
            this.trabalhadorContaPK.setContaItem(convenio.getConvenioPK().getItemConta());
            this.trabalhadorContaPK.setConvenioItem(convenio.getConvenioPK().getItem());
        } else {
            this.trabalhadorContaPK.setBancoCodigo(null);
            this.trabalhadorContaPK.setAgenciaItem(null);
            this.trabalhadorContaPK.setContaItem(null);
            this.trabalhadorContaPK.setConvenioItem(null);
        }
    }

    public Banco getOutroBanco() {
        return this.outroBanco;
    }

    public void setOutroBanco(Banco outroBanco) {
        this.outroBanco = outroBanco;
        this.outroBancoCodigo = outroBanco != null ? outroBanco.getCodigo() : null;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.trabalhadorContaPK != null ? this.trabalhadorContaPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TrabalhadorConta)) {
            return false;
        }
        TrabalhadorConta other = (TrabalhadorConta)object;
        return (this.trabalhadorContaPK != null || other.trabalhadorContaPK == null) && (this.trabalhadorContaPK == null || this.trabalhadorContaPK.equals(other.trabalhadorContaPK));
    }

    public String toString() {
        return "entity.Contastrabalhador[ contastrabalhadorPK=" + this.trabalhadorContaPK + " ]";
    }

    public TrabalhadorContaPK getTrabalhadorContaPK() {
        if (this.trabalhadorContaPK == null) {
            this.trabalhadorContaPK = new TrabalhadorContaPK();
        }
        return this.trabalhadorContaPK;
    }

    public void setTrabalhadorContaPK(TrabalhadorContaPK trabalhadorContaPK) {
        this.trabalhadorContaPK = trabalhadorContaPK;
    }

    public Banco getBanco() {
        if (this.banco == null) {
            this.banco = new Banco();
        }
        return this.banco;
    }

    public void setBanco(Banco banco) {
        this.banco = banco;
    }

    public Boolean getPortabilidade() {
        return this.portabilidade;
    }

    public void setPortabilidade(Boolean portabilidade) {
        this.portabilidade = portabilidade;
    }

    public String getOutroBancoCodigo() {
        return this.outroBancoCodigo;
    }

    public void setOutroBancoCodigo(String outroBancoCodigo) {
        this.outroBancoCodigo = outroBancoCodigo;
    }

    public Agencia getAgencia() {
        return this.agencia;
    }

    public void setAgencia(Agencia agencia) {
        this.agencia = agencia;
    }
}

