/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorArquivoPK;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=TrabalhadorArquivo.class)
@Entity
@Table(name="TRABARQUIVO")
@Audited
public class TrabalhadorArquivo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_POR_ENTIDADE = "SELECT a FROM TrabalhadorArquivo a where a.trabalhadorArquivoPK.entidade = :entidadeId";
    @EmbeddedId
    protected TrabalhadorArquivoPK trabalhadorArquivoPK;
    @FilterConfig(label="C\u00f3digo", order=1)
    @Column(name="CODIGO", insertable=false, updatable=false)
    @Pattern(regexp="\\d+")
    private String codigo;
    @FilterConfig(label="Nome", order=2)
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=60)
    @Column(name="NOME")
    private String nome;

    public TrabalhadorArquivo() {
    }

    public TrabalhadorArquivo(TrabalhadorArquivoPK trabalhadorArquivoPK) {
        this.trabalhadorArquivoPK = trabalhadorArquivoPK;
    }

    public TrabalhadorArquivo(TrabalhadorArquivoPK trabalhadorArquivoPK, String nome) {
        this.trabalhadorArquivoPK = trabalhadorArquivoPK;
        this.nome = nome;
    }

    public TrabalhadorArquivo(String entidade, String codigo) {
        this.trabalhadorArquivoPK = new TrabalhadorArquivoPK(entidade, codigo);
    }

    public TrabalhadorArquivoPK getTrabalhadorArquivoPK() {
        return this.trabalhadorArquivoPK;
    }

    public void setTrabalhadorArquivoPK(TrabalhadorArquivoPK trabalhadorArquivoPK) {
        this.trabalhadorArquivoPK = trabalhadorArquivoPK;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.trabalhadorArquivoPK != null ? this.trabalhadorArquivoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TrabalhadorArquivo)) {
            return false;
        }
        TrabalhadorArquivo other = (TrabalhadorArquivo)object;
        return (this.trabalhadorArquivoPK != null || other.trabalhadorArquivoPK == null) && (this.trabalhadorArquivoPK == null || this.trabalhadorArquivoPK.equals(other.trabalhadorArquivoPK));
    }

    public String toString() {
        return "entity.Trabarquivo[ trabalhadorArquivoPK=" + this.trabalhadorArquivoPK + " ]";
    }

    public static TrabalhadorArquivo createInitialized(String codigoEntidade) {
        TrabalhadorArquivo t = new TrabalhadorArquivo();
        t.setTrabalhadorArquivoPK(new TrabalhadorArquivoPK());
        t.getTrabalhadorArquivoPK().setEntidade(codigoEntidade);
        return t;
    }
}

