/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPACAOJUDICIAL")
@Audited
public class TrabalhadorAcaoJudicial
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_SIPACAOJUDICIAL";
    public static final String GET_FETCHED = "SELECT t FROM TrabalhadorAcaoJudicial t LEFT JOIN FETCH t.trabalhador LEFT JOIN FETCH t.procuradorAdvogado WHERE t.id = :id";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="IDAJ")
    private Integer id;
    @FilterConfig(label="N\u00famero Processo")
    @Size(max=20)
    @Column(name="NUMEROPROCESSOAJ")
    private String numeroProcesso;
    @FilterConfig(label="Org\u00e3o de Origem")
    @Size(max=60)
    @Column(name="ORGAOORIGEMAJ")
    private String orgaoOrigem;
    @FilterConfig(label="N\u00famero protocolo")
    @Size(max=15)
    @Column(name="NUMEROPROTOCOLOAJ")
    private String numeroProtocolo;
    @FilterConfig(label="Data Protocolo", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO)
    @Column(name="DATAPROTOCOLOAJ")
    @Temporal(value=TemporalType.DATE)
    private Date dataProtocolo;
    @Column(name="VALOROBJETOAJ")
    private Double valorObjeto;
    @Size(max=60)
    @Column(name="ADVOGADOTRABALHADORAJ")
    private String trabalhadorAdvogado;
    @Size(max=15)
    @Column(name="OABADVOGADOTRABALHADORAJ")
    private String trabalhadorAdvogadoOAB;
    @Size(max=5)
    @Column(name="VARAJCJAJ")
    private String varaJCJ;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATAINICIOAJ")
    private Date dataInicio;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATATERMINOAJ")
    private Date dataTermino;
    @Column(name="VALORINSSAJ")
    private Double valorINSS;
    @Column(name="VALORIRRFAJ")
    private Double valorIRRF;
    @Column(name="VALOROUTRASENTIDADESAJ")
    private Double valorOutrasEntidades;
    @Column(name="COMPENSACAOVALORCORRIGIDOAJ")
    private Double compensacaoValorCorregido;
    @Temporal(value=TemporalType.DATE)
    @Column(name="COMPENSACAOPERIODOINICIOAJ")
    private Date compensacaoPeriodoInicio;
    @Temporal(value=TemporalType.DATE)
    @Column(name="COMPENSACAOPERIODOTERMINOAJ")
    private Date compensacaoPeriodoTermino;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    private String ano;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="MES")
    private String mes;
    @Size(min=1, max=3)
    @Column(name="EMPRESAAJ")
    private String trabalhadorEntidade;
    @Size(min=1, max=6)
    @Column(name="REGISTROAJ")
    private String trabalhadorRegistro;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumns(value={@JoinColumn(name="EMPRESAAJ", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTROAJ", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhador;
    @Size(min=1, max=3)
    @Column(name="PROCURADORADVOGADOEMPRESAAJ")
    private String procuradorEntidade;
    @Size(min=1, max=6)
    @Column(name="PROCURADORADVOGADOREGISTROAJ")
    private String procuradorRegistro;
    @JoinColumns(value={@JoinColumn(name="PROCURADORADVOGADOEMPRESAAJ", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="PROCURADORADVOGADOREGISTROAJ", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador procuradorAdvogado;

    public String getTrabalhadorEntidade() {
        return this.trabalhadorEntidade;
    }

    public void setTrabalhadorEntidade(String trabalhadorEntidade) {
        this.trabalhadorEntidade = trabalhadorEntidade;
    }

    public String getTrabalhadorRegistro() {
        return this.trabalhadorRegistro;
    }

    public void setTrabalhadorRegistro(String trabalhadorRegistro) {
        this.trabalhadorRegistro = trabalhadorRegistro;
    }

    public String getProcuradorEntidade() {
        return this.procuradorEntidade;
    }

    public void setProcuradorEntidade(String procuradorEntidade) {
        this.procuradorEntidade = procuradorEntidade;
    }

    public String getProcuradorRegistro() {
        return this.procuradorRegistro;
    }

    public void setProcuradorRegistro(String procuradorRegistro) {
        this.procuradorRegistro = procuradorRegistro;
    }

    public TrabalhadorAcaoJudicial() {
    }

    public TrabalhadorAcaoJudicial(Integer idaj) {
        this.id = idaj;
    }

    public TrabalhadorAcaoJudicial(Integer idaj, String ano, String mes) {
        this.id = idaj;
        this.ano = ano;
        this.mes = mes;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer idaj) {
        this.id = idaj;
    }

    public String getNumeroProcesso() {
        return this.numeroProcesso;
    }

    public void setNumeroProcesso(String numeroprocessoaj) {
        this.numeroProcesso = numeroprocessoaj;
    }

    public String getOrgaoOrigem() {
        return this.orgaoOrigem;
    }

    public void setOrgaoOrigem(String orgaoorigemaj) {
        this.orgaoOrigem = orgaoorigemaj;
    }

    public String getNumeroProtocolo() {
        return this.numeroProtocolo;
    }

    public void setNumeroProtocolo(String numeroprotocoloaj) {
        this.numeroProtocolo = numeroprotocoloaj;
    }

    public Date getDataProtocolo() {
        return this.dataProtocolo;
    }

    public void setDataProtocolo(Date dataprotocoloaj) {
        this.dataProtocolo = dataprotocoloaj;
    }

    public Double getValorObjeto() {
        return this.valorObjeto;
    }

    public void setValorObjeto(Double valorobjetoaj) {
        this.valorObjeto = valorobjetoaj;
    }

    public String getTrabalhadorAdvogado() {
        return this.trabalhadorAdvogado;
    }

    public void setTrabalhadorAdvogado(String advogadotrabalhadoraj) {
        this.trabalhadorAdvogado = advogadotrabalhadoraj;
    }

    public String getTrabalhadorAdvogadoOAB() {
        return this.trabalhadorAdvogadoOAB;
    }

    public void setTrabalhadorAdvogadoOAB(String oabadvogadotrabalhadoraj) {
        this.trabalhadorAdvogadoOAB = oabadvogadotrabalhadoraj;
    }

    public String getVaraJCJ() {
        return this.varaJCJ;
    }

    public void setVaraJCJ(String varajcjaj) {
        this.varaJCJ = varajcjaj;
    }

    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date datainicioaj) {
        this.dataInicio = datainicioaj;
    }

    public Date getDataTermino() {
        return this.dataTermino;
    }

    public void setDataTermino(Date dataterminoaj) {
        this.dataTermino = dataterminoaj;
    }

    public Double getValorINSS() {
        return this.valorINSS;
    }

    public void setValorINSS(Double valorinssaj) {
        this.valorINSS = valorinssaj;
    }

    public Double getValorIRRF() {
        return this.valorIRRF;
    }

    public void setValorIRRF(Double valorirrfaj) {
        this.valorIRRF = valorirrfaj;
    }

    public Double getValorOutrasEntidades() {
        return this.valorOutrasEntidades;
    }

    public void setValorOutrasEntidades(Double valoroutrasentidadesaj) {
        this.valorOutrasEntidades = valoroutrasentidadesaj;
    }

    public Double getCompensacaoValorCorregido() {
        return this.compensacaoValorCorregido;
    }

    public void setCompensacaoValorCorregido(Double compensacaovalorcorrigidoaj) {
        this.compensacaoValorCorregido = compensacaovalorcorrigidoaj;
    }

    public Date getCompensacaoPeriodoInicio() {
        return this.compensacaoPeriodoInicio;
    }

    public void setCompensacaoPeriodoInicio(Date compensacaoperiodoinicioaj) {
        this.compensacaoPeriodoInicio = compensacaoperiodoinicioaj;
    }

    public Date getCompensacaoPeriodoTermino() {
        return this.compensacaoPeriodoTermino;
    }

    public void setCompensacaoPeriodoTermino(Date compensacaoperiodoterminoaj) {
        this.compensacaoPeriodoTermino = compensacaoperiodoterminoaj;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.trabalhadorEntidade = trabalhador.getTrabalhadorPK().getEntidade();
            this.trabalhadorRegistro = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.trabalhadorEntidade = null;
            this.trabalhadorRegistro = null;
        }
        this.trabalhador = trabalhador;
    }

    public Trabalhador getProcuradorAdvogado() {
        return this.procuradorAdvogado;
    }

    public void setProcuradorAdvogado(Trabalhador trabalhador) {
        if (trabalhador != null) {
            this.procuradorEntidade = trabalhador.getTrabalhadorPK().getEntidade();
            this.procuradorRegistro = trabalhador.getTrabalhadorPK().getRegistro();
        } else {
            this.procuradorEntidade = null;
            this.procuradorRegistro = null;
        }
        this.procuradorAdvogado = trabalhador;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TrabalhadorAcaoJudicial)) {
            return false;
        }
        TrabalhadorAcaoJudicial other = (TrabalhadorAcaoJudicial)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "entity.TrabalhadorAcaoJudicial[ idaj=" + this.id + " ]";
    }
}

