/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.AmbienteTrabalho;
import br.com.fiorilli.sip.persistence.entity.Aposentado;
import br.com.fiorilli.sip.persistence.entity.AposentadoriaTCESP;
import br.com.fiorilli.sip.persistence.entity.Atividade;
import br.com.fiorilli.sip.persistence.entity.BancoHorasLancamento;
import br.com.fiorilli.sip.persistence.entity.Bases;
import br.com.fiorilli.sip.persistence.entity.BeneficiarioPensaoAlimenticia;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.CargoNivel;
import br.com.fiorilli.sip.persistence.entity.CategoriaFuncional;
import br.com.fiorilli.sip.persistence.entity.CategoriaSefip;
import br.com.fiorilli.sip.persistence.entity.Concurso;
import br.com.fiorilli.sip.persistence.entity.ConcursoCargo;
import br.com.fiorilli.sip.persistence.entity.CtrlMargemConsignavel;
import br.com.fiorilli.sip.persistence.entity.Dependente;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.DocumentoAdmissao;
import br.com.fiorilli.sip.persistence.entity.DocumentoDigital;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.EntidadeCedente;
import br.com.fiorilli.sip.persistence.entity.EscolaTecnica;
import br.com.fiorilli.sip.persistence.entity.EventoFixo;
import br.com.fiorilli.sip.persistence.entity.EventoFolhaComplementar;
import br.com.fiorilli.sip.persistence.entity.Eventuais;
import br.com.fiorilli.sip.persistence.entity.Falta;
import br.com.fiorilli.sip.persistence.entity.Ferias;
import br.com.fiorilli.sip.persistence.entity.GrupoPonto;
import br.com.fiorilli.sip.persistence.entity.Histcargosal;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorAtividade;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorCargo;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorDivisao;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorLocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorNome;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSalario;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSalarioInicial;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSubdivisao;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorUnidade;
import br.com.fiorilli.sip.persistence.entity.Jornada;
import br.com.fiorilli.sip.persistence.entity.LdapConfig;
import br.com.fiorilli.sip.persistence.entity.LicencaPremio;
import br.com.fiorilli.sip.persistence.entity.LicencaPremioMovimento;
import br.com.fiorilli.sip.persistence.entity.LocalTrabalho;
import br.com.fiorilli.sip.persistence.entity.LotacaoTCESP;
import br.com.fiorilli.sip.persistence.entity.Movimento;
import br.com.fiorilli.sip.persistence.entity.MovimentoSefip;
import br.com.fiorilli.sip.persistence.entity.NaoOptanteIncidencia;
import br.com.fiorilli.sip.persistence.entity.Orgaosiprev;
import br.com.fiorilli.sip.persistence.entity.Pcmso;
import br.com.fiorilli.sip.persistence.entity.Pensionista;
import br.com.fiorilli.sip.persistence.entity.PessoaBiometria;
import br.com.fiorilli.sip.persistence.entity.PessoaPortaria;
import br.com.fiorilli.sip.persistence.entity.PontoFacultativoNominal;
import br.com.fiorilli.sip.persistence.entity.RegistroControleEpi;
import br.com.fiorilli.sip.persistence.entity.RppsHistoricoPrecidenciario;
import br.com.fiorilli.sip.persistence.entity.Salario;
import br.com.fiorilli.sip.persistence.entity.SefipTipoOcorrencia;
import br.com.fiorilli.sip.persistence.entity.Sindicato;
import br.com.fiorilli.sip.persistence.entity.SiopeTrabalhador;
import br.com.fiorilli.sip.persistence.entity.SipbaTrabalhador;
import br.com.fiorilli.sip.persistence.entity.SipmtTrabalhador;
import br.com.fiorilli.sip.persistence.entity.SipprAtividadeTrabalhador;
import br.com.fiorilli.sip.persistence.entity.SiprevSituacaoFuncional;
import br.com.fiorilli.sip.persistence.entity.SiprevSituacaoPrevidenciaria;
import br.com.fiorilli.sip.persistence.entity.SiprevVinculoOrgao;
import br.com.fiorilli.sip.persistence.entity.SiprjTrabalhador;
import br.com.fiorilli.sip.persistence.entity.SiprnTrabalhador;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoAfastamento;
import br.com.fiorilli.sip.persistence.entity.SituacaoFuncional;
import br.com.fiorilli.sip.persistence.entity.SolicitacaoAdiantamento13Salario;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.SubdivisaoItem;
import br.com.fiorilli.sip.persistence.entity.TipoAdmissao;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.TipoRegimeJornada;
import br.com.fiorilli.sip.persistence.entity.TomadorObra;
import br.com.fiorilli.sip.persistence.entity.TrabObs;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorArquivo;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorCalculoIRRF;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorConta;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDadosPessoais;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentoApresentado;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentosJustificativaAdmissaoPDF;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentosPessoais;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorEstadoSaoPaulo;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorFoto;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorLegislacaoAdmissaoDocumento;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPonto;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPrevidenciaConforme;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorSituacao;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTceMs;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTcmgo;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTemporarioDocumento;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorTipoSalario;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorValeTransporte;
import br.com.fiorilli.sip.persistence.entity.Unidade;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import br.com.fiorilli.sip.persistence.entity.VeiculoPublicacao;
import br.com.fiorilli.sip.persistence.entity.Vinculo;
import br.com.fiorilli.sipweb.vo.ws.TrabalhadorWebserviceMiniVo;
import br.gov.mg.tce.persistence.entity.SipMgTrabalhador;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@FilterConfigType(autoFilter=true, displayField=7)
@Entity
@Table(name="TRABALHADOR")
@Audited
public class Trabalhador
implements Serializable,
Filterable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String QUERY_FIND_ULTIMO_CADASTRO_ATIVO = "SELECT t FROM Trabalhador t WHERE t.matricula = :matricula AND t.situacao = '1' ORDER BY t.dataAdmissao DESC";
    public static final String QUERY_FIND_NEW_SIP_USER = "select t from Trabalhador t where t.matricula = :matricula and t.documentosPessoais.cpf = :cpf and t.documentosPessoais.pis = :pis AND t.dataNascimento = :dataNascimento order by t.situacao, t.dataAdmissao desc";
    public static final String FIND_BY_DADOS = "select t from Trabalhador t where t.matricula = :matricula and t.documentosPessoais.cpf = :cpf and t.documentosPessoais.pis = :pis and t.dataNascimento = :dataNascimento and t.dadosPessoais.usuarioWeb is not null";
    public static final String COUNT_ATIVOS_BY_ENTIDADE = "SELECT count(t) FROM Trabalhador t WHERE t.trabalhadorPK.entidade = :entidadeId AND t.situacao = '1'";
    public static final String FIND_BY_ENTIDADE_NO_PERIODO_DE_ADMISSAO_VO = "SELECT NEW " + TrabalhadorWebserviceMiniVo.class.getCanonicalName() + "(" + "t.trabalhadorPK.registro, t.matricula, t.contrato, t.documentosPessoais.cpf, t.documentosPessoais.pis, t.nome, t.dataAdmissao, t.dataDemissao, t.vinculoCodigo, t.cargoAtualCodigo, ca.nome, t.divisaoCodigo, d.nome, t.subdivisaoCodigo, sd.nome, u.departamentoDespesa, u.nome, t.situacao, t.cargoInicialCodigo, ci.nome, t.categoriaFuncionalCodigo, cf.nome, t.trabalhadorPK.entidade, v.nome, lc.localTrabalhoPK.codigo, lc.nome, t.aposentado, t.pensionista, ai.causaCodigo, t.efetivadoEstagioProbatorio, ci.natureza, ca.natureza, j.jornadaPK.codigo, j.nome, CASE WHEN EXISTS(SELECT 'S' FROM Usuario us WHERE us.ativo = true AND us.trabalhador = t) THEN true ELSE false END, t.usuarioLdap " + ") " + "FROM Trabalhador t " + "LEFT JOIN t.cargoInicial ci LEFT JOIN t.cargoAtual ca LEFT JOIN t.divisao d LEFT JOIN t.subdivisao sd LEFT JOIN t.unidade u LEFT JOIN t.categoriaFuncional cf LEFT JOIN t.localTrabalho lc LEFT JOIN t.vinculo v LEFT JOIN t.aposentadoInativo ai LEFT JOIN t.jornada j " + "WHERE t.trabalhadorPK.entidade = :entidadeId " + "AND t.dataAdmissao BETWEEN :dataInicial AND :dataFinal";
    public static final String FIND_BY_ENTIDADE_NO_PERIODO_DE_CADASTRO_VO = "SELECT NEW " + TrabalhadorWebserviceMiniVo.class.getCanonicalName() + "(" + "t.trabalhadorPK.registro, t.matricula, t.contrato, t.documentosPessoais.cpf, t.documentosPessoais.pis, t.nome, t.dataAdmissao, t.dataDemissao, t.vinculoCodigo, t.cargoAtualCodigo, ca.nome, t.divisaoCodigo, d.nome, t.subdivisaoCodigo, sd.nome, u.departamentoDespesa, u.nome, t.situacao, t.cargoInicialCodigo, ci.nome, t.categoriaFuncionalCodigo, cf.nome, t.trabalhadorPK.entidade, v.nome, lc.localTrabalhoPK.codigo, lc.nome, t.aposentado, t.pensionista, ai.causaCodigo, t.efetivadoEstagioProbatorio, ci.natureza, ca.natureza, j.jornadaPK.codigo, j.nome, CASE WHEN EXISTS(SELECT 'S' FROM Usuario us WHERE us.ativo = true AND us.trabalhador = t) THEN true ELSE false END, t.usuarioLdap " + ") " + "FROM Trabalhador t " + "LEFT JOIN t.cargoInicial ci LEFT JOIN t.cargoAtual ca LEFT JOIN t.divisao d LEFT JOIN t.subdivisao sd LEFT JOIN t.unidade u LEFT JOIN t.categoriaFuncional cf LEFT JOIN t.localTrabalho lc LEFT JOIN t.vinculo v LEFT JOIN t.aposentadoInativo ai LEFT JOIN t.jornada j " + "WHERE t.trabalhadorPK.entidade = :entidadeId " + "AND coalesce(t.dataHoraInclusao, cast(t.dataAdmissao as timestamp)) BETWEEN :dataInicial AND :dataFinal";
    public static final String FIND_BY_CPF = "SELECT t FROM Trabalhador t LEFT JOIN FETCH t.salarioAtual LEFT JOIN FETCH t.salarioInicial LEFT JOIN FETCH t.cargoInicial LEFT JOIN FETCH t.cargoAtual LEFT JOIN FETCH t.vinculo LEFT JOIN FETCH t.categoriaFuncional LEFT JOIN FETCH t.localTrabalho LEFT JOIN FETCH t.divisao LEFT JOIN FETCH t.subdivisao LEFT JOIN FETCH t.unidade LEFT JOIN FETCH t.jornada LEFT JOIN FETCH t.sindicato WHERE t.documentosPessoais.cpf = :cpf ORDER BY t.contrato DESC";
    public static final String FIND_BY_ENTIDADE_CPF = "SELECT t FROM Trabalhador t WHERE t.trabalhadorPK.entidade = :entidade    AND t.documentosPessoais.cpf = :cpf ORDER BY t.dataAdmissao DESC";
    public static final String FIND_ATIVOS_AFASTADOS_BY_ENTIDADE_CPF = "SELECT t FROM Trabalhador t LEFT JOIN FETCH t.cargoInicial LEFT JOIN FETCH t.cargoAtual WHERE t.trabalhadorPK.entidade = :entidade    AND t.documentosPessoais.cpf = :cpf    AND t.situacao in ('1','3','5') ORDER BY t.dataAdmissao DESC, t.trabalhadorPK.registro DESC";
    public static final String FIND_BY_NOME_DIVISAO = "select t FROM Trabalhador t LEFT JOIN FETCH t.entidade LEFT JOIN FETCH t.divisao LEFT JOIN FETCH t.subdivisao LEFT JOIN FETCH t.cargoAtual LEFT JOIN FETCH t.vinculo LEFT JOIN FETCH t.localTrabalho WHERE t.nome LIKE concat('%', :nome, '%') AND t.divisao IN (:divisoes) AND t.situacao = '1' ORDER BY t.nome";
    public static final String FIND_BY_MAT_DIVISAO = "select t FROM Trabalhador t LEFT JOIN FETCH t.entidade LEFT JOIN FETCH t.divisao LEFT JOIN FETCH t.subdivisao LEFT JOIN FETCH t.cargoAtual LEFT JOIN FETCH t.vinculo LEFT JOIN FETCH t.localTrabalho WHERE t.matricula = :matricula AND t.divisao IN (:divisoes) AND t.situacao = '1' ORDER BY t.nome";
    public static final String FIND_BY_NOME_SUBDIVISAO = "select t FROM Trabalhador t JOIN FETCH t.entidade WHERE t.nome LIKE '%'|| :nome ||'%' AND t.subdivisao IN (:subdivisoes) ORDER BY t.nome";
    public static final String FIND_BY_EMAIL = "select t from Trabalhador t where t.dadosPessoais.email = :email AND t.dadosPessoais.usuarioWeb is not null";
    public static final String FIND_BY_USUARIO_WEB = "select t from Trabalhador t where lower(t.dadosPessoais.usuarioWeb) = lower(:usuarioWeb)";
    public static final String FIND_BY_USUARIO_WEB_TO_VALIDATION = "select t from Trabalhador t where t.trabalhadorPK <> :trabalhadorPK and lower(t.dadosPessoais.usuarioWeb) = lower(:usuarioWeb)";
    public static final String FIND_BY_USUARIO_LDAP = "select t from Trabalhador t where lower(t.usuarioLdap) = lower(:usuarioLdap)";
    public static final String FIND_BY_REF = "SELECT DISTINCT NEW br.com.fiorilli.sipweb.vo.TrabalhadorVo(t.nome, t.matricula, t.contrato, t.trabalhadorPK.registro) FROM Bases b JOIN b.trabalhador t JOIN b.referencia r JOIN t.divisao di WHERE r.mes.mesPK.ano = :ano AND r.mes.mesPK.mes = :mes AND r.tipo = :referenciaTipo AND r.entidade.codigo = :entidadeId ORDER BY t.nome";
    public static final String FIND_BY_REF_COUNT = "SELECT t.trabalhadorPK.registro FROM Bases b JOIN b.trabalhador t JOIN b.referencia r WHERE r.mes.mesPK.ano = :ano AND r.mes.mesPK.mes = :mes AND r.tipo = :referenciaTipo AND r.entidade.codigo = :entidadeId";
    public static final String FIND_BY_NOME = "SELECT t FROM Trabalhador t JOIN FETCH t.entidade en LEFT JOIN FETCH t.cargoAtual ca WHERE t.nome LIKE :nome||'%' AND t.situacao = '1' ORDER BY t.nome";
    public static final String FIND_BY_NOME_ENTIDADE = "SELECT t FROM Trabalhador t WHERE t.nome LIKE :nome||'%' AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidade ORDER BY t.nome";
    public static final String IS_SUPERVISOR = "select case when count(su.nome) > 0 then true else false end from Trabalhador tr left join tr.subdivisao su left join tr.unidade un left join tr.entidade en where (su.responsavel.trabalhadorPK = :trabalhadorPK\t\t\tor (en.tipo = :estadual and en.endereco.uf = :sp \t\t\t\tand un.responsavel.trabalhadorPK = :trabalhadorPK))";
    public static final String FIND_BY_NUMERO_CARTAO = "SELECT t FROM Trabalhador t WHERE t.ponto.numeroCartao = :numeroCartao AND t.situacao = '1'";
    public static final String FIND_FOR_FILTER = "SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo";
    public static final String QUERY_CADASTRO_TRANSPARENCIA = "SELECT NEW br.com.fiorilli.sipweb.vo.TrabalhadorTransparenciaVO(t.trabalhadorPK.entidade||t.trabalhadorPK.registro, t.nome, COALESCE(di.nome, ''), COALESCE(su.nome, ''), COALESCE(un.nome, ''), COALESCE(ca.nome, ''), COALESCE(vi.nome, ''), COALESCE(cf.nome, ''), t.dataAdmissao, t.dataDemissao) FROM Trabalhador t LEFT JOIN t.vinculo vi LEFT JOIN t.cargoAtual ca LEFT JOIN t.divisao di LEFT JOIN t.subdivisao su LEFT JOIN t.unidade un LEFT JOIN t.categoriaFuncional cf JOIN t.bases b WHERE (t.entidade.scpi.codigoNoScpi = :entidadeId) AND extract(year from t.dataAdmissao) <= :exercicio and ((t.situacao = '1') or (extract(year from t.dataDemissao) > :exercicio)) ORDER BY t.nome, t.dataAdmissao";
    public static final String QUERY_CADASTRO_TRANSPARENCIA_BY_REF = "SELECT NEW br.com.fiorilli.sipweb.vo.TrabalhadorTransparenciaVO(t.trabalhadorPK.entidade||t.trabalhadorPK.registro, t.nome, COALESCE(di.nome, ''), COALESCE(su.nome, ''), COALESCE(un.nome, ''), COALESCE(ca.nome, ''), COALESCE(vi.nome, ''), COALESCE(cf.nome, ''), t.dataAdmissao, t.dataDemissao, CASE WHEN true = :showProventos THEN b.proventosTransparencia ELSE null END, CASE WHEN true = :showDescontos THEN b.descontosTransparencia ELSE null END, CASE WHEN (true = :showLiquido AND b.proventosTransparencia IS NOT NULL AND b.descontosTransparencia IS NOT NULL) THEN (b.proventosTransparencia-b.descontosTransparencia) ELSE null END) FROM Trabalhador t LEFT JOIN t.vinculo vi LEFT JOIN t.cargoAtual ca LEFT JOIN t.divisao di LEFT JOIN t.subdivisao su LEFT JOIN t.unidade un LEFT JOIN t.categoriaFuncional cf JOIN t.bases b WHERE (t.entidade.scpi.codigoNoScpi = :codigoNoScpi) AND b.referencia.codigo = :referenciaCodigo ORDER BY t.nome, t.dataAdmissao";
    public static final String FIND_BY_ENTIDADE_MATRICULA_CONTRATO = "SELECT t FROM Trabalhador t LEFT JOIN FETCH t.dadosPessoais.instrucao LEFT JOIN FETCH t.dadosPessoais.nacionalidade LEFT JOIN FETCH t.cargoAtual LEFT JOIN FETCH t.vinculo LEFT JOIN FETCH t.localTrabalho LEFT JOIN FETCH t.jornada LEFT JOIN FETCH t.divisao LEFT JOIN FETCH t.subdivisao LEFT JOIN FETCH t.unidade LEFT JOIN FETCH t.ambienteTrabalho LEFT JOIN FETCH t.atividade WHERE t.trabalhadorPK.entidade = :entidadeCodigo AND t.matricula = :matricula AND t.contrato = :contrato";
    public static final String FIND_BY_ENTIDADE_REGISTRO = "SELECT t FROM Trabalhador t LEFT JOIN FETCH t.dadosPessoais.instrucao LEFT JOIN FETCH t.dadosPessoais.nacionalidade LEFT JOIN FETCH t.cargoAtual LEFT JOIN FETCH t.vinculo LEFT JOIN FETCH t.localTrabalho LEFT JOIN FETCH t.jornada LEFT JOIN FETCH t.divisao LEFT JOIN FETCH t.subdivisao LEFT JOIN FETCH t.unidade LEFT JOIN FETCH t.foto LEFT JOIN FETCH t.ambienteTrabalho LEFT JOIN FETCH t.atividade WHERE t.trabalhadorPK.entidade = :entidade  AND t.trabalhadorPK.registro = :registro";
    public static final String IS_TRABALHADOR_EXISTS_BY_CPF = "SELECT CASE WHEN COALESCE(COUNT(t.documentosPessoais.cpf), 0) > 0 THEN TRUE ELSE FALSE END FROM Trabalhador t WHERE t.documentosPessoais.cpf = :cpf AND t.situacao = '1'";
    public static final String IS_PERMITIDO_ADIANTAMENTO_SALARIAL = "select coalesce(v.permitirAdiantamentoSalarial, true) from Trabalhador t join t.vinculo v where t.trabalhadorPK = :trabalhadorPK";
    public static final String FIND_BY_REGISTRO = "SELECT t FROM Trabalhador t WHERE t.trabalhadorPK.entidade = :entidade and t.trabalhadorPK.registro = :registro";
    public static final String FIND_WITH_NUMERO_CARTAO_PONTO_DUPLICADO_SIP7 = "SELECT DISTINCT t1.ponto.numeroCartao FROM Trabalhador t1 WHERE t1.trabalhadorPK.entidade = :entidadeCodigo AND COALESCE(t1.ponto.numeroCartao, '') <> '' AND (t1.situacao = '1' OR t1.dataDemissao >= :primeiroDia) AND COALESCE(t1.ponto.tipo, 3) = 1 AND EXISTS (SELECT 'S' FROM Trabalhador t2             WHERE t2.trabalhadorPK.entidade = :entidadeCodigo             AND COALESCE(t2.ponto.numeroCartao, '') <> ''             AND (t2.situacao = '1' OR t2.dataDemissao >= :primeiroDia) AND COALESCE(t2.ponto.tipo, 3) = 1  AND t2.ponto.numeroCartao = t1.ponto.numeroCartao AND t2.trabalhadorPK.registro <> t1.trabalhadorPK.registro) ORDER BY t1.ponto.numeroCartao";
    public static final String FIND_WITH_NUMERO_CARTAO_PONTO_DUPLICADO_MTE1510 = "SELECT DISTINCT t1.ponto.numeroCartao FROM Trabalhador t1 WHERE t1.trabalhadorPK.entidade = :entidadeCodigo AND COALESCE(t1.ponto.numeroCartao, '') <> '' AND (t1.situacao IN ('1', '4', '5') OR t1.dataDemissao BETWEEN :primeiroDia AND :ultimoDia) AND EXISTS (SELECT 'S' FROM Trabalhador t2             WHERE  t2.trabalhadorPK.entidade = :entidadeCodigo             AND COALESCE(t2.ponto.numeroCartao, '') <> '' AND (t2.situacao IN ('1', '4', '5') OR t2.dataDemissao BETWEEN :primeiroDia AND :ultimoDia) AND t2.ponto.numeroCartao = t1.ponto.numeroCartao AND t2.trabalhadorPK.registro <> t1.trabalhadorPK.registro) ORDER BY t1.ponto.numeroCartao";
    public static final String FIND_BY_PERIODO_AND_PIS_VO = "SELECT NEW br.com.fiorilli.sip.persistence.vo.TrabalhadorBatidaVo(t.trabalhadorPK, t.documentosPessoais.pis, t.ponto.tipo, t.jornadaCodigo, t.ponto.numeroCartao, t.dataDemissao,coalesce(j.periodoInicio, '00:00'),coalesce(j.periodoFim, '23:59'), t.dataAdmissao,t.documentosPessoais.cpf)FROM Trabalhador t LEFT JOIN t.jornada j WHERE t.trabalhadorPK.entidade = :entidadeCodigo AND t.documentosPessoais.pis = :pis and t.ponto.tipo = '1' ORDER BY case when t.situacao = '1' then 0 else 1 end, t.ponto.tipo, case when t.aposentado = true then 1 else 0 end, case when j.periodoInicio is not null then 0 else 1 end";
    public static final String FIND_BY_PERIODO_AND_CPF_VO = "SELECT NEW br.com.fiorilli.sip.persistence.vo.TrabalhadorBatidaVo(t.trabalhadorPK, t.documentosPessoais.pis, t.ponto.tipo, t.jornadaCodigo, t.ponto.numeroCartao, t.dataDemissao,coalesce(j.periodoInicio, '00:00'),coalesce(j.periodoFim, '23:59'), t.dataAdmissao,t.documentosPessoais.cpf)FROM Trabalhador t LEFT JOIN t.jornada j WHERE t.trabalhadorPK.entidade = :entidadeCodigo AND t.documentosPessoais.cpf = :cpf and t.ponto.tipo = '1' ORDER BY case when t.situacao = '1' then 0 else 1 end, t.ponto.tipo, case when t.aposentado = true then 1 else 0 end, case when j.periodoInicio is not null then 0 else 1 end";
    public static final String FIND_BY_PIS_OR_CPF_BATIDA_VO = "SELECT NEW br.com.fiorilli.sip.persistence.vo.TrabalhadorBatidaVo(t.trabalhadorPK, t.documentosPessoais.pis, t.ponto.tipo, t.jornadaCodigo, t.ponto.numeroCartao, t.dataDemissao,coalesce(j.periodoInicio, '00:00'),coalesce(j.periodoFim, '23:59'), t.dataAdmissao,t.documentosPessoais.cpf)FROM Trabalhador t LEFT JOIN t.jornada j WHERE t.trabalhadorPK.entidade = :entidadeCodigo AND ((t.documentosPessoais.pis = :identificador) OR (t.documentosPessoais.cpf = :identificador)) AND :dataBatida between t.dataAdmissao and coalesce(t.dataDemissao, current_date) ORDER BY t.dataAdmissao DESC";
    public static final String FIND_BY_PERIODO_AND_MATRICULA_VO = "SELECT NEW br.com.fiorilli.sip.persistence.vo.TrabalhadorBatidaVo(t.trabalhadorPK, t.documentosPessoais.pis, t.ponto.tipo, t.jornadaCodigo, t.ponto.numeroCartao, t.dataDemissao,coalesce(j.periodoInicio, '00:00'),coalesce(j.periodoFim, '23:59'), t.dataAdmissao,t.documentosPessoais.cpf) FROM Trabalhador t LEFT JOIN t.jornada j WHERE t.trabalhadorPK.entidade = :entidadeCodigo AND t.matricula = :matricula and t.ponto.tipo = '1' ORDER BY case when t.situacao = '1' then 0 else 1 end, t.ponto.tipo, case when t.aposentado = true then 1 else 0 end, case when j.periodoInicio is not null then 0 else 1 end";
    public static final String FIND_BY_CARD_NUMBER_WITH_INT_AND_PERIODO_VO = "SELECT NEW br.com.fiorilli.sip.persistence.vo.TrabalhadorBatidaVo(t1.trabalhadorPK, t1.documentosPessoais.pis, t1.ponto.tipo, t1.jornadaCodigo, t1.ponto.numeroCartao, t1.dataDemissao,coalesce(j.periodoInicio, '00:00'),coalesce(j.periodoFim, '23:59'), t1.dataAdmissao,t1.documentosPessoais.cpf) FROM Trabalhador t1 LEFT JOIN t1.jornada j WHERE t1.trabalhadorPK.entidade = :entidade and ((TRIM(coalesce(t1.ponto.numeroCartao, '')) <> '') and ((t1.ponto.numeroCartao = :numeroCartao)  or ((cast(TRIM(coalesce(t1.ponto.numeroCartao, '0')) as long) = :numeroCartao)))) and t1.ponto.tipo = '1' ORDER BY case when t1.situacao = '1' then 0 else 1 end, t1.ponto.tipo, case when t1.aposentado = true then 1 else 0 end, case when j.periodoInicio is not null then 0 else 1 end";
    public static final String FIND_BY_GRUPOPONTO = "select t FROM Trabalhador t JOIN FETCH t.entidade LEFT JOIN FETCH t.jornada WHERE t.grupoPonto IN (:grupoponto) AND t.ponto.tipo = '1' AND t.ponto.numeroCartao is not null AND t.ponto.numeroCartao <> '' AND t.situacao = '1' ORDER BY t.nome";
    @EmbeddedId
    protected TrabalhadorPK trabalhadorPK;
    @FilterConfig(label="Matr\u00edcula", condition=FilterCondition.COMECE, order=3)
    @Column(name="MATRICULA")
    private Integer matricula;
    @Column(name="CONTRATO")
    private Short contrato;
    @SearchNome
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE, order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @FilterConfig(condition=FilterCondition.IGUAL, blockCondition=true, inputType=FilterInputType.SELECT_ONE_MENU, label="Situa\u00e7\u00e3o", order=7)
    @FilterConfigEnum(enumClass=TrabalhadorSituacao.class, enumId="codigo", itemLabel="descricao")
    @Size(max=1)
    @Column(name="SITUACAO")
    private String situacao;
    @Column(name="DTNASCIMENTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataNascimento;
    @Embedded
    private TrabalhadorDadosPessoais dadosPessoais;
    @Embedded
    private TrabalhadorDocumentosPessoais documentosPessoais;
    @Embedded
    private TrabalhadorLegislacaoAdmissaoDocumento legislacaoAdmissaoDocumento;
    @Column(name="DTADMISSAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataAdmissao;
    @Size(max=2)
    @Column(name="TIPOADMISSAO")
    private String tipoAdmissao;
    @Column(name="TIPO_REGIME_JORNADA")
    private Integer tipoRegimeJornada;
    @Size(max=1)
    @Column(name="TIPOCARGOATUAL")
    private String tipoCargoAtual;
    @Column(name="DTADMUCARGO")
    @Temporal(value=TemporalType.DATE)
    private Date dataAdmissaoUltimoCargo;
    @Column(name="DTTEMPOSERVICO")
    @Temporal(value=TemporalType.DATE)
    private Date dttemposervico;
    @Column(name="DTCTRLREFSAL")
    @Temporal(value=TemporalType.DATE)
    private Date dataControleSalario;
    @Column(name="HORASEMANAL")
    private BigDecimal horasSemanal;
    @Column(name="DIASSEMANA")
    private BigDecimal diasSemana;
    @Column(name="HORASMES")
    private BigDecimal horasMes;
    @Type(type="BooleanTypeSip")
    @Column(name="COMPLSAL")
    private Boolean complsal;
    @Embedded
    private TrabalhadorPonto ponto;
    @Column(name="DTSITUACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dtsituacao;
    @Column(name="QTDEPREVIDENCIA")
    private Double quantidadePrevidencia;
    @Column(name="PREVCONFORME")
    private Short previdenciaConforme;
    @Column(name="CALCIRRF")
    private Short calculoIRRF;
    @Column(name="FGTSOPTANTE")
    @Type(type="BooleanTypeSip")
    private Boolean fgtsOptante;
    @Column(name="DTFGTSOPCAO")
    @Temporal(value=TemporalType.DATE)
    private Date dtFgtsOpcao;
    @Size(max=11)
    @Column(name="MATRICULACEF")
    private String matriculacef;
    @Size(max=2)
    @Column(name="ADTO13SALNIVER")
    private String adiantamento13SalarioAutomaticoMensal;
    @Column(name="QTDEMESES_CARENCIA13")
    private Integer mesesCarencia13;
    @Size(max=1)
    @Column(name="APOSUMANO")
    private String carenciaAdiantamento13Salario;
    @Type(type="BooleanTypeSip")
    @Column(name="CESTABASICA")
    private Boolean cestabasica;
    @Type(type="BooleanTypeSip")
    @Column(name="ADTOMENSAL")
    private Boolean adtomensal;
    @Column(name="SEFIPTPOCORR")
    private String sefipTipoOcorrencia;
    @Column(name="SEFIPVLRPREVMENSAL")
    private Double sefipvlrprevmensal;
    @Column(name="SEFIPVLRPREV13SAL")
    private Double sefipvlrprev13sal;
    @Type(type="BooleanTypeSip")
    @Column(name="TEMPOSERVICO")
    private Boolean temposervico;
    @Type(type="BooleanTypeSip")
    @Column(name="CALCULAR_14_SALARIO")
    private Boolean calcular14salario;
    @Column(name="DTDEMISSAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataDemissao;
    @Size(max=3)
    @Column(name="CLT_OU_ESTATUTO")
    private String cltOuEstatuto;
    @Size(max=16)
    @Column(name="CARGOATUAL_NUMDOC")
    private String cargoatualNumdoc;
    @Column(name="DH_INCLUIU")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraInclusao;
    @Column(name="DH_ALTEROU")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataHoraAlteracao;
    @Column(name="LETRA_SEXO")
    private Character letraSexo;
    @Size(max=10)
    @Column(name="MATRICULASIP6")
    private String matriculaAnterior;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DTADMISSAO_ENTIDADE_CEDENTE")
    private Date dataInicioVinculoAnterior;
    @Size(max=16)
    @Column(name="PROCESSO")
    private String processo;
    @Size(max=16)
    @Column(name="ADITIVO")
    private String aditivo;
    @Size(max=16)
    @Column(name="DOCADM_NUMERO")
    private String docadmNumero;
    @Size(max=16)
    @Column(name="EDITAL")
    private String edital;
    @Column(name="DTTERMINO")
    @Temporal(value=TemporalType.DATE)
    private Date dataTermino;
    @Type(type="BooleanTypeSip")
    @Column(name="APOSENTADO")
    private Boolean aposentado;
    @Type(type="BooleanTypeSip")
    @Column(name="FALTA_ABONADA")
    private Boolean faltaAbonada;
    @Column(name="QTDE_ABONADA")
    private Short qtdeAbonada;
    @Type(type="BooleanTypeSip")
    @Column(name="DIADEMISSAOTRABALHADO")
    private Boolean diaDemissaoTrabalhado;
    @Type(type="BooleanTypeSip")
    @Column(name="PENSIONISTA")
    private Boolean pensionista;
    @Column(name="DATA_CONCESSAO_PENSAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataConcessaoPensao;
    @Column(name="HORAS_EFETIVAS")
    private BigDecimal horasEfetivas;
    @Type(type="BooleanTypeSip")
    @Column(name="REPOSICAO_VAGA")
    private Boolean reposicaoVaga;
    @Column(name="DTRPPS")
    @Temporal(value=TemporalType.DATE)
    private Date dtrpps;
    @Size(max=1)
    @Column(name="TIPOCARGOINICIAL")
    private String tipoCargoInicial;
    @Column(name="sipweb_ultimo_acesso")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date ultimoAcessoAoSipweb;
    @Type(type="BooleanTypeSip")
    @Column(name="TSREGISTROS_RESCINDIDOS")
    private Boolean tsregistrosRescindidos;
    @Column(name="ANOS_PARA_APOSENTAR")
    private Short anosParaAposentar;
    @Column(name="DOCADM_DATA")
    @Temporal(value=TemporalType.DATE)
    private Date docadmData;
    @Type(type="BooleanTypeSip")
    @Column(name="RATEAR")
    private Boolean ratear;
    @Type(type="BooleanTypeSip")
    @Column(name="FUNCIONARIO_RPPS")
    private Boolean funcionarioRpps;
    @Column(name="ID_CADUNICO")
    private Double idCadunico;
    @Type(type="BooleanTypeSip")
    @Column(name="BANCO_HORAS_TRAB")
    private Boolean bancoHorasTrabalhador;
    @Size(max=16)
    @Column(name="NUM_PROCESSO_DEMISSAO")
    private String numProcessoDemissao;
    @Size(max=16)
    @Column(name="NUM_REGISTRO_TCE")
    private String numRegistroTce;
    @Column(name="REGISTROINT")
    private Integer registroint;
    @Column(name="DTINICIO_VT")
    @Temporal(value=TemporalType.DATE)
    private Date dtinicioVt;
    @Column(name="DTFIM_VT")
    @Temporal(value=TemporalType.DATE)
    private Date dtfimVt;
    @Column(name="DATA_CONCESSAO_APOSENTADORIA")
    @Temporal(value=TemporalType.DATE)
    private Date dataConcessaoAposentadoria;
    @Size(max=15)
    @Column(name="NUM_CONCESSAO_APOSENTADORIA")
    private String numeroConcessaoAposentadoria;
    @Embedded
    private TrabalhadorTceMs trabalhadorTceMs;
    @Size(max=21)
    @Column(name="CTCNUMERO")
    private String ctcnumero;
    @Column(name="CTCDATA")
    @Temporal(value=TemporalType.DATE)
    private Date ctcdata;
    @Column(name="RGPS_ANOS")
    private Short rgpsAnos;
    @Column(name="RGPS_MESES")
    private Short rgpsMeses;
    @Column(name="RGPS_DIAS")
    private Short rgpsDias;
    @Column(name="RPPS_ANOS")
    private Short rppsAnos;
    @Column(name="RPPS_MESES")
    private Short rppsMeses;
    @Column(name="RPPS_DIAS")
    private Short rppsDias;
    @Column(name="DTNOMEACAO")
    @Temporal(value=TemporalType.DATE)
    private Date dataNomeacao;
    @Column(name="DTPOSSE")
    @Temporal(value=TemporalType.DATE)
    private Date dataPosse;
    @Column(name="RGPS_ANOS_PRIVADO")
    private Short rgpsAnosPrivado;
    @Column(name="RGPS_MESES_PRIVADO")
    private Short rgpsMesesPrivado;
    @Column(name="RGPS_DIAS_PRIVADO")
    private Short rgpsDiasPrivado;
    @Column(name="RGPS_ANOS_PUBLICO")
    private Short rgpsAnosPublico;
    @Column(name="RGPS_MESES_PUBLICO")
    private Short rgpsMesesPublico;
    @Column(name="RGPS_DIAS_PUBLICO")
    private Short rgpsDiasPublico;
    @Column(name="DTEXERCICIO")
    @Temporal(value=TemporalType.DATE)
    private Date dataExercicio;
    @Column(name="DOCADM_DATAPUBLICACAO")
    @Temporal(value=TemporalType.DATE)
    private Date docadmDatapublicacao;
    @Type(type="BooleanTypeSip")
    @Column(name="PENSIONISTA_PARIDADE")
    private Boolean pensionistaParidade;
    @Column(name="INTEGRACAO_TCE_MG_ID")
    private Integer integracaoTceMgId;
    @Embedded
    private TrabalhadorEstadoSaoPaulo dadosEstadoSaoPaulo;
    @Column(name="VINCULO")
    private String vinculoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="VINCULO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Vinculo vinculo;
    @JoinColumn(name="DOCADM_VEICULOPUBLICACAO", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private VeiculoPublicacao docadmVeiculopublicacao;
    @JoinColumn(name="USUARIO_INCLUIU", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioIncluiu;
    @JoinColumn(name="USUARIO_ALTEROU", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Usuario usuarioAlterou;
    @Column(name="DEPDESPESA")
    private Integer unidadeCodigo;
    @JoinColumn(name="DEPDESPESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Unidade unidade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="TRABARQUIVO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private TrabalhadorArquivo trabalhadorArquivo;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private TrabalhadorFoto foto;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGOTOMADOROBRA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private TomadorObra tomadorobra;
    @Column(name="CODIGOTOMADOROBRA")
    private Integer tomadorObraCodigo;
    @JoinColumn(name="CARGOATUAL_TIPOLEGAL", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal cargoatualTipolegal;
    @JoinColumn(name="DOCADM_TIPODOC", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private TipoDocumentoLegal docadmTipodoc;
    @Column(name="TIPOSAL", length=2)
    private String tipoSalario;
    @JoinColumn(name="ESCOLA_TECNICA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private EscolaTecnica escolaTecnica;
    @Column(name="ESCOLA_TECNICA")
    private Integer escolaTecnicaCodigo;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Size(min=1, max=6)
    @Column(name="DIVISAO")
    private String divisaoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="DIVISAO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Divisao divisao;
    @JoinColumn(name="CONCURSO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Concurso concurso;
    @Column(name="CONCURSO")
    private Integer concursoCodigo;
    @JoinColumn(name="CATSEFIP", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private CategoriaSefip categoriaSefip;
    @Column(name="CATSEFIP")
    private String categoriaSefipCodigo;
    @Column(name="CATFUNCIONAL")
    private Integer categoriaFuncionalCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CATFUNCIONAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private CategoriaFuncional categoriaFuncional;
    @Basic(optional=false)
    @Size(min=1, max=4)
    @Column(name="CARGOINICIAL")
    private String cargoInicialCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGOINICIAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Cargo cargoInicial;
    @Basic(optional=false)
    @Size(min=1, max=4)
    @Column(name="CARGOATUAL")
    private String cargoAtualCodigo;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGOATUAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Cargo cargoAtual;
    @JoinColumn(name="IDCADPORTARIA", referencedColumnName="IDCADPORTARIA")
    @ManyToOne(fetch=FetchType.LAZY)
    private PessoaPortaria pessoaPortaria;
    @Column(name="ATIVIDADE")
    private Integer atividadeCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="ATIVIDADE", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Atividade atividade;
    @Size(min=1, max=6)
    @Column(name="LOCAL_TRABALHO")
    private String localTrabalhoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="LOCAL_TRABALHO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private LocalTrabalho localTrabalho;
    @JoinColumn(name="ORGAOSIPREV", referencedColumnName="CODIGO")
    @ManyToOne(fetch=FetchType.LAZY)
    private Orgaosiprev orgaosiprev;
    @Basic(optional=false)
    @Size(min=1, max=10)
    @Column(name="REFSALINICIAL")
    private String salarioInicialCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REFSALINICIAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Salario salarioInicial;
    @Basic(optional=false)
    @Size(min=1, max=10)
    @Column(name="REFSALATUAL")
    private String salarioAtualCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REFSALATUAL", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.EAGER)
    private Salario salarioAtual;
    @JoinColumn(name="SINDICATO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Sindicato sindicato;
    @Column(name="SINDICATO")
    private Integer sindicatoCodigo;
    @JoinColumn(name="SIPREV_FUNCIONAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private SiprevSituacaoFuncional siprevSituacaoFuncional;
    @Column(name="SIPREV_FUNCIONAL")
    private String siprevSituacaoFuncionalCodigo;
    @JoinColumn(name="SIPREV_SITUACAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private SiprevSituacaoPrevidenciaria siprevSituacaoPrevidenciaria;
    @Column(name="SIPREV_SITUACAO")
    private String siprevSituacaoPrevidenciariaCodigo;
    @JoinColumn(name="SIPREV_VINCORGAO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private SiprevVinculoOrgao siprevVinculoOrgao;
    @Column(name="SIPREV_VINCORGAO")
    private String siprevVinculoOrgaoCodigo;
    @Column(name="JORNADA")
    private Short jornadaCodigo;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="JORNADA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Jornada jornada;
    @Size(min=1, max=6)
    @Column(name="SUBDIVISAO")
    private String subdivisaoCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="SUBDIVISAO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Subdivisao subdivisao;
    @Column(name="LDAP_CONFIG_ID")
    private Integer ldapConfigId;
    @JoinColumn(name="LDAP_CONFIG_ID", referencedColumnName="ID", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private LdapConfig ldapConfig;
    @Column(name="USUARIO_LDAP", length=60)
    private String usuarioLdap;
    @JoinColumn(name="NIVEL_CARGO", referencedColumnName="ID", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private CargoNivel cargoNivel;
    @Column(name="NIVEL_CARGO")
    private Integer cargoNivelCodigo;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<HistoricoTrabalhadorNome> historicoNome;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador")
    private List<Bases> bases;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Falta> faltaList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Ferias> feriasList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<LicencaPremio> licencaPremioList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador")
    private List<RppsHistoricoPrecidenciario> rpssHistoricosFinanceiros;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventoFixo> eventoFixoList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventoFolhaComplementar> eventoFolhaComplementar;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador")
    private List<SolicitacaoAdiantamento13Salario> solicitacaoAdiantamento13SalarioList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador")
    private List<Pcmso> pcmsoList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TrabalhadorConta> contaList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Eventuais> eventuaisList;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador")
    private List<RegistroControleEpi> controleEpiList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<MovimentoSefip> movimentoSefipList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY)
    private List<Movimento> movimentoList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY)
    private List<LicencaPremioMovimento> movtolicencapremioList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BeneficiarioPensaoAlimenticia> beneficiariosPensaoList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY)
    private List<Histcargosal> histCargoSalarioList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<HistoricoTrabalhadorCargo> historicoCargoList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<HistoricoTrabalhadorSalario> historicoSalarioList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<HistoricoTrabalhadorSalarioInicial> historicoSalarioInicialList;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY)
    private List<HistoricoTrabalhadorDivisao> historicoDivisao;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<HistoricoTrabalhadorSubdivisao> historicoSubdivisao;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<HistoricoTrabalhadorLocalTrabalho> historicoLocalTrabalho;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<HistoricoTrabalhadorUnidade> historicoUnidade;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<HistoricoTrabalhadorAtividade> historicoAtividade;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Aposentado aposentadoInativo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private SipmtTrabalhador tceMt;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private SiprnTrabalhador tceRn;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private SiprjTrabalhador tceRj;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private SipprAtividadeTrabalhador tcePr;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private SipbaTrabalhador tceBa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private SiopeTrabalhador siopeTrabalhador;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Dependente> dependentes;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY)
    private List<PontoFacultativoNominal> pontoFacultativoNominal;
    @JoinColumn(name="ID_ENTIDADE_CEDENTE", referencedColumnName="ID", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private EntidadeCedente cedente;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhadorRegistroMorto", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<Pensionista> pensionistas;
    @Column(name="CAT_TRAB_ESOCIAL")
    private String categoriaESocialCodigo;
    @Type(type="BooleanTypeSip")
    @Column(name="FILIACAO_SINDICAL")
    private Boolean filiacaoSindical;
    @Enumerated
    @Column(name="SITUACAO_FUNCIONAL")
    private SituacaoFuncional situacaoFuncional;
    @Column(name="NOME_SOCIAL")
    @Size(max=254)
    private String nomeSocial;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private TrabalhadorTcmgo tcmgo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private TrabObs observacoes;
    @OneToMany(mappedBy="trabalhador", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<DocumentoAdmissao> documentosAdmissao;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TrabalhadorDocumentosJustificativaAdmissaoPDF> justificativaAdmissao;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TrabalhadorValeTransporte> valeTransporte;
    @OneToOne(mappedBy="trabalhadorPensionista", fetch=FetchType.LAZY)
    private Pensionista pensao;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL})
    private List<NaoOptanteIncidencia> naoOptanteEventos;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private SipMgTrabalhador sipMgTrabalhador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SUBDIVISAOITEM", referencedColumnName="ID", insertable=false, updatable=false)
    private SubdivisaoItem subdivisaoItem;
    @Type(type="BooleanTypeSip")
    @Column(name="EFETIVADO_ESTAGIO_PROBATORIO")
    private Boolean efetivadoEstagioProbatorio;
    @Type(type="BooleanTypeSip")
    @Column(name="VALEALIMENTACAO")
    private Boolean valeAlimentacao;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL})
    private List<CtrlMargemConsignavel> ctrlMargemConsignavelList;
    @Column(name="GRUPO_PONTO")
    private Short grupoPontoCodigo;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="GRUPO_PONTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private GrupoPonto grupoPonto;
    @Column(name="ID_BIOMETRIA")
    private Integer idBiometria;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BIOMETRIA", referencedColumnName="ID", insertable=false, updatable=false)
    private PessoaBiometria biometria;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL})
    private List<BancoHorasLancamento> bancoHorasLancamentos;
    @JoinColumn(name="DOCDIGITAL_APOSENTADORIA", referencedColumnName="IDDOCDIGITAL")
    @ManyToOne(fetch=FetchType.LAZY)
    private DocumentoDigital docDigitalAposentadoria;
    @JoinColumn(name="DOCDIGITAL_PENSAO", referencedColumnName="IDDOCDIGITAL")
    @ManyToOne(fetch=FetchType.LAZY)
    private DocumentoDigital docDigitalPensao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="AMBIENTE_TRABALHO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private AmbienteTrabalho ambienteTrabalho;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private AposentadoriaTCESP aposentadoriaTCESP;
    @Column(name="DTCHEGADA")
    @Temporal(value=TemporalType.DATE)
    private Date dataChegada;
    @Type(type="DocumentosApresentados")
    @Column(name="DOCUMENTOS_APRESENTADOS")
    private List<TrabalhadorDocumentoApresentado> documentoApresentados;
    @Embedded
    private TrabalhadorTemporarioDocumento temporarioDocumento;
    @Column(name="PRAZO_MAXIMO_CONTRATACAO_TEMP")
    private Integer prazoMaximoContratacaoTemporario;
    @Column(name="CODIGO_ESOCIAL")
    private String codigoEsocial;
    @Transient
    private Map<String, String> camposUsuario;
    @Column(name="ID_FACIAL")
    private Integer idFacial;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="responsavel", cascade={CascadeType.ALL})
    private List<LocalTrabalho> locaisTrabalhoResponsavel;
    @Column(name="TIPO_PENSAO_ESOCIAL")
    @Size(max=4)
    private String tipoPensaoEsocial;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL}, orphanRemoval=true)
    private LotacaoTCESP lotacaoTCESP;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CARGO_CONCURSO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private ConcursoCargo cargoConcurso;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trabalhador", cascade={CascadeType.ALL})
    private List<SipwebSolicitacaoAfastamento> solicitacoesAfastamentos;

    public static Trabalhador createInitialized(String codigoEntidade) {
        Trabalhador t = new Trabalhador();
        t.setTrabalhadorPK(new TrabalhadorPK());
        t.getTrabalhadorPK().setEntidade(codigoEntidade);
        return t;
    }

    public Trabalhador() {
    }

    public Trabalhador(TrabalhadorPK trabalhadorPK) {
        this.trabalhadorPK = trabalhadorPK;
    }

    public Trabalhador(String entidade, String registro) {
        this.trabalhadorPK = new TrabalhadorPK(entidade, registro);
    }

    public Trabalhador(Integer matricula, Short contrato) {
        this.matricula = matricula;
        this.contrato = contrato;
    }

    public TrabalhadorPK getTrabalhadorPK() {
        if (this.trabalhadorPK == null) {
            this.trabalhadorPK = new TrabalhadorPK();
        }
        return this.trabalhadorPK;
    }

    public void setTrabalhadorPK(TrabalhadorPK trabalhadorPK) {
        this.trabalhadorPK = trabalhadorPK;
    }

    public Integer getMatricula() {
        return this.matricula;
    }

    public void setMatricula(Integer matricula) {
        this.matricula = matricula;
    }

    public Short getContrato() {
        return this.contrato;
    }

    public void setContrato(Short contrato) {
        this.contrato = contrato;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Date getDataNascimento() {
        return this.dataNascimento;
    }

    public void setDataNascimento(Date dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    public TrabalhadorDadosPessoais getDadosPessoais() {
        return this.dadosPessoais;
    }

    public void setDadosPessoais(TrabalhadorDadosPessoais dadosPessoais) {
        this.dadosPessoais = dadosPessoais;
    }

    public Date getDataAdmissao() {
        return this.dataAdmissao;
    }

    public void setDataAdmissao(Date dataAdmissao) {
        this.dataAdmissao = dataAdmissao;
    }

    public TipoAdmissao getTipoAdmissao() {
        return TipoAdmissao.of(this.tipoAdmissao);
    }

    public void setTipoAdmissao(TipoAdmissao tipoAdmissao) {
        this.tipoAdmissao = tipoAdmissao.getCodigo();
    }

    public String getTipoCargoAtual() {
        return this.tipoCargoAtual;
    }

    public void setTipoCargoAtual(String tipocargoatual) {
        this.tipoCargoAtual = tipocargoatual;
    }

    public Date getDataAdmissaoUltimoCargo() {
        return this.dataAdmissaoUltimoCargo;
    }

    public void setDataAdmissaoUltimoCargo(Date dtadmucargo) {
        this.dataAdmissaoUltimoCargo = dtadmucargo;
    }

    public Date getDttemposervico() {
        return this.dttemposervico;
    }

    public void setDttemposervico(Date dttemposervico) {
        this.dttemposervico = dttemposervico;
    }

    public Date getDataControleSalario() {
        return this.dataControleSalario;
    }

    public void setDataControleSalario(Date dtctrlrefsal) {
        this.dataControleSalario = dtctrlrefsal;
    }

    public BigDecimal getHorasSemanal() {
        return this.horasSemanal;
    }

    public void setHorasSemanal(BigDecimal horasemanal) {
        this.horasSemanal = horasemanal;
    }

    public BigDecimal getDiasSemana() {
        return this.diasSemana;
    }

    public void setDiasSemana(BigDecimal diassemana) {
        this.diasSemana = diassemana;
    }

    public BigDecimal getHorasMes() {
        return this.horasMes;
    }

    public void setHorasMes(BigDecimal horasmes) {
        this.horasMes = horasmes;
    }

    public Date getDtsituacao() {
        return this.dtsituacao;
    }

    public void setDtsituacao(Date dtsituacao) {
        this.dtsituacao = dtsituacao;
    }

    public Double getQuantidadePrevidencia() {
        return this.quantidadePrevidencia;
    }

    public void setQuantidadePrevidencia(Double qtdeprevidencia) {
        this.quantidadePrevidencia = qtdeprevidencia;
    }

    public TrabalhadorPrevidenciaConforme getPrevidenciaConforme() {
        return TrabalhadorPrevidenciaConforme.toEntity(this.previdenciaConforme);
    }

    public void setPrevidenciaConforme(TrabalhadorPrevidenciaConforme previdenciaConforme) {
        this.previdenciaConforme = previdenciaConforme.getId();
    }

    public TrabalhadorCalculoIRRF getCalculoIRRF() {
        return TrabalhadorCalculoIRRF.get(this.calculoIRRF.shortValue());
    }

    public void setCalculoIRRF(TrabalhadorCalculoIRRF calculoIRRF) {
        this.calculoIRRF = (short)calculoIRRF.getCodigo();
    }

    public Date getDtFgtsOpcao() {
        return this.dtFgtsOpcao;
    }

    public void setDtFgtsOpcao(Date dtfgtsopcao) {
        this.dtFgtsOpcao = dtfgtsopcao;
    }

    public String getMatriculacef() {
        return this.matriculacef;
    }

    public void setMatriculacef(String matriculacef) {
        this.matriculacef = matriculacef;
    }

    public String getAdiantamento13SalarioAutomaticoMensal() {
        return this.adiantamento13SalarioAutomaticoMensal;
    }

    public void setAdiantamento13SalarioAutomaticoMensal(String adiantamento13SalarioAutomaticoMensal) {
        this.adiantamento13SalarioAutomaticoMensal = adiantamento13SalarioAutomaticoMensal;
    }

    public String getCarenciaAdiantamento13Salario() {
        return this.carenciaAdiantamento13Salario;
    }

    public void setCarenciaAdiantamento13Salario(String aposumano) {
        this.carenciaAdiantamento13Salario = aposumano;
    }

    public SefipTipoOcorrencia getSefipTipoOcorrencia() {
        return SefipTipoOcorrencia.get(this.sefipTipoOcorrencia);
    }

    public void setSefipTipoOcorrencia(SefipTipoOcorrencia sefiptpocorr) {
        this.sefipTipoOcorrencia = sefiptpocorr.getCodigo();
    }

    public Double getSefipvlrprevmensal() {
        return this.sefipvlrprevmensal;
    }

    public void setSefipvlrprevmensal(Double sefipvlrprevmensal) {
        this.sefipvlrprevmensal = sefipvlrprevmensal;
    }

    public Double getSefipvlrprev13sal() {
        return this.sefipvlrprev13sal;
    }

    public void setSefipvlrprev13sal(Double sefipvlrprev13sal) {
        this.sefipvlrprev13sal = sefipvlrprev13sal;
    }

    public Date getDataDemissao() {
        return this.dataDemissao;
    }

    public void setDataDemissao(Date dataDemissao) {
        this.dataDemissao = dataDemissao;
    }

    public String getCltOuEstatuto() {
        return this.cltOuEstatuto;
    }

    public void setCltOuEstatuto(String cltOuEstatuto) {
        this.cltOuEstatuto = cltOuEstatuto;
    }

    public String getCargoatualNumdoc() {
        return this.cargoatualNumdoc;
    }

    public void setCargoatualNumdoc(String cargoatualNumdoc) {
        this.cargoatualNumdoc = cargoatualNumdoc;
    }

    public Date getDataHoraInclusao() {
        return this.dataHoraInclusao;
    }

    public void setDataHoraInclusao(Date dhIncluiu) {
        this.dataHoraInclusao = dhIncluiu;
    }

    public Date getDataHoraAlteracao() {
        return this.dataHoraAlteracao;
    }

    public void setDataHoraAlteracao(Date dhAlterou) {
        this.dataHoraAlteracao = dhAlterou;
    }

    public Character getLetraSexo() {
        return this.letraSexo;
    }

    public void setLetraSexo(Character letraSexo) {
        this.letraSexo = letraSexo;
    }

    public String getMatriculaAnterior() {
        return this.matriculaAnterior;
    }

    public void setMatriculaAnterior(String matriculasip6) {
        this.matriculaAnterior = matriculasip6;
    }

    public String getProcesso() {
        return this.processo;
    }

    public void setProcesso(String processo) {
        this.processo = processo;
    }

    public String getDocadmNumero() {
        return this.docadmNumero;
    }

    public void setDocadmNumero(String docadmNumero) {
        this.docadmNumero = docadmNumero;
    }

    public String getEdital() {
        return this.edital;
    }

    public void setEdital(String edital) {
        this.edital = edital;
    }

    public Date getDataTermino() {
        return this.dataTermino;
    }

    public void setDataTermino(Date dttermino) {
        this.dataTermino = dttermino;
    }

    public Short getQtdeAbonada() {
        return this.qtdeAbonada;
    }

    public void setQtdeAbonada(Short qtdeAbonada) {
        this.qtdeAbonada = qtdeAbonada;
    }

    public BigDecimal getHorasEfetivas() {
        return this.horasEfetivas;
    }

    public void setHorasEfetivas(BigDecimal horasEfetivas) {
        this.horasEfetivas = horasEfetivas;
    }

    public Date getDtrpps() {
        return this.dtrpps;
    }

    public void setDtrpps(Date dtrpps) {
        this.dtrpps = dtrpps;
    }

    public String getTipoCargoInicial() {
        return this.tipoCargoInicial;
    }

    public void setTipoCargoInicial(String tipocargoinicial) {
        this.tipoCargoInicial = tipocargoinicial;
    }

    public Short getAnosParaAposentar() {
        return this.anosParaAposentar;
    }

    public void setAnosParaAposentar(Short anosParaAposentar) {
        this.anosParaAposentar = anosParaAposentar;
    }

    public Date getDocadmData() {
        return this.docadmData;
    }

    public void setDocadmData(Date docadmData) {
        this.docadmData = docadmData;
    }

    public Double getIdCadunico() {
        return this.idCadunico;
    }

    public void setIdCadunico(Double idCadunico) {
        this.idCadunico = idCadunico;
    }

    public String getNumProcessoDemissao() {
        return this.numProcessoDemissao;
    }

    public void setNumProcessoDemissao(String numProcessoDemissao) {
        this.numProcessoDemissao = numProcessoDemissao;
    }

    public String getNumRegistroTce() {
        return this.numRegistroTce;
    }

    public void setNumRegistroTce(String numRegistroTce) {
        this.numRegistroTce = numRegistroTce;
    }

    public Integer getRegistroint() {
        return this.registroint;
    }

    public void setRegistroint(Integer registroint) {
        this.registroint = registroint;
    }

    public Date getDtinicioVt() {
        return this.dtinicioVt;
    }

    public void setDtinicioVt(Date dtinicioVt) {
        this.dtinicioVt = dtinicioVt;
    }

    public Date getDtfimVt() {
        return this.dtfimVt;
    }

    public void setDtfimVt(Date dtfimVt) {
        this.dtfimVt = dtfimVt;
    }

    public Date getDataConcessaoAposentadoria() {
        return this.dataConcessaoAposentadoria;
    }

    public void setDataConcessaoAposentadoria(Date dataConcessaoAposentadoria) {
        this.dataConcessaoAposentadoria = dataConcessaoAposentadoria;
    }

    public String getNumeroConcessaoAposentadoria() {
        return this.numeroConcessaoAposentadoria;
    }

    public void setNumeroConcessaoAposentadoria(String numConcessaoAposentadoria) {
        this.numeroConcessaoAposentadoria = numConcessaoAposentadoria;
    }

    public String getCtcnumero() {
        return this.ctcnumero;
    }

    public void setCtcnumero(String ctcnumero) {
        this.ctcnumero = ctcnumero;
    }

    public Date getCtcdata() {
        return this.ctcdata;
    }

    public void setCtcdata(Date ctcdata) {
        this.ctcdata = ctcdata;
    }

    public Short getRgpsAnos() {
        return this.rgpsAnos;
    }

    public void setRgpsAnos(Short rgpsAnos) {
        this.rgpsAnos = rgpsAnos;
    }

    public Short getRgpsMeses() {
        return this.rgpsMeses;
    }

    public void setRgpsMeses(Short rgpsMeses) {
        this.rgpsMeses = rgpsMeses;
    }

    public Short getRgpsDias() {
        return this.rgpsDias;
    }

    public void setRgpsDias(Short rgpsDias) {
        this.rgpsDias = rgpsDias;
    }

    public Short getRppsAnos() {
        return this.rppsAnos;
    }

    public void setRppsAnos(Short rppsAnos) {
        this.rppsAnos = rppsAnos;
    }

    public Short getRppsMeses() {
        return this.rppsMeses;
    }

    public void setRppsMeses(Short rppsMeses) {
        this.rppsMeses = rppsMeses;
    }

    public Short getRppsDias() {
        return this.rppsDias;
    }

    public void setRppsDias(Short rppsDias) {
        this.rppsDias = rppsDias;
    }

    public Date getDataNomeacao() {
        return this.dataNomeacao;
    }

    public void setDataNomeacao(Date dataNomeacao) {
        this.dataNomeacao = dataNomeacao;
    }

    public Date getDataPosse() {
        return this.dataPosse;
    }

    public void setDataPosse(Date dataPosse) {
        this.dataPosse = dataPosse;
    }

    public Short getRgpsAnosPrivado() {
        return this.rgpsAnosPrivado;
    }

    public void setRgpsAnosPrivado(Short rgpsAnosPrivado) {
        this.rgpsAnosPrivado = rgpsAnosPrivado;
    }

    public Short getRgpsMesesPrivado() {
        return this.rgpsMesesPrivado;
    }

    public void setRgpsMesesPrivado(Short rgpsMesesPrivado) {
        this.rgpsMesesPrivado = rgpsMesesPrivado;
    }

    public Short getRgpsDiasPrivado() {
        return this.rgpsDiasPrivado;
    }

    public void setRgpsDiasPrivado(Short rgpsDiasPrivado) {
        this.rgpsDiasPrivado = rgpsDiasPrivado;
    }

    public Short getRgpsAnosPublico() {
        return this.rgpsAnosPublico;
    }

    public void setRgpsAnosPublico(Short rgpsAnosPublico) {
        this.rgpsAnosPublico = rgpsAnosPublico;
    }

    public Short getRgpsMesesPublico() {
        return this.rgpsMesesPublico;
    }

    public void setRgpsMesesPublico(Short rgpsMesesPublico) {
        this.rgpsMesesPublico = rgpsMesesPublico;
    }

    public Short getRgpsDiasPublico() {
        return this.rgpsDiasPublico;
    }

    public void setRgpsDiasPublico(Short rgpsDiasPublico) {
        this.rgpsDiasPublico = rgpsDiasPublico;
    }

    public Date getDataExercicio() {
        return this.dataExercicio;
    }

    public void setDataExercicio(Date dataExercicio) {
        this.dataExercicio = dataExercicio;
    }

    public Date getDocadmDatapublicacao() {
        return this.docadmDatapublicacao;
    }

    public void setDocadmDatapublicacao(Date docadmDatapublicacao) {
        this.docadmDatapublicacao = docadmDatapublicacao;
    }

    public Boolean getComplsal() {
        return this.complsal;
    }

    public void setComplsal(Boolean complsal) {
        this.complsal = complsal;
    }

    public Boolean getFgtsOptante() {
        return this.fgtsOptante;
    }

    public void setFgtsOptante(Boolean ftgsOptante) {
        this.fgtsOptante = ftgsOptante;
    }

    public Boolean getCestabasica() {
        return this.cestabasica;
    }

    public void setCestabasica(Boolean cestabasica) {
        this.cestabasica = cestabasica;
    }

    public Boolean getAdtomensal() {
        return this.adtomensal;
    }

    public void setAdtomensal(Boolean adtomensal) {
        this.adtomensal = adtomensal;
    }

    public Boolean getTemposervico() {
        return this.temposervico;
    }

    public void setTemposervico(Boolean temposervico) {
        this.temposervico = temposervico;
    }

    public Boolean getAposentado() {
        return this.aposentado;
    }

    public void setAposentado(Boolean aposentado) {
        this.aposentado = aposentado;
    }

    public Boolean getFaltaAbonada() {
        return this.faltaAbonada;
    }

    public void setFaltaAbonada(Boolean faltaAbonada) {
        this.faltaAbonada = faltaAbonada;
    }

    public Boolean isDiaDemissaoTrabalhado() {
        return this.diaDemissaoTrabalhado;
    }

    public Boolean getDiaDemissaoTrabalhado() {
        return this.diaDemissaoTrabalhado;
    }

    public void setDiaDemissaoTrabalhado(Boolean diademissaotrabalhado) {
        this.diaDemissaoTrabalhado = diademissaotrabalhado;
    }

    public final Date getDataConcessaoPensao() {
        return this.dataConcessaoPensao;
    }

    public final void setDataConcessaoPensao(Date dataConcessaoPensao) {
        this.dataConcessaoPensao = dataConcessaoPensao;
    }

    public Boolean getPensionista() {
        return this.pensionista;
    }

    public void setPensionista(Boolean pensionista) {
        this.pensionista = pensionista;
    }

    public Boolean getReposicaoVaga() {
        return this.reposicaoVaga;
    }

    public void setReposicaoVaga(Boolean reposicaoVaga) {
        this.reposicaoVaga = reposicaoVaga;
    }

    public Boolean getTsregistrosRescindidos() {
        return this.tsregistrosRescindidos;
    }

    public void setTsregistrosRescindidos(Boolean tsregistrosRescindidos) {
        this.tsregistrosRescindidos = tsregistrosRescindidos;
    }

    public Boolean getRatear() {
        return this.ratear;
    }

    public void setRatear(Boolean ratear) {
        this.ratear = ratear;
    }

    public Boolean getFuncionarioRpps() {
        return this.funcionarioRpps;
    }

    public void setFuncionarioRpps(Boolean funcionarioRpps) {
        this.funcionarioRpps = funcionarioRpps;
    }

    public Boolean getBancoHorasTrabalhador() {
        return this.bancoHorasTrabalhador;
    }

    public void setBancoHorasTrabalhador(Boolean bancoHorasTrab) {
        this.bancoHorasTrabalhador = bancoHorasTrab;
    }

    public Boolean getPensionistaParidade() {
        return this.pensionistaParidade;
    }

    public void setPensionistaParidade(Boolean pensionistaParidade) {
        this.pensionistaParidade = pensionistaParidade;
    }

    public Vinculo getVinculo() {
        return this.vinculo;
    }

    public void setVinculo(Vinculo vinculo) {
        this.vinculoCodigo = vinculo != null ? vinculo.getVinculoPK().getCodigo() : null;
        this.vinculo = vinculo;
    }

    public VeiculoPublicacao getDocadmVeiculopublicacao() {
        return this.docadmVeiculopublicacao;
    }

    public void setDocadmVeiculopublicacao(VeiculoPublicacao docadmVeiculopublicacao) {
        this.docadmVeiculopublicacao = docadmVeiculopublicacao;
    }

    public Usuario getUsuarioIncluiu() {
        return this.usuarioIncluiu;
    }

    public void setUsuarioIncluiu(Usuario usuarioIncluiu) {
        this.usuarioIncluiu = usuarioIncluiu;
    }

    public Usuario getUsuarioAlterou() {
        return this.usuarioAlterou;
    }

    public void setUsuarioAlterou(Usuario usuarioAlterou) {
        this.usuarioAlterou = usuarioAlterou;
    }

    public Unidade getUnidade() {
        return this.unidade;
    }

    public void setUnidade(Unidade unidade) {
        this.unidadeCodigo = unidade != null ? unidade.getCodigo() : null;
        this.unidade = unidade;
    }

    public TrabalhadorArquivo getTrabalhadorArquivo() {
        return this.trabalhadorArquivo;
    }

    public void setTrabalhadorArquivo(TrabalhadorArquivo trabarquivo) {
        this.trabalhadorArquivo = trabarquivo;
    }

    public TomadorObra getTomadorobra() {
        return this.tomadorobra;
    }

    public void setTomadorobra(TomadorObra tomadorobra) {
        this.tomadorObraCodigo = tomadorobra != null ? tomadorobra.getTomadorObraPK().getCodigo() : null;
        this.tomadorobra = tomadorobra;
    }

    public TipoDocumentoLegal getCargoatualTipolegal() {
        return this.cargoatualTipolegal;
    }

    public void setCargoatualTipolegal(TipoDocumentoLegal cargoatualTipolegal) {
        this.cargoatualTipolegal = cargoatualTipolegal;
    }

    public TipoDocumentoLegal getDocadmTipodoc() {
        return this.docadmTipodoc;
    }

    public void setDocadmTipodoc(TipoDocumentoLegal docadmTipodoc) {
        this.docadmTipodoc = docadmTipodoc;
    }

    public TrabalhadorTipoSalario getTipoSalario() {
        return TrabalhadorTipoSalario.of(this.tipoSalario);
    }

    public void setTipoSalario(TrabalhadorTipoSalario tipoSalario) {
        this.tipoSalario = tipoSalario.getCodigo();
    }

    public EscolaTecnica getEscolaTecnica() {
        return this.escolaTecnica;
    }

    public void setEscolaTecnica(EscolaTecnica escolaTecnica) {
        this.escolaTecnicaCodigo = escolaTecnica != null ? escolaTecnica.getCodigo() : null;
        this.escolaTecnica = escolaTecnica;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public Divisao getDivisao() {
        return this.divisao;
    }

    public void setDivisao(Divisao divisao) {
        this.divisaoCodigo = divisao != null ? divisao.getDivisaoPK().getCodigo() : null;
        this.divisao = divisao;
    }

    public Concurso getConcurso() {
        return this.concurso;
    }

    public void setConcurso(Concurso concurso) {
        this.concursoCodigo = concurso != null ? concurso.getCodigo() : null;
        this.concurso = concurso;
    }

    public CategoriaSefip getCategoriaSefip() {
        return this.categoriaSefip;
    }

    public void setCategoriaSefip(CategoriaSefip catsefip) {
        this.categoriaSefipCodigo = this.categoriaSefip != null ? this.categoriaSefip.getCodigo() : null;
        this.categoriaSefip = catsefip;
    }

    public CategoriaFuncional getCategoriaFuncional() {
        return this.categoriaFuncional;
    }

    public void setCategoriaFuncional(CategoriaFuncional catfuncional) {
        this.categoriaFuncionalCodigo = this.categoriaFuncional != null ? catfuncional.getCategoriaFuncionalPK().getCodigo() : null;
        this.categoriaFuncional = catfuncional;
    }

    public Cargo getCargoInicial() {
        return this.cargoInicial;
    }

    public void setCargoInicial(Cargo cargoInicial) {
        this.cargoInicialCodigo = cargoInicial != null ? cargoInicial.getCargoPK().getCodigo() : null;
        this.cargoInicial = cargoInicial;
    }

    public Cargo getCargoAtual() {
        return this.cargoAtual;
    }

    public void setCargoAtual(Cargo cargoAtual) {
        this.cargoAtualCodigo = cargoAtual != null ? cargoAtual.getCargoPK().getCodigo() : null;
        this.cargoAtual = cargoAtual;
    }

    public PessoaPortaria getPessoaPortaria() {
        return this.pessoaPortaria;
    }

    public void setPessoaPortaria(PessoaPortaria idcadportaria) {
        this.pessoaPortaria = idcadportaria;
    }

    public Atividade getAtividade() {
        return this.atividade;
    }

    public void setAtividade(Atividade atividade) {
        this.atividadeCodigo = atividade != null ? atividade.getAtividadePK().getCodigo() : null;
        this.atividade = atividade;
    }

    public Integer getAtividadeCodigo() {
        return this.atividadeCodigo;
    }

    public void setAtividadeCodigo(Integer atividadeCodigo) {
        this.atividadeCodigo = atividadeCodigo;
    }

    public LocalTrabalho getLocalTrabalho() {
        return this.localTrabalho;
    }

    public void setLocalTrabalho(LocalTrabalho localTrabalho) {
        this.localTrabalhoCodigo = localTrabalho != null ? localTrabalho.getLocalTrabalhoPK().getCodigo() : null;
        this.localTrabalho = localTrabalho;
    }

    public Orgaosiprev getOrgaosiprev() {
        return this.orgaosiprev;
    }

    public void setOrgaosiprev(Orgaosiprev orgaosiprev) {
        this.orgaosiprev = orgaosiprev;
    }

    public Sindicato getSindicato() {
        return this.sindicato;
    }

    public void setSindicato(Sindicato sindicato) {
        this.sindicatoCodigo = sindicato != null ? sindicato.getCodigo() : null;
        this.sindicato = sindicato;
    }

    public SiprevSituacaoFuncional getSiprevSituacaoFuncional() {
        return this.siprevSituacaoFuncional;
    }

    public void setSiprevSituacaoFuncional(SiprevSituacaoFuncional siprevFuncional) {
        this.siprevSituacaoFuncionalCodigo = this.siprevSituacaoFuncional != null ? this.siprevSituacaoFuncional.getCodigo() : null;
        this.siprevSituacaoFuncional = siprevFuncional;
    }

    public SiprevSituacaoPrevidenciaria getSiprevSituacaoPrevidenciaria() {
        return this.siprevSituacaoPrevidenciaria;
    }

    public void setSiprevSituacaoPrevidenciaria(SiprevSituacaoPrevidenciaria siprevSituacao) {
        this.siprevSituacaoPrevidenciariaCodigo = this.siprevSituacaoPrevidenciaria != null ? this.siprevSituacaoPrevidenciaria.getCodigo() : null;
        this.siprevSituacaoPrevidenciaria = siprevSituacao;
    }

    public SiprevVinculoOrgao getSiprevVincorgao() {
        return this.siprevVinculoOrgao;
    }

    public void setSiprevVincorgao(SiprevVinculoOrgao siprevVinculoOrgao) {
        this.siprevVinculoOrgaoCodigo = siprevVinculoOrgao != null ? siprevVinculoOrgao.getCodigo() : null;
        this.siprevVinculoOrgao = siprevVinculoOrgao;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public Subdivisao getSubdivisao() {
        return this.subdivisao;
    }

    public void setSubdivisao(Subdivisao subdivisao) {
        this.subdivisaoCodigo = subdivisao != null ? subdivisao.getSubdivisaoPK().getCodigo() : null;
        this.subdivisao = subdivisao;
    }

    public String getContratoString() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        if (this.dataAdmissao != null) {
            return this.contrato.toString() + "\u00ba Contrato " + sdf.format(this.dataAdmissao);
        }
        return this.contrato.toString() + "\u00ba Contrato ";
    }

    public TrabalhadorDocumentosPessoais getDocumentosPessoais() {
        if (this.documentosPessoais == null) {
            this.documentosPessoais = new TrabalhadorDocumentosPessoais();
        }
        return this.documentosPessoais;
    }

    public void setDocumentosPessoais(TrabalhadorDocumentosPessoais documentosPessoais) {
        this.documentosPessoais = documentosPessoais;
    }

    public Boolean getEfetivadoEstagioProbatorio() {
        return this.efetivadoEstagioProbatorio;
    }

    public void setEfetivadoEstagioProbatorio(Boolean efetivadoEstagioProbatorio) {
        this.efetivadoEstagioProbatorio = efetivadoEstagioProbatorio;
    }

    public Boolean getValeAlimentacao() {
        return this.valeAlimentacao;
    }

    public void setValeAlimentacao(Boolean valeAlimentacao) {
        this.valeAlimentacao = valeAlimentacao;
    }

    public DocumentoDigital getDocDigitalAposentadoria() {
        return this.docDigitalAposentadoria;
    }

    public void setDocDigitalAposentadoria(DocumentoDigital docDigitalAposentadoria) {
        this.docDigitalAposentadoria = docDigitalAposentadoria;
    }

    public DocumentoDigital getDocDigitalPensao() {
        return this.docDigitalPensao;
    }

    public void setDocDigitalPensao(DocumentoDigital docDigitalPensao) {
        this.docDigitalPensao = docDigitalPensao;
    }

    public AmbienteTrabalho getAmbienteTrabalho() {
        return this.ambienteTrabalho;
    }

    public void setAmbienteTrabalho(AmbienteTrabalho ambienteTrabalho) {
        this.ambienteTrabalho = ambienteTrabalho;
    }

    public AposentadoriaTCESP getAposentadoriaTCESP() {
        return this.aposentadoriaTCESP;
    }

    public void setAposentadoriaTCESP(AposentadoriaTCESP aposentadoriaTCESP) {
        this.aposentadoriaTCESP = aposentadoriaTCESP;
    }

    public Date getDataChegada() {
        return this.dataChegada;
    }

    public void setDataChegada(Date dataChegada) {
        this.dataChegada = dataChegada;
    }

    public List<TrabalhadorDocumentoApresentado> getDocumentoApresentados() {
        return this.documentoApresentados;
    }

    public void setDocumentoApresentados(List<TrabalhadorDocumentoApresentado> documentoApresentados) {
        this.documentoApresentados = documentoApresentados;
    }

    public TrabalhadorTemporarioDocumento getTemporarioDocumento() {
        return this.temporarioDocumento;
    }

    public void setTemporarioDocumento(TrabalhadorTemporarioDocumento temporarioDocumento) {
        this.temporarioDocumento = temporarioDocumento;
    }

    public Integer getPrazoMaximoContratacaoTemporario() {
        return this.prazoMaximoContratacaoTemporario;
    }

    public void setPrazoMaximoContratacaoTemporario(Integer prazoMaximoContratacaoTemporario) {
        this.prazoMaximoContratacaoTemporario = prazoMaximoContratacaoTemporario;
    }

    public String getCodigoEsocial() {
        return this.codigoEsocial;
    }

    public void setCodigoEsocial(String codigoEsocial) {
        this.codigoEsocial = codigoEsocial;
    }

    public List<LocalTrabalho> getLocaisTrabalhoResponsavel() {
        return this.locaisTrabalhoResponsavel;
    }

    public void setLocaisTrabalhoResponsavel(List<LocalTrabalho> locaisTrabalhoResponsavel) {
        this.locaisTrabalhoResponsavel = locaisTrabalhoResponsavel;
    }

    public String getTipoPensaoEsocial() {
        return this.tipoPensaoEsocial;
    }

    public void setTipoPensaoEsocial(String tipoPensaoEsocial) {
        this.tipoPensaoEsocial = tipoPensaoEsocial;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.trabalhadorPK != null ? this.trabalhadorPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Trabalhador)) {
            return false;
        }
        Trabalhador other = (Trabalhador)object;
        return (this.trabalhadorPK != null || other.trabalhadorPK == null) && (this.trabalhadorPK == null || this.trabalhadorPK.equals(other.trabalhadorPK));
    }

    public String toString() {
        return this.getTrabalhadorPK().getEntidade() + " " + this.getTrabalhadorPK().getRegistro() + " " + this.getMatriculaContrato() + " " + this.getNome();
    }

    public Salario getSalarioInicial() {
        return this.salarioInicial;
    }

    public void setSalarioInicial(Salario salarioInicial) {
        this.salarioInicialCodigo = salarioInicial != null ? salarioInicial.getSalarioPK().getCodigo() : null;
        this.salarioInicial = salarioInicial;
    }

    public Salario getSalarioAtual() {
        return this.salarioAtual;
    }

    public void setSalarioAtual(Salario salarioAtual) {
        this.salarioAtualCodigo = salarioAtual != null ? salarioAtual.getSalarioPK().getCodigo() : null;
        this.salarioAtual = salarioAtual;
    }

    public String getMatriculaContrato() {
        return this.getMatricula().toString() + "-" + this.getContrato();
    }

    public Date getUltimoAcessoAoSipweb() {
        return this.ultimoAcessoAoSipweb;
    }

    public void setUltimoAcessoAoSipweb(Date ultimoAcessoAoSipweb) {
        this.ultimoAcessoAoSipweb = ultimoAcessoAoSipweb;
    }

    public TrabalhadorPonto getPonto() {
        if (this.ponto == null) {
            this.ponto = new TrabalhadorPonto();
        }
        return this.ponto;
    }

    public void setPonto(TrabalhadorPonto ponto) {
        this.ponto = ponto;
    }

    public Jornada getJornada() {
        return this.jornada;
    }

    public void setJornada(Jornada jornada) {
        this.jornadaCodigo = jornada == null ? null : jornada.jornadaPK.getCodigo();
        this.jornada = jornada;
    }

    public List<Bases> getBases() {
        return this.bases;
    }

    public void setBases(List<Bases> bases) {
        this.bases = bases;
    }

    public List<RppsHistoricoPrecidenciario> getRpssHistoricosFinanceiros() {
        return this.rpssHistoricosFinanceiros;
    }

    public void setRpssHistoricosFinanceiros(List<RppsHistoricoPrecidenciario> rpssHistoricosFinanceiros) {
        this.rpssHistoricosFinanceiros = rpssHistoricosFinanceiros;
    }

    public String getItemLabel() {
        return this.nome;
    }

    public String getItemId() {
        return this.trabalhadorPK.getRegistro();
    }

    public List<Pcmso> getPcmsoList() {
        return this.pcmsoList;
    }

    public void setPcmsoList(List<Pcmso> pcmsoList) {
        this.pcmsoList = pcmsoList;
    }

    public String getCargoAtualCodigo() {
        return this.cargoAtualCodigo;
    }

    public void setCargoAtualCodigo(String cargoAtualCodigo) {
        this.cargoAtualCodigo = cargoAtualCodigo;
    }

    public String getDivisaoCodigo() {
        return this.divisaoCodigo;
    }

    public void setDivisaoCodigo(String divisaoCodigo) {
        this.divisaoCodigo = divisaoCodigo;
    }

    public Integer getUnidadeCodigo() {
        return this.unidadeCodigo;
    }

    public void setUnidadeCodigo(Integer unidadeCodigo) {
        this.unidadeCodigo = unidadeCodigo;
    }

    public String getLocalTrabalhoCodigo() {
        return this.localTrabalhoCodigo;
    }

    public void setLocalTrabalhoCodigo(String localTrabalhoCodigo) {
        this.localTrabalhoCodigo = localTrabalhoCodigo;
    }

    public String getSalarioAtualCodigo() {
        return this.salarioAtualCodigo;
    }

    public void setSalarioAtualCodigo(String salarioAtualCodigo) {
        this.salarioAtualCodigo = salarioAtualCodigo;
    }

    public String getSubdivisaoCodigo() {
        return this.subdivisaoCodigo;
    }

    public void setSubdivisaoCodigo(String subdivisaoCodigo) {
        this.subdivisaoCodigo = subdivisaoCodigo;
    }

    public String getVinculoCodigo() {
        return this.vinculoCodigo;
    }

    public void setVinculoCodigo(String vinculoCodigo) {
        this.vinculoCodigo = vinculoCodigo;
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.hashCode());
    }

    public List<TrabalhadorConta> getContaList() {
        return this.contaList;
    }

    public void setContaList(List<TrabalhadorConta> contaList) {
        this.contaList = contaList;
    }

    public List<RegistroControleEpi> getControleEpiList() {
        return this.controleEpiList;
    }

    public void setControleEpiList(List<RegistroControleEpi> controleEpiList) {
        this.controleEpiList = controleEpiList;
    }

    public List<MovimentoSefip> getMovimentoSefipList() {
        return this.movimentoSefipList;
    }

    public void setMovimentoSefipList(List<MovimentoSefip> movimentoSefipList) {
        this.movimentoSefipList = movimentoSefipList;
    }

    public List<Movimento> getMovimentoList() {
        return this.movimentoList;
    }

    public void setMovimentoList(List<Movimento> movimentoList) {
        this.movimentoList = movimentoList;
    }

    public List<Falta> getFaltaList() {
        return this.faltaList;
    }

    public void setFaltaList(List<Falta> faltaList) {
        this.faltaList = faltaList;
    }

    public List<Ferias> getFeriasList() {
        return this.feriasList;
    }

    public void setFeriasList(List<Ferias> feriasList) {
        this.feriasList = feriasList;
    }

    public List<LicencaPremio> getLicencaPremioList() {
        return this.licencaPremioList;
    }

    public void setLicencaPremioList(List<LicencaPremio> licencaPremioList) {
        this.licencaPremioList = licencaPremioList;
    }

    public TrabalhadorEstadoSaoPaulo getDadosEstadoSaoPaulo() {
        return this.dadosEstadoSaoPaulo;
    }

    public void setDadosEstadoSaoPaulo(TrabalhadorEstadoSaoPaulo dadosEstadoSaoPaulo) {
        this.dadosEstadoSaoPaulo = dadosEstadoSaoPaulo;
    }

    public Integer getCategoriaFuncionalCodigo() {
        return this.categoriaFuncionalCodigo;
    }

    public void setCategoriaFuncionalCodigo(Integer categoriaFuncionalCodigo) {
        this.categoriaFuncionalCodigo = categoriaFuncionalCodigo;
    }

    public Short getJornadaCodigo() {
        return this.jornadaCodigo;
    }

    public void setJornadaCodigo(Short jornadaCodigo) {
        this.jornadaCodigo = jornadaCodigo;
    }

    public Integer getIntegracaoTceMgId() {
        return this.integracaoTceMgId;
    }

    public void setIntegracaoTceMgId(Integer integracaoTceMgId) {
        this.integracaoTceMgId = integracaoTceMgId;
    }

    public Aposentado getAposentadoInativo() {
        if (this.aposentadoInativo == null) {
            this.aposentadoInativo = new Aposentado();
        }
        return this.aposentadoInativo;
    }

    public void setAposentadoInativo(Aposentado aposentadoInativo) {
        this.aposentadoInativo = aposentadoInativo;
    }

    public TrabalhadorFoto getFoto() {
        if (this.foto == null) {
            this.foto = new TrabalhadorFoto();
        }
        return this.foto;
    }

    public void setFoto(TrabalhadorFoto foto) {
        this.foto = foto;
    }

    public LdapConfig getLdapConfig() {
        return this.ldapConfig;
    }

    public void setLdapConfig(LdapConfig ldapConfig) {
        this.ldapConfigId = ldapConfig != null ? ldapConfig.getId() : null;
        this.ldapConfig = ldapConfig;
    }

    public String getUsuarioLdap() {
        return this.usuarioLdap;
    }

    public void setUsuarioLdap(String usuarioLdap) {
        this.usuarioLdap = usuarioLdap;
    }

    public Integer getLdapConfigId() {
        return this.ldapConfigId;
    }

    public void setLdapConfigId(Integer ldapConfigId) {
        this.ldapConfigId = ldapConfigId;
    }

    public List<Dependente> getDependentes() {
        return this.dependentes;
    }

    public void setDependentes(List<Dependente> dependentes) {
        this.dependentes = dependentes;
    }

    public String getCargoInicialCodigo() {
        return this.cargoInicialCodigo;
    }

    public void setCargoInicialCodigo(String cargoInicialCodigo) {
        this.cargoInicialCodigo = cargoInicialCodigo;
    }

    public TipoRegimeJornada getTipoRegimeJornada() {
        return TipoRegimeJornada.of(this.tipoRegimeJornada);
    }

    public void setTipoRegimeJornada(TipoRegimeJornada tipoRegimeJornada) {
        this.tipoRegimeJornada = tipoRegimeJornada == null ? null : Integer.valueOf(tipoRegimeJornada.getCodigo());
    }

    public List<HistoricoTrabalhadorNome> getHistoricoNome() {
        return this.historicoNome;
    }

    public void setHistoricoNome(List<HistoricoTrabalhadorNome> historicoNome) {
        this.historicoNome = historicoNome;
    }

    public Integer getMesesCarencia13() {
        return this.mesesCarencia13;
    }

    public void setMesesCarencia13(Integer mesesCarencia13) {
        this.mesesCarencia13 = mesesCarencia13;
    }

    public Boolean getCalcular14salario() {
        return this.calcular14salario;
    }

    public void setCalcular14salario(Boolean calcular14salario) {
        this.calcular14salario = calcular14salario;
    }

    public SituacaoFuncional getSituacaoFuncional() {
        return this.situacaoFuncional;
    }

    public void setSituacaoFuncional(SituacaoFuncional situacaoFuncional) {
        this.situacaoFuncional = situacaoFuncional;
    }

    public String getSalarioInicialCodigo() {
        return this.salarioInicialCodigo;
    }

    public void setSalarioInicialCodigo(String salarioInicialCodigo) {
        this.salarioInicialCodigo = salarioInicialCodigo;
    }

    public TrabalhadorLegislacaoAdmissaoDocumento getLegislacaoAdmissaoDocumento() {
        if (this.legislacaoAdmissaoDocumento == null) {
            this.legislacaoAdmissaoDocumento = new TrabalhadorLegislacaoAdmissaoDocumento();
        }
        return this.legislacaoAdmissaoDocumento;
    }

    public void setLegislacaoAdmissaoDocumento(TrabalhadorLegislacaoAdmissaoDocumento legislacaoAdmissaoDocumento) {
        this.legislacaoAdmissaoDocumento = legislacaoAdmissaoDocumento;
    }

    public Integer getConcursoCodigo() {
        return this.concursoCodigo;
    }

    public void setConcursoCodigo(Integer concursoCodigo) {
        this.concursoCodigo = concursoCodigo;
    }

    public String getCategoriaSefipCodigo() {
        return this.categoriaSefipCodigo;
    }

    public void setCategoriaSefipCodigo(String categoriaSefipCodigo) {
        this.categoriaSefipCodigo = categoriaSefipCodigo;
    }

    public Integer getTomadorObraCodigo() {
        return this.tomadorObraCodigo;
    }

    public void setTomadorObraCodigo(Integer tomadorObraCodigo) {
        this.tomadorObraCodigo = tomadorObraCodigo;
    }

    public String getSiprevSituacaoPrevidenciariaCodigo() {
        return this.siprevSituacaoPrevidenciariaCodigo;
    }

    public void setSiprevSituacaoPrevidenciariaCodigo(String siprevSituacaoPrevidenciariaCodigo) {
        this.siprevSituacaoPrevidenciariaCodigo = siprevSituacaoPrevidenciariaCodigo;
    }

    public String getSiprevSituacaoFuncionalCodigo() {
        return this.siprevSituacaoFuncionalCodigo;
    }

    public void setSiprevSituacaoFuncionalCodigo(String siprevSituacaoFuncionalCodigo) {
        this.siprevSituacaoFuncionalCodigo = siprevSituacaoFuncionalCodigo;
    }

    public String getSiprevVinculoOrgaoCodigo() {
        return this.siprevVinculoOrgaoCodigo;
    }

    public void setSiprevVinculoOrgaoCodigo(String siprevVinculoOrgaoCodigo) {
        this.siprevVinculoOrgaoCodigo = siprevVinculoOrgaoCodigo;
    }

    public Integer getSindicatoCodigo() {
        return this.sindicatoCodigo;
    }

    public void setSindicatoCodigo(Integer sindicatoCodigo) {
        this.sindicatoCodigo = sindicatoCodigo;
    }

    public Integer getEscolaTecnicaCodigo() {
        return this.escolaTecnicaCodigo;
    }

    public void setEscolaTecnicaCodigo(Integer escolaTecnicaCodigo) {
        this.escolaTecnicaCodigo = escolaTecnicaCodigo;
    }

    public CargoNivel getCargoNivel() {
        return this.cargoNivel;
    }

    public void setCargoNivel(CargoNivel cargoNivel) {
        this.cargoNivel = cargoNivel;
    }

    public Integer getCargoNivelCodigo() {
        return this.cargoNivelCodigo;
    }

    public void setCargoNivelCodigo(Integer cargoNivelCodigo) {
        this.cargoNivelCodigo = cargoNivelCodigo;
    }

    public List<DocumentoAdmissao> getDocumentosAdmissao() {
        return this.documentosAdmissao;
    }

    public void setDocumentosAdmissao(List<DocumentoAdmissao> documentosAdmissao) {
        this.documentosAdmissao = documentosAdmissao;
    }

    public String getAditivo() {
        return this.aditivo;
    }

    public void setAditivo(String aditivo) {
        this.aditivo = aditivo;
    }

    public List<TrabalhadorDocumentosJustificativaAdmissaoPDF> getJustificativaAdmissao() {
        return this.justificativaAdmissao;
    }

    public void setJustificativaAdmissao(List<TrabalhadorDocumentosJustificativaAdmissaoPDF> justificativaAdmissao) {
        this.justificativaAdmissao = justificativaAdmissao;
    }

    public TrabObs getObservacoes() {
        if (this.observacoes == null) {
            this.observacoes = new TrabObs();
        }
        return this.observacoes;
    }

    public void setObservacoes(TrabObs observacoes) {
        this.observacoes = observacoes;
    }

    public List<TrabalhadorValeTransporte> getValeTransporte() {
        return this.valeTransporte;
    }

    public void setValeTransporte(List<TrabalhadorValeTransporte> valeTransporte) {
        this.valeTransporte = valeTransporte;
    }

    public List<HistoricoTrabalhadorDivisao> getHistoricoDivisao() {
        return this.historicoDivisao;
    }

    public void setHistoricoDivisao(List<HistoricoTrabalhadorDivisao> historicoDivisao) {
        this.historicoDivisao = historicoDivisao;
    }

    public List<HistoricoTrabalhadorSubdivisao> getHistoricoSubdivisao() {
        return this.historicoSubdivisao;
    }

    public void setHistoricoSubdivisao(List<HistoricoTrabalhadorSubdivisao> historicoSubdivisao) {
        this.historicoSubdivisao = historicoSubdivisao;
    }

    public List<HistoricoTrabalhadorLocalTrabalho> getHistoricoLocalTrabalho() {
        return this.historicoLocalTrabalho;
    }

    public void setHistoricoLocalTrabalho(List<HistoricoTrabalhadorLocalTrabalho> historicoLocalTrabalho) {
        this.historicoLocalTrabalho = historicoLocalTrabalho;
    }

    public List<HistoricoTrabalhadorUnidade> getHistoricoUnidade() {
        return this.historicoUnidade;
    }

    public void setHistoricoUnidade(List<HistoricoTrabalhadorUnidade> historicoUnidade) {
        this.historicoUnidade = historicoUnidade;
    }

    public List<HistoricoTrabalhadorCargo> getHistoricoCargoList() {
        return this.historicoCargoList;
    }

    public void setHistoricoCargoList(List<HistoricoTrabalhadorCargo> historicoCargoList) {
        this.historicoCargoList = historicoCargoList;
    }

    public List<HistoricoTrabalhadorSalario> getHistoricoSalarioList() {
        return this.historicoSalarioList;
    }

    public void setHistoricoSalarioList(List<HistoricoTrabalhadorSalario> historicoSalarioList) {
        this.historicoSalarioList = historicoSalarioList;
    }

    public List<HistoricoTrabalhadorSalarioInicial> getHistoricoSalarioInicialList() {
        return this.historicoSalarioInicialList;
    }

    public void setHistoricoSalarioInicialList(List<HistoricoTrabalhadorSalarioInicial> historicoSalarioInicialList) {
        this.historicoSalarioInicialList = historicoSalarioInicialList;
    }

    public List<HistoricoTrabalhadorAtividade> getHistoricoAtividade() {
        return this.historicoAtividade;
    }

    public void setHistoricoAtividade(List<HistoricoTrabalhadorAtividade> historicoAtividade) {
        this.historicoAtividade = historicoAtividade;
    }

    public List<BeneficiarioPensaoAlimenticia> getBeneficiariosPensaoList() {
        return this.beneficiariosPensaoList;
    }

    public void setBeneficiariosPensaoList(List<BeneficiarioPensaoAlimenticia> beneficiariosPensaoList) {
        this.beneficiariosPensaoList = beneficiariosPensaoList;
    }

    public List<Pensionista> getPensionistas() {
        return this.pensionistas;
    }

    public void setPensionistas(List<Pensionista> pensionistas) {
        this.pensionistas = pensionistas;
    }

    public SiopeTrabalhador getSiopeTrabalhador() {
        if (this.siopeTrabalhador == null) {
            this.siopeTrabalhador = new SiopeTrabalhador();
        }
        return this.siopeTrabalhador;
    }

    public void setSiopeTrabalhador(SiopeTrabalhador siopeTrabalhador) {
        this.siopeTrabalhador = siopeTrabalhador;
    }

    public List<Eventuais> getEventuaisList() {
        return this.eventuaisList;
    }

    public void setEventuaisList(List<Eventuais> eventuaisList) {
        this.eventuaisList = eventuaisList;
    }

    public List<EventoFixo> getEventoFixoList() {
        return this.eventoFixoList;
    }

    public void setEventoFixoList(List<EventoFixo> eventoFixoList) {
        this.eventoFixoList = eventoFixoList;
    }

    public List<EventoFolhaComplementar> getEventoFolhaComplementar() {
        return this.eventoFolhaComplementar;
    }

    public void setEventoFolhaComplementar(List<EventoFolhaComplementar> eventoFolhaComplementar) {
        this.eventoFolhaComplementar = eventoFolhaComplementar;
    }

    public SipmtTrabalhador getTceMt() {
        return this.tceMt;
    }

    public void setTceMt(SipmtTrabalhador tceMt) {
        this.tceMt = tceMt;
    }

    public TrabalhadorTceMs getTrabalhadorTceMs() {
        return this.trabalhadorTceMs;
    }

    public void setTrabalhadorTceMs(TrabalhadorTceMs trabalhadorTceMs) {
        this.trabalhadorTceMs = trabalhadorTceMs;
    }

    public SiprnTrabalhador getTceRn() {
        return this.tceRn;
    }

    public void setTceRn(SiprnTrabalhador tceRn) {
        this.tceRn = tceRn;
    }

    public SiprjTrabalhador getTceRj() {
        return this.tceRj;
    }

    public void setTceRj(SiprjTrabalhador tceRj) {
        this.tceRj = tceRj;
    }

    public SipprAtividadeTrabalhador getTcePr() {
        return this.tcePr;
    }

    public void setTcePr(SipprAtividadeTrabalhador tcePr) {
        this.tcePr = tcePr;
    }

    public SipbaTrabalhador getTceBa() {
        return this.tceBa;
    }

    public void setTceBa(SipbaTrabalhador tceBa) {
        this.tceBa = tceBa;
    }

    public EntidadeCedente getCedente() {
        return this.cedente;
    }

    public void setCedente(EntidadeCedente cedente) {
        this.cedente = cedente;
    }

    public Date getDataInicioVinculoAnterior() {
        return this.dataInicioVinculoAnterior;
    }

    public void setDataInicioVinculoAnterior(Date dataInicioVinculoAnterior) {
        this.dataInicioVinculoAnterior = dataInicioVinculoAnterior;
    }

    public SipMgTrabalhador getSipMgTrabalhador() {
        return this.sipMgTrabalhador;
    }

    public void setSipMgTrabalhador(SipMgTrabalhador sipMgTrabalhador) {
        this.sipMgTrabalhador = sipMgTrabalhador;
    }

    public SubdivisaoItem getSubdivisaoItem() {
        return this.subdivisaoItem;
    }

    public void setSubDibisaoItem(SubdivisaoItem subdivisaoItem) {
        this.subdivisaoItem = subdivisaoItem;
    }

    public Map<String, String> getCamposUsuario() {
        return this.camposUsuario;
    }

    public void setCamposUsuario(Map<String, String> camposUsuario) {
        this.camposUsuario = camposUsuario;
    }

    public Integer getIdFacial() {
        return this.idFacial;
    }

    public void setIdFacial(Integer idFacial) {
        this.idFacial = idFacial;
    }

    public TrabalhadorSituacao getTrabalhadorSituacao() {
        return TrabalhadorSituacao.get(this.situacao);
    }

    public LotacaoTCESP getLotacaoTCESP() {
        return this.lotacaoTCESP;
    }

    public void setLotacaoTCESP(LotacaoTCESP lotacaoTCESP) {
        this.lotacaoTCESP = lotacaoTCESP;
    }

    public ConcursoCargo getCargoConcurso() {
        return this.cargoConcurso;
    }

    public void setCargoConcurso(ConcursoCargo cargoConcurso) {
        this.cargoConcurso = cargoConcurso;
    }

    public List<SipwebSolicitacaoAfastamento> getSolicitacoesAfastamentos() {
        return this.solicitacoesAfastamentos;
    }

    public void setSolicitacoesAfastamentos(List<SipwebSolicitacaoAfastamento> solicitacoesAfastamentos) {
        this.solicitacoesAfastamentos = solicitacoesAfastamentos;
    }

    public String getNomeSocial() {
        return this.nomeSocial;
    }

    public void setNomeSocial(String nomeSocial) {
        this.nomeSocial = nomeSocial;
    }

    public Short getGrupoPontoCodigo() {
        return this.grupoPontoCodigo;
    }

    public void setGrupoPontoCodigo(Short grupoPontoCodigo) {
        this.grupoPontoCodigo = grupoPontoCodigo;
    }

    public GrupoPonto getGrupoPonto() {
        return this.grupoPonto;
    }

    public void setGrupoPonto(GrupoPonto grupoPonto) {
        this.grupoPonto = grupoPonto;
    }

    public Integer getIdBiometria() {
        return this.idBiometria;
    }

    public void setIdBiometria(Integer idBiometria) {
        this.idBiometria = idBiometria;
    }

    public PessoaBiometria getBiometria() {
        return this.biometria;
    }

    public void setBiometria(PessoaBiometria biometria) {
        this.biometria = biometria;
    }

    public List<BancoHorasLancamento> getBancoHorasLancamentos() {
        return this.bancoHorasLancamentos;
    }

    public void setBancoHorasLancamentos(List<BancoHorasLancamento> bancoHorasLancamentos) {
        this.bancoHorasLancamentos = bancoHorasLancamentos;
    }

    public static class TrabalhadorSql {
        public static final String DOES_EXIST_BY_MATRICULA_CONTRATO = " SELECT COUNT(t.trabalhadorPK.entidade)  FROM Trabalhador t  WHERE t.trabalhadorPK.entidade = :entidade  AND t.matricula = :matricula   AND t.contrato = :contrato ";
        public static final String DOES_EXIST_BY_PK = " SELECT COUNT(t.trabalhadorPK.entidade)  FROM Trabalhador t  WHERE t.trabalhadorPK = :pk ";
        public static final String UPDATE_SENHAWEB_BY_PK = " UPDATE " + Trabalhador.class.getName() + " t SET " + " t.dadosPessoais.senhaweb = :novaSenha " + " WHERE t.trabalhadorPK.entidade = :entidade " + " AND t.trabalhadorPK.registro = :registro ";
        public static final String FIND_ATIVOS_BY_ENTIDADE = " SELECT t  FROM Trabalhador t  WHERE t.trabalhadorPK.entidade = :entidade  AND (t.situacao = '1' or (t.dataDemissao is null or t.dataDemissao >= :data)) ";
        public static final String PARAM_EQUALS_CARGO_ATUAL = " AND t.cargoAtualCodigo = :codCargo ";
        public static final String PARAM_EQUALS_JORNADA = " AND t.jornadaCodigo = :codJornada ";
        public static final String PARAM_EQUALS_DIVISAO = " AND t.divisaoCodigo = :codDivisao ";
        public static final String PARAM_EQUALS_SUBDIVISAO = " AND t.subdivisaoCodigo = :subDivisao ";
        public static final String PARAM_EQUALS_UNIDADE = " AND t.unidadeCodigo = :codUnidade ";
        public static final String PARAM_EQUALS_LOCALTRABALHO = " AND t.localTrabalhoCodigo = :codLocalTrabalho ";
        public static final String PARAM_DIFFERENT_REGISTRO = " AND t.trabalhadorPK.registro <> :registro ";
        public static final String FIND_REGISTROS_WITH_SAME_PIS_BY_PK = "SELECT DISTINCT         t1.trabalhadorPK.registro FROM         Trabalhador t1 WHERE         t1.trabalhadorPK.entidade  = :entidade AND     t1.situacao                = '1' AND     t1.trabalhadorPK.registro <> :registro AND     EXISTS         (                 SELECT                         1                 FROM                         Trabalhador t2                 WHERE                         t2.trabalhadorPK.entidade = :entidade                 AND     t2.documentosPessoais.pis = t1.documentosPessoais.pis                 AND     t2.trabalhadorPK.registro = :registro                 AND     t2.situacao               = '1' )";
        public static final String FIND_MATRICULAS_AND_CONTRATOS_WITH_SAME_PIS_BY_PK = "SELECT DISTINCT         t1.matricula || '-' || t1.contrato FROM         Trabalhador t1 WHERE         t1.trabalhadorPK.entidade  = :entidade AND     t1.situacao                = '1' AND     t1.trabalhadorPK.registro <> :registro AND     EXISTS         (                 SELECT                         1                 FROM                         Trabalhador t2                 WHERE                         t2.trabalhadorPK.entidade = :entidade                 AND     t2.documentosPessoais.pis = t1.documentosPessoais.pis                 AND     t2.trabalhadorPK.registro = :registro                 AND     t2.situacao               = '1' )";
        public static final String FIND_REGISTRO_BY_ENTIDADE_MATRICULA_CONTRATO = " SELECT          t.trabalhadorPK.registro  FROM          Trabalhador t  WHERE          t.trabalhadorPK.entidade = :entidade  AND     t.matricula              = :matricula  AND     t.contrato               = :contrato";
        public static final String UPDATE_IDFACIAL_BY_PK = "UPDATE " + Trabalhador.class.getName() + " t " + "SET t.idFacial = :idFacial " + "WHERE t.trabalhadorPK = :trabalhadorPK";
    }
}

