/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="TRAB_OBS")
@Audited
public class TrabObs
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected TrabalhadorPK trabObsPK;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="OBS")
    private String obs;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;

    public TrabObs() {
    }

    public TrabObs(TrabalhadorPK trabObsPK) {
        this.trabObsPK = trabObsPK;
    }

    public TrabObs(String entidade, String registro) {
        this.trabObsPK = new TrabalhadorPK(entidade, registro);
    }

    public TrabalhadorPK getTrabObsPK() {
        if (this.trabObsPK == null) {
            this.trabObsPK = new TrabalhadorPK();
        }
        return this.trabObsPK;
    }

    public void setTrabObsPK(TrabalhadorPK trabObsPK) {
        this.trabObsPK = trabObsPK;
    }

    public String getObs() {
        return this.obs;
    }

    public void setObs(String obs) {
        this.obs = obs;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.trabObsPK != null ? this.trabObsPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TrabObs)) {
            return false;
        }
        TrabObs other = (TrabObs)object;
        return (this.trabObsPK != null || other.trabObsPK == null) && (this.trabObsPK == null || this.trabObsPK.equals(other.trabObsPK));
    }

    public String toString() {
        return this.getObs();
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }
}

