/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.TomadorObra;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="MOVTOTOMADOROBRA")
@Audited
public class TomadorObraMovimento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_MOVTOTOMADOROBRA";
    public static final String GET_NEXT_CODIGO = "SELECT COALESCE(MAX(t.codigo), 0) + 1 FROM TomadorObraMovimento t";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @Column(name="SALARIOFAMILIA")
    private Double salarioFamilia;
    @Column(name="VALORRETENCAO")
    private Double valorRetencao;
    @Column(name="VALORFATURA")
    private Double valorFatura;
    @FilterConfig(label="Data de Servi\u00e7o", inputType=FilterInputType.CALENDAR, condition=FilterCondition.INTERVALO)
    @Basic(optional=false)
    @NotNull
    @Column(name="DTSERVICO")
    @Temporal(value=TemporalType.DATE)
    private Date dataServico;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=4)
    @Column(name="ANO")
    private String ano;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=2)
    @Column(name="MES")
    private String mes;
    @Size(min=1, max=3)
    @NotNull
    @Column(name="EMPRESA")
    private String entidadeCodigo;
    @Column(name="TOMADOROBRA")
    @NotNull
    private Integer tomadorObraCodigo;
    @FilterConfig(label="Tomador de Obra", inputType=FilterInputType.AUTO_COMPLETE)
    @FilterConfigSelect(query="SELECT to FROM TomadorObra to WHERE to.tomadorObraPK.entidade = :entidadeCodigo AND UPPER(to.nome) LIKE UPPER('%'||:param||'%') ORDER BY to.nome")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="TOMADOROBRA", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private TomadorObra tomadorObra;

    public TomadorObraMovimento() {
    }

    public TomadorObraMovimento(Integer codigo) {
        this.codigo = codigo;
    }

    public TomadorObraMovimento(Integer codigo, Date dtservico, String ano, String mes) {
        this.codigo = codigo;
        this.dataServico = dtservico;
        this.ano = ano;
        this.mes = mes;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public Double getSalarioFamilia() {
        return this.salarioFamilia;
    }

    public void setSalarioFamilia(Double salariofamilia) {
        this.salarioFamilia = salariofamilia;
    }

    public Double getValorRetencao() {
        return this.valorRetencao;
    }

    public void setValorRetencao(Double valorretencao) {
        this.valorRetencao = valorretencao;
    }

    public Double getValorFatura() {
        return this.valorFatura;
    }

    public void setValorFatura(Double valorfatura) {
        this.valorFatura = valorfatura;
    }

    public Date getDataServico() {
        return this.dataServico;
    }

    public void setDataServico(Date dtservico) {
        this.dataServico = dtservico;
    }

    public String getAno() {
        return this.ano;
    }

    public void setAno(String ano) {
        this.ano = ano;
    }

    public String getMes() {
        return this.mes;
    }

    public void setMes(String mes) {
        this.mes = mes;
    }

    public TomadorObra getTomadorObra() {
        return this.tomadorObra;
    }

    public void setTomadorObra(TomadorObra tomadorobra) {
        if (tomadorobra != null) {
            this.tomadorObraCodigo = tomadorobra.getTomadorObraPK().getCodigo();
            this.entidadeCodigo = tomadorobra.getTomadorObraPK().getEntidade();
        } else {
            this.tomadorObraCodigo = null;
            this.entidadeCodigo = null;
        }
        this.tomadorObra = tomadorobra;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TomadorObraMovimento)) {
            return false;
        }
        TomadorObraMovimento other = (TomadorObraMovimento)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Movtotomadorobra[ codigo=" + this.codigo + " ]";
    }

    public String getEntidadeCodigo() {
        return this.entidadeCodigo;
    }

    public void setEntidadeCodigo(String entidadeCodigo) {
        this.entidadeCodigo = entidadeCodigo;
    }

    public Integer getTomadorObraCodigo() {
        return this.tomadorObraCodigo;
    }

    public void setTomadorObraCodigo(Integer tomadorObraCodigo) {
        this.tomadorObraCodigo = tomadorObraCodigo;
    }
}

