/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;
import br.com.fiorilli.sip.persistence.entity.PagamentoGps;
import br.com.fiorilli.sip.persistence.entity.TomadorObraPK;
import br.com.fiorilli.sip.persistence.entity.TomadorObraResponsavel;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="TOMADOROBRA")
@Audited
public class TomadorObra
implements Serializable,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_FOR_FILTER = "SELECT to FROM TomadorObra to WHERE to.tomadorObraPK.entidade = :entidadeCodigo AND UPPER(to.nome) LIKE UPPER('%'||:param||'%') ORDER BY to.nome";
    @EmbeddedId
    protected TomadorObraPK tomadorObraPK;
    @Column(name="TIPOID")
    private String tipoIdentificador;
    @FilterConfig(label="Identificador")
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Embedded
    private Endereco endereco;
    @Size(max=4)
    @Column(name="CODGPS")
    private String pagamentoGps;
    @Embedded
    private TomadorObraResponsavel responsavel;

    public TomadorObra() {
    }

    public TomadorObra(TomadorObraPK tomadorObraPK) {
        this.tomadorObraPK = tomadorObraPK;
    }

    public TomadorObra(String entidade, int codigo) {
        this.tomadorObraPK = new TomadorObraPK(entidade, codigo);
    }

    public TomadorObraPK getTomadorObraPK() {
        return this.tomadorObraPK;
    }

    public void setTomadorObraPK(TomadorObraPK tomadorObraPK) {
        this.tomadorObraPK = tomadorObraPK;
    }

    public IdentificadorTipo getTipoIdentificador() {
        return IdentificadorTipo.get(this.tipoIdentificador);
    }

    public void setTipoIdentificador(IdentificadorTipo identificadorTipo) {
        this.tipoIdentificador = identificadorTipo.getCodigo();
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Endereco getEndereco() {
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public PagamentoGps getPagamentoGps() {
        return PagamentoGps.get(this.pagamentoGps);
    }

    public void setPagamentoGps(PagamentoGps pagamentoGps) {
        this.pagamentoGps = pagamentoGps.getCodigo();
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.tomadorObraPK != null ? this.tomadorObraPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TomadorObra)) {
            return false;
        }
        TomadorObra other = (TomadorObra)object;
        return (this.tomadorObraPK != null || other.tomadorObraPK == null) && (this.tomadorObraPK == null || this.tomadorObraPK.equals(other.tomadorObraPK));
    }

    public String toString() {
        return "entity.Tomadorobra[ tomadorObraPK=" + this.tomadorObraPK + " ]";
    }

    public String getItemId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemLabel() {
        return this.nome;
    }
}

