/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.Arrays;
import java.util.List;

public enum TipoServico {
    RGPS_PRIVADO(0, "RGPS Privado"),
    RGPS_PUBLICO(1, "RGPS P\u00fablico"),
    RPPS(2, "RPPS"),
    PRIVADO_VINCULO_ATIVO(3, "Privado V\u00ednculo Ativo"),
    PUBLICO_VINCULO_ATIVO(4, "P\u00fablico V\u00ednculo Ativo"),
    MILITAR(5, "Militar");

    private final Short codigo;
    private final String descricao;

    private TipoServico(Integer codigo, String descricao) {
        this.codigo = codigo.shortValue();
        this.descricao = descricao;
    }

    public Short getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static TipoServico getBy(Integer codigo) {
        for (TipoServico tipo : TipoServico.values()) {
            if (!tipo.getCodigo().equals(codigo.shortValue())) continue;
            return tipo;
        }
        return null;
    }

    public static List<TipoServico> getAll() {
        return Arrays.asList(TipoServico.values());
    }

    public static List<TipoServico> getTiposServicoPublico() {
        return Arrays.asList(RGPS_PUBLICO, RPPS, PUBLICO_VINCULO_ATIVO, MILITAR);
    }

    public static List<TipoServico> getTiposServicoPrivado() {
        return Arrays.asList(RGPS_PRIVADO, PRIVADO_VINCULO_ATIVO);
    }
}

