/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.api.SearchCodigo;
import br.com.fiorilli.sip.persistence.api.SearchNome;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorCargo;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorCargoInicial;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSalario;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorSalarioInicial;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegalTcePr;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="TIPOLEGAL")
@Audited
public class TipoDocumentoLegal
implements Serializable,
Filterable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_TIPOLEGAL";
    public static final String FIND_ALL = "SELECT t FROM TipoDocumentoLegal t";
    public static final String FIND_FOR_FILTER = "SELECT e FROM TipoDocumentoLegal T WHERE concat(t.codigo, t.nome) LIKE concat('%', :param, '%') ORDER BY e.nome";
    @SearchCodigo
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER, order=1)
    @Id
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;
    @SearchNome
    @FilterConfig(label="Nome", condition=FilterCondition.CONTENHA, order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Column(name="CODIGO_AUDESP")
    private Integer codigoAudesp;
    @OneToOne(fetch=FetchType.LAZY, mappedBy="tipoDocumentoLegal")
    private TipoDocumentoLegalTcePr tcePr;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tipoLegal")
    private List<HistoricoTrabalhadorCargo> historicoTrabCargo;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tipoLegal")
    private List<HistoricoTrabalhadorCargoInicial> historicoTrabCargoInicial;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tipoLegal")
    private List<HistoricoTrabalhadorSalario> historicoTrabSalario;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="tipoLegal")
    private List<HistoricoTrabalhadorSalarioInicial> historicoTrabSalarioInicial;

    public TipoDocumentoLegal() {
    }

    public TipoDocumentoLegal(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Integer getCodigoAudesp() {
        return this.codigoAudesp;
    }

    public void setCodigoAudesp(Integer codigoAudesp) {
        this.codigoAudesp = codigoAudesp;
    }

    public List<HistoricoTrabalhadorCargo> getHistoricoTrabCargo() {
        return this.historicoTrabCargo;
    }

    public void setHistoricoTrabCargo(List<HistoricoTrabalhadorCargo> historicoTrabCargo) {
        this.historicoTrabCargo = historicoTrabCargo;
    }

    public List<HistoricoTrabalhadorCargoInicial> getHistoricoTrabCargoInicial() {
        return this.historicoTrabCargoInicial;
    }

    public void setHistoricoTrabCargoInicial(List<HistoricoTrabalhadorCargoInicial> historicoTrabCargoInicial) {
        this.historicoTrabCargoInicial = historicoTrabCargoInicial;
    }

    public List<HistoricoTrabalhadorSalario> getHistoricoTrabSalario() {
        return this.historicoTrabSalario;
    }

    public void setHistoricoTrabSalario(List<HistoricoTrabalhadorSalario> historicoTrabSalario) {
        this.historicoTrabSalario = historicoTrabSalario;
    }

    public List<HistoricoTrabalhadorSalarioInicial> getHistoricoTrabSalarioInicial() {
        return this.historicoTrabSalarioInicial;
    }

    public void setHistoricoTrabSalarioInicial(List<HistoricoTrabalhadorSalarioInicial> historicoTrabSalarioInicial) {
        this.historicoTrabSalarioInicial = historicoTrabSalarioInicial;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.codigo != null ? this.codigo.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TipoDocumentoLegal)) {
            return false;
        }
        TipoDocumentoLegal other = (TipoDocumentoLegal)object;
        return (this.codigo != null || other.codigo == null) && (this.codigo == null || this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "entity.Tipolegal[ codigo=" + this.codigo + " ]";
    }

    public String getItemLabel() {
        return this.nome;
    }

    public String getItemId() {
        return Integer.toString(this.codigo);
    }

    @Override
    public String getHashId() {
        return String.valueOf(this.codigo);
    }

    public static class TipoDocumentoLegalSql {
        public static final String DOES_EXIST_BY_CODIGO = "  SELECT COUNT(t.codigo)  FROM TipoDocumentoLegal t  WHERE t.codigo = :codigo ";
        public static final String FIND_BY_NOME = "SELECT t FROM TipoDocumentoLegal t WHERE lower(t.nome) LIKE lower('%'||:param||'%') ORDER BY t.nome";
    }
}

