/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

public enum TipoAfastamentoTceMg {
    AFASTAMENTO_CONJUGUE("01", "01 \u2013 Licen\u00e7a por Motivo de Afastamento do C\u00f4njuge"),
    SERVICO_MILITAR("02", "02 \u2013 Licen\u00e7a para o Servi\u00e7o Militar (desde que n\u00e3o remunerada)"),
    NAO_REMUNERADA_SEM_VENCIMENTO("03", "03 \u2013 Licen\u00e7a n\u00e3o remunerada ou Sem Vencimento"),
    DESEMPENHO_MANDATO_CLASSISTA("04", "04 \u2013 Licen\u00e7a para desempenho de Mandato Classista"),
    RESERVA_NAO_REMUNERADA("05", "05 \u2013 Reserva n\u00e3o remunerada"),
    MANDATO_ELEITORAL("06", "06 - Mandato Eleitoral - Afastamento tempor\u00e1rio para o exerc\u00edcio de mandato eleitoral, sem remunera\u00e7\u00e3o"),
    LICENCA_MEDICA("07", "07 - Licen\u00e7a M\u00e9dica"),
    INSS("08", "08 - INSS"),
    OUTROS("99", "99 - Outros");

    private final String codigo;
    private final String descricao;

    private TipoAfastamentoTceMg(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static TipoAfastamentoTceMg of(String codigo, Integer ano) {
        if (AFASTAMENTO_CONJUGUE.getCodigo().equals(codigo)) {
            return AFASTAMENTO_CONJUGUE;
        }
        if (SERVICO_MILITAR.getCodigo().equals(codigo)) {
            return SERVICO_MILITAR;
        }
        if (NAO_REMUNERADA_SEM_VENCIMENTO.getCodigo().equals(codigo)) {
            return NAO_REMUNERADA_SEM_VENCIMENTO;
        }
        if (DESEMPENHO_MANDATO_CLASSISTA.getCodigo().equals(codigo)) {
            return DESEMPENHO_MANDATO_CLASSISTA;
        }
        if (RESERVA_NAO_REMUNERADA.getCodigo().equals(codigo)) {
            return RESERVA_NAO_REMUNERADA;
        }
        if (MANDATO_ELEITORAL.getCodigo().equals(codigo)) {
            return MANDATO_ELEITORAL;
        }
        if (OUTROS.getCodigo().equals(codigo)) {
            return OUTROS;
        }
        if (LICENCA_MEDICA.getCodigo().equals(codigo) && ano == 2019) {
            return LICENCA_MEDICA;
        }
        if (LICENCA_MEDICA.getCodigo().equals(codigo) && ano != 2019) {
            return OUTROS;
        }
        if (INSS.getCodigo().equals(codigo) && ano.equals("2019")) {
            return INSS;
        }
        if (INSS.getCodigo().equals(codigo) && !ano.equals("2019")) {
            return OUTROS;
        }
        return null;
    }
}

