/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import java.util.Arrays;
import java.util.List;

public enum TipoAdmissao {
    PRIMEIRO_EMPREGO("10", "Primeiro Emprego"),
    REEMPREGO("20", "Reemprego"),
    CONTRATO_DETERMINADO("25", "Contrato por prazo determinado"),
    REINTEGRACAO("35", "Reintegra\u00e7\u00e3o"),
    TRANFERENCIA("70", "Transfer\u00eancia de empregado oriundo de estabelecimento da mesma empresa ou de outra empresa com \u00f4nus para a cedente"),
    TRANFERENCIA_SEM_ONUS("71", "Transfer\u00eancia de empregado oriundo de estabelecimento da mesma empresa ou de outra empresa sem \u00f4nus para a cedente"),
    RECONDUCAO("72", "Recondu\u00e7\u00e3o (espec\u00edfico para servidor p\u00fablico)"),
    REVERSAO("73", "Revers\u00e3o, (espec\u00edfico para servidor p\u00fablico)"),
    CEDIDO("74", "Cedido"),
    READAPTACAO("76", "Readapta\u00e7\u00e3o (espec\u00edfico para servidor p\u00fablico)");

    private final String codigo;
    private final String descricao;

    private TipoAdmissao(String codigo, String descricao) {
        this.codigo = codigo;
        this.descricao = descricao;
    }

    public static final TipoAdmissao of(String codigo) {
        for (TipoAdmissao t : TipoAdmissao.values()) {
            if (!t.codigo.equals(codigo)) continue;
            return t;
        }
        return TRANFERENCIA;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public static List<String> getTiposCessao() {
        return Arrays.asList(TRANFERENCIA.getCodigo(), TipoAdmissao.TRANFERENCIA_SEM_ONUS.codigo, CEDIDO.getCodigo());
    }
}

