/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

public class Telefone {
    private String numeroCompleto;
    private String ddd;
    private String numero;

    public String getNumeroCompleto() {
        return this.numeroCompleto;
    }

    protected void setNumeroCompleto(String numeroCompleto) {
        if (numeroCompleto != null) {
            this.numeroCompleto = numeroCompleto.replaceAll("\\D+", "");
            if (!this.numeroCompleto.equals("")) {
                if (this.numeroCompleto.substring(0, 1).equals("0")) {
                    throw new RuntimeException("Remova os Zeros \u00e0 esquerda do n\u00famero");
                }
                if (this.numeroCompleto.length() > 11) {
                    throw new RuntimeException("Limite de D\u00edgitos do Telefone Excedido. M\u00e1ximo: 11");
                }
                if (this.numeroCompleto.length() >= 10) {
                    this.ddd = this.numeroCompleto.substring(0, 2);
                    this.numero = this.numeroCompleto.substring(2, this.numeroCompleto.length());
                } else {
                    this.numero = this.numeroCompleto;
                    this.ddd = "";
                }
            }
        } else {
            this.ddd = null;
            this.numero = null;
            this.numeroCompleto = null;
        }
    }

    public String getDDD() {
        return this.ddd;
    }

    public String getNumero() {
        return this.numero;
    }

    public String getNumeroCompletoFormatado() {
        return "(" + this.ddd + ")" + this.numero;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.numeroCompleto == null ? 0 : this.numeroCompleto.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Telefone other = (Telefone)obj;
        return !(this.numeroCompleto == null ? other.numeroCompleto != null : !this.numeroCompleto.equals(other.numeroCompleto));
    }

    public String toString() {
        return this.getNumeroCompletoFormatado();
    }
}

