/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigJoin;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.model.FilterJoinType;
import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.api.Documento;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.Eventuais;
import br.com.fiorilli.sip.persistence.entity.HistoricoTrabalhadorCargo;
import br.com.fiorilli.sip.persistence.entity.TipoDocumentoLegal;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=Substituicao.class, autoFilter=true)
@Entity
@Table(name="SUBSTITUICAO")
@Audited
public class Substituicao
implements Serializable,
Documento {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_SUBSTITUICAO";
    public static final String FIND_BY_TRABALHADOR_SUBSTITUTO = "SELECT DISTINCT su FROM Substituicao su JOIN FETCH su.trabalhadorSubstituto WHERE su.trabalhadorSubstituto.trabalhadorPK.entidade = :entidade AND su.trabalhadorSubstituto.trabalhadorPK.registro = :registro";
    public static final String FIND_BY_TRABALHADOR_SUBSTITUIDO = "SELECT DISTINCT su FROM Substituicao su JOIN FETCH su.trabalhadorSubstituido WHERE su.trabalhadorSubstituido.trabalhadorPK.entidade = :entidade AND su.trabalhadorSubstituido.trabalhadorPK.registro = :registro";
    public static final String EXISTS_EVENTUAIS = "SELECT CASE WHEN COALESCE(COUNT(su.eventualCodigo), 0) > 0 THEN true ELSE false END FROM Substituicao su WHERE su.eventualCodigo = :eventualCodigo";
    @NotNull
    @Basic(optional=false)
    @Id
    @Column(name="ID")
    private Integer id;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumns(value={@JoinColumn(name="EMPRESA_CARGO_SUBSTITUIDO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO_CARGO_SUBSTITUIDO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Cargo cargoSubstituido;
    @FilterConfig(label="Cargo Substitu\u00eddo", condition=FilterCondition.COMECE)
    @NotNull
    @Column(name="CODIGO_CARGO_SUBSTITUIDO")
    private String codigoCargoSubstituido;
    @NotNull
    @Column(name="EMPRESA_CARGO_SUBSTITUIDO")
    private String entidadeCargoSubstituido;
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumns(value={@JoinColumn(name="EMPRESA_CARGO_SUBSTITUTO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO_CARGO_SUBSTITUTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Cargo cargoSubstituto;
    @FilterConfig(label="Cargo Substituto", condition=FilterCondition.COMECE)
    @NotNull
    @Column(name="CODIGO_CARGO_SUBSTITUTO")
    private String codigoCargoSubstituto;
    @NotNull
    @Column(name="EMPRESA_CARGO_SUBSTITUTO")
    private String entidadeCargoSubstituto;
    @FilterConfig(label="Trabalhador Substitu\u00eddo", condition=FilterCondition.IGUAL, blockCondition=true, inputType=FilterInputType.AUTO_COMPLETE, order=2)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumns(value={@JoinColumn(name="EMPRESA_TRAB_SUBSTITUIDO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_TRAB_SUBSTITUIDO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhadorSubstituido;
    @FilterConfig(label="Registro Substitu\u00eddo", condition=FilterCondition.COMECE, order=1)
    @NotNull
    @Column(name="REGISTRO_TRAB_SUBSTITUIDO")
    private String registroTrabalhadorSubstituido;
    @NotNull
    @Column(name="EMPRESA_TRAB_SUBSTITUIDO")
    private String entidadeTrabalhadorSubstituido;
    @FilterConfig(label="Trabalhador Substituto", condition=FilterCondition.IGUAL, blockCondition=true, inputType=FilterInputType.AUTO_COMPLETE, order=4)
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @FilterConfigJoin(type=FilterJoinType.LEFT, fetch=true)
    @JoinColumns(value={@JoinColumn(name="EMPRESA_TRAB_SUBSTITUTO", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_TRAB_SUBSTITUTO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador trabalhadorSubstituto;
    @FilterConfig(label="Registro Substituto", condition=FilterCondition.COMECE, order=3)
    @NotNull
    @Column(name="REGISTRO_TRAB_SUBSTITUTO")
    private String registroTrabalhadorSubstituto;
    @NotNull
    @Column(name="EMPRESA_TRAB_SUBSTITUTO")
    private String entidadeTrabalhadorSubstituto;
    @JoinColumn(name="TIPOLEGAL", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private TipoDocumentoLegal tipoLegal;
    @Column(name="TIPOLEGAL")
    private Integer tipoLegalCodigo;
    @Column(name="ID_EVENTUAIS")
    private Integer eventualCodigo;
    @JoinColumn(name="ID_EVENTUAIS", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Eventuais eventual;
    @JoinColumn(name="ID_HISTTRABCARGO", referencedColumnName="ID", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private HistoricoTrabalhadorCargo historicoTrabalhadorCargo;
    @Column(name="ID_HISTTRABCARGO")
    private Integer codigoHistoricoTrabalhadorCargo;
    @Basic(optional=false)
    @Column(name="NUMDOC", length=16)
    private String numeroDocumento;
    @Basic(optional=false)
    @Column(name="DATADOC")
    @Temporal(value=TemporalType.DATE)
    private Date dataDocumento;
    @FilterConfig(label="Per\u00edodo In\u00edcio", condition=FilterCondition.IGUAL, inputType=FilterInputType.CALENDAR)
    @NotNull
    @Basic(optional=false)
    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_INICIO")
    private Date periodoInicio;
    @FilterConfig(label="Per\u00edodo T\u00e9rmino", condition=FilterCondition.IGUAL, inputType=FilterInputType.CALENDAR)
    @NotNull
    @Basic(optional=false)
    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO_TERMINO")
    private Date periodoTermino;
    @Size(max=250)
    @Column(name="MOTIVO")
    private String motivo;

    public Substituicao() {
    }

    public Substituicao(Integer id) {
        this.id = id;
    }

    public Substituicao(Integer id, String numeroDocumento, Date dataDocumento, Date periodoInicio, Date periodoTermino) {
        this.id = id;
        this.numeroDocumento = numeroDocumento;
        this.dataDocumento = dataDocumento;
        this.periodoInicio = periodoInicio;
        this.periodoTermino = periodoTermino;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getPeriodoInicio() {
        return this.periodoInicio;
    }

    public void setPeriodoInicio(Date periodoInicio) {
        this.periodoInicio = periodoInicio;
    }

    public Date getPeriodoTermino() {
        return this.periodoTermino;
    }

    public void setPeriodoTermino(Date periodoTermino) {
        this.periodoTermino = periodoTermino;
    }

    public Cargo getCargoSubstituido() {
        return this.cargoSubstituido;
    }

    public void setCargoSubstituido(Cargo cargoSubstituido) {
        this.codigoCargoSubstituido = cargoSubstituido != null ? cargoSubstituido.getCargoPK().getCodigo() : null;
        this.cargoSubstituido = cargoSubstituido;
    }

    public Cargo getCargoSubstituto() {
        return this.cargoSubstituto;
    }

    public void setCargoSubstituto(Cargo cargoSubstituto) {
        this.codigoCargoSubstituto = cargoSubstituto != null ? cargoSubstituto.getCargoPK().getCodigo() : null;
        this.cargoSubstituto = cargoSubstituto;
    }

    public Trabalhador getTrabalhadorSubstituido() {
        return this.trabalhadorSubstituido;
    }

    public void setTrabalhadorSubstituido(Trabalhador trabalhadorSubstituido) {
        if (trabalhadorSubstituido != null) {
            this.registroTrabalhadorSubstituido = trabalhadorSubstituido.getTrabalhadorPK().getRegistro();
            this.codigoCargoSubstituido = trabalhadorSubstituido.getCargoAtualCodigo();
        } else {
            this.registroTrabalhadorSubstituido = null;
            this.codigoCargoSubstituido = null;
        }
        this.trabalhadorSubstituido = trabalhadorSubstituido;
    }

    public Trabalhador getTrabalhadorSubstituto() {
        return this.trabalhadorSubstituto;
    }

    public void setTrabalhadorSubstituto(Trabalhador trabalhadorSubstituto) {
        if (trabalhadorSubstituto != null) {
            this.registroTrabalhadorSubstituto = trabalhadorSubstituto.getTrabalhadorPK().getRegistro();
            this.codigoCargoSubstituto = trabalhadorSubstituto.getCargoAtualCodigo();
        } else {
            this.registroTrabalhadorSubstituto = null;
            this.codigoCargoSubstituto = null;
        }
        this.trabalhadorSubstituto = trabalhadorSubstituto;
    }

    public Eventuais getEventual() {
        if (this.eventual == null) {
            this.eventual = new Eventuais();
        }
        return this.eventual;
    }

    public void setEventual(Eventuais eventualId) {
        this.eventualCodigo = eventualId != null ? eventualId.getCodigo() : null;
        this.eventual = eventualId;
    }

    public HistoricoTrabalhadorCargo getHistoricoTrabalhadorCargo() {
        if (this.historicoTrabalhadorCargo == null) {
            this.historicoTrabalhadorCargo = new HistoricoTrabalhadorCargo();
        }
        return this.historicoTrabalhadorCargo;
    }

    public void setHistoricoTrabalhadorCargo(HistoricoTrabalhadorCargo historicoItem) {
        this.historicoTrabalhadorCargo = historicoItem;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Substituicao)) {
            return false;
        }
        Substituicao other = (Substituicao)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "Substituicao [id=" + this.id + "]";
    }

    public Integer getEventualCodigo() {
        return this.eventualCodigo;
    }

    public void setEventualCodigo(Integer eventualCodigo) {
        this.eventualCodigo = eventualCodigo;
    }

    public String getRegistroTrabalhadorSubstituido() {
        return this.registroTrabalhadorSubstituido;
    }

    public void setRegistroTrabalhadorSubstituido(String registroTrabalhadorSubstituido) {
        this.registroTrabalhadorSubstituido = registroTrabalhadorSubstituido;
    }

    public String getRegistroTrabalhadorSubstituto() {
        return this.registroTrabalhadorSubstituto;
    }

    public void setRegistroTrabalhadorSubstituto(String registroTrabalhadorSubstituto) {
        this.registroTrabalhadorSubstituto = registroTrabalhadorSubstituto;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Override
    public TipoDocumentoLegal getTipoLegal() {
        return this.tipoLegal;
    }

    @Override
    public void setTipoLegal(TipoDocumentoLegal value) {
        this.tipoLegalCodigo = value != null ? value.getCodigo() : null;
        this.tipoLegal = value;
    }

    @Override
    public Integer getTipoLegalCodigo() {
        return this.tipoLegalCodigo;
    }

    @Override
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Override
    public void setNumeroDocumento(String value) {
        this.numeroDocumento = value;
    }

    @Override
    public Integer getAnoDocumento() {
        return SIPUtil.getAnoFromNumDoc((String)this.numeroDocumento);
    }

    @Override
    public String getNumDocSemAno() {
        return SIPUtil.getNumDocSemAno((String)this.numeroDocumento);
    }

    @Override
    public Date getData() {
        return this.dataDocumento;
    }

    @Override
    public void setData(Date value) {
        this.dataDocumento = value;
    }

    public String getEntidadeTrabalhadorSubstituto() {
        return this.entidadeTrabalhadorSubstituto;
    }

    public void setEntidadeTrabalhadorSubstituto(String entidadeTrabalhadorSubstituto) {
        this.entidadeTrabalhadorSubstituto = entidadeTrabalhadorSubstituto;
    }

    public String getCodigoCargoSubstituido() {
        return this.codigoCargoSubstituido;
    }

    public void setCodigoCargoSubstituido(String codigoCargoSubstituido) {
        this.codigoCargoSubstituido = codigoCargoSubstituido;
    }

    public String getCodigoCargoSubstituto() {
        return this.codigoCargoSubstituto;
    }

    public void setCodigoCargoSubstituto(String codigoCargoSubstituto) {
        this.codigoCargoSubstituto = codigoCargoSubstituto;
    }

    public String getEntidadeCargoSubstituido() {
        return this.entidadeCargoSubstituido;
    }

    public void setEntidadeCargoSubstituido(String entidadeCargoSubstituido) {
        this.entidadeCargoSubstituido = entidadeCargoSubstituido;
    }

    public String getEntidadeCargoSubstituto() {
        return this.entidadeCargoSubstituto;
    }

    public void setEntidadeCargoSubstituto(String entidadeCargoSubstituto) {
        this.entidadeCargoSubstituto = entidadeCargoSubstituto;
    }

    public String getEntidadeTrabalhadorSubstituido() {
        return this.entidadeTrabalhadorSubstituido;
    }

    public void setEntidadeTrabalhadorSubstituido(String entidadeTrabalhadorSubstituido) {
        this.entidadeTrabalhadorSubstituido = entidadeTrabalhadorSubstituido;
    }

    public Integer getCodigoHistoricoTrabalhadorCargo() {
        return this.codigoHistoricoTrabalhadorCargo;
    }

    public void setCodigoHistoricoTrabalhadorCargo(Integer codigoHistoricoTrabalhadorCargo) {
        this.codigoHistoricoTrabalhadorCargo = codigoHistoricoTrabalhadorCargo;
    }
}

