/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DocumentoCriacaoLotacao;
import br.com.fiorilli.sip.persistence.entity.DocumentoExtincaoLotacao;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.Subdivisao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=SubdivisaoItem.class)
@Entity
@Table(name="SUBDIVISAO_ITEM")
@Audited
public class SubdivisaoItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_SUBDIVISAOITEM_BY_SUBDIVISAO = "SELECT s FROM SubdivisaoItem s WHERE s.subdivisaoCodigo = :subdivisaoCod AND s.idPai IS NULL ORDER BY s.codigo";
    public static final String FIND_SUBDIVISAOITEM_BY_ID_PAI = "SELECT s FROM SubdivisaoItem s WHERE s.idPai = :idPai";
    public static final String FIND_SUBDIVISAOITEM_BY_ID = "SELECT s FROM SubdivisaoItem s WHERE s.id = :id";
    public static final String FIND_BY_RESPONSAVEL = "SELECT s FROM SubdivisaoItem s WHERE s.responsavel.trabalhadorPK = :responsavelPK ORDER BY s.nome";
    public static final String GENERATOR = "GEN_SUBDIVISAOITEM";
    @NotNull
    @Basic(optional=false)
    @Id
    @Column(name="ID")
    private Integer id;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidade;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="SUBDIVISAO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Subdivisao subdivisao;
    @Size(min=1, max=6)
    @Column(name="SUBDIVISAO")
    private String subdivisaoCodigo;
    @JoinColumn(name="ID_PAI", referencedColumnName="ID", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private SubdivisaoItem subdivisaoItem;
    @Column(name="ID_PAI")
    private Integer idPai;
    @Column(name="CODIGO")
    @Size(max=60)
    @FilterConfig(label="C\u00f3digo", order=1)
    private String codigo;
    @FilterConfig(label="Nome", order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @JoinColumns(value={@JoinColumn(name="EMPRESA_RESPONSAVEL", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_RESPONSAVEL", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Trabalhador responsavel;
    @Size(min=1, max=6)
    @Column(name="REGISTRO_RESPONSAVEL")
    private String responsavelRegistro;
    @Size(min=1, max=3)
    @Column(name="EMPRESA_RESPONSAVEL")
    private String responsavelEmpresa;
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @Size(max=15)
    @Column(name="SIGLA")
    private String sigla;
    @Embedded
    private Endereco endereco;
    @Embedded
    private DocumentoCriacaoLotacao documentoCriacao;
    @Embedded
    private DocumentoExtincaoLotacao documentoExtincao;

    public SubdivisaoItem() {
    }

    public SubdivisaoItem(String entidade) {
        this.entidade = entidade;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Subdivisao getSubdivisao() {
        if (this.subdivisao == null) {
            this.subdivisao = new Subdivisao();
        }
        return this.subdivisao;
    }

    public void setSubdivisao(Subdivisao subdivisao) {
        if (subdivisao != null) {
            this.setSubdivisaoCodigo(subdivisao.getSubdivisaoPK().getCodigo());
        } else {
            this.setSubdivisaoCodigo(null);
        }
        this.subdivisao = subdivisao;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public Integer getIdPai() {
        return this.idPai;
    }

    public void setIdPai(Integer idPai) {
        this.idPai = idPai;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setResponsavel(Trabalhador responsavel) {
        if (responsavel != null) {
            this.setResponsavelRegistro(responsavel.getTrabalhadorPK().getRegistro());
            this.setResponsavelEmpresa(responsavel.getTrabalhadorPK().getEntidade());
        } else {
            this.setResponsavelRegistro(null);
            this.setResponsavelEmpresa(null);
        }
        this.responsavel = responsavel;
    }

    public String getResponsavelRegistro() {
        return this.responsavelRegistro;
    }

    public void setResponsavelRegistro(String responsavelRegistro) {
        this.responsavelRegistro = responsavelRegistro;
    }

    public String getResponsavelEmpresa() {
        return this.responsavelEmpresa;
    }

    public void setResponsavelEmpresa(String responsavelEmpresa) {
        this.responsavelEmpresa = responsavelEmpresa;
    }

    public String getSubdivisaoCodigo() {
        return this.subdivisaoCodigo;
    }

    public void setSubdivisaoCodigo(String subdivisaoCodigo) {
        this.subdivisaoCodigo = subdivisaoCodigo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubdivisaoItem)) {
            return false;
        }
        SubdivisaoItem other = (SubdivisaoItem)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "SubdivisaoItem [id=" + this.id + "]";
    }

    public SubdivisaoItem getSubdivisaoItem() {
        return this.subdivisaoItem;
    }

    public void setSubdivisaoItem(SubdivisaoItem subdivisaoItem) {
        this.subdivisaoItem = subdivisaoItem;
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String identificador) {
        this.identificador = identificador;
    }

    public String getSigla() {
        return this.sigla;
    }

    public void setSigla(String sigla) {
        this.sigla = sigla;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public DocumentoCriacaoLotacao getDocumentoCriacao() {
        if (this.documentoCriacao == null) {
            this.documentoCriacao = new DocumentoCriacaoLotacao();
        }
        return this.documentoCriacao;
    }

    public void setDocumentoCriacao(DocumentoCriacaoLotacao documentoCriacao) {
        this.documentoCriacao = documentoCriacao;
    }

    public DocumentoExtincaoLotacao getDocumentoExtincao() {
        if (this.documentoExtincao == null) {
            this.documentoExtincao = new DocumentoExtincaoLotacao();
        }
        return this.documentoExtincao;
    }

    public void setDocumentoExtincao(DocumentoExtincaoLotacao documentoExtincao) {
        this.documentoExtincao = documentoExtincao;
    }
}

