/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigSelect;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.api.GenericEntity;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.SubdivisaoPK;
import br.com.fiorilli.sip.persistence.entity.SubdivisaoTcmgo;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=Subdivisao.class)
@Entity
@Table(name="SUBDIVISAO")
@Audited
public class Subdivisao
implements Serializable,
Filterable,
GenericEntity {
    private static final long serialVersionUID = 1L;
    public static final String FIND_SUBDIVISAO_BY_DIVISAO = "SELECT s FROM Subdivisao s WHERE s.divisaoCodigo = :divisaoCodigo and s.divisaoEmpresa = :divisaoEmpresa";
    public static final String QUERY_FIND_ALL = "SELECT s FROM Subdivisao s";
    public static final String FIND_FOR_FILTER = "SELECT s FROM Subdivisao s WHERE UPPER(concat(s.subdivisaoPK.codigo, s.nome)) LIKE UPPER('%'||:param||'%') AND s.subdivisaoPK.entidade = :entidadeCodigo";
    public static final String FIND_RESPONSAVEL = "SELECT d.responsavel FROM Subdivisao d WHERE d.subdivisaoPK = :subdivisaoPK";
    public static final String FIND_BY_ENTIDADE_NOME = "SELECT d FROM Subdivisao d WHERE (d.subdivisaoPK.entidade = :entidadeId OR :entidadeId = '000') AND d.nome LIKE :nome";
    public static final String FIND_BY_RESPONSAVEL = "SELECT s FROM Subdivisao s WHERE s.responsavel.trabalhadorPK = :responsavelPK ORDER BY s.nome";
    public static final String FIND_BY_CODIGO = "SELECT s FROM Subdivisao s WHERE s.subdivisaoPK.codigo = :codigo";
    public static final String FIND_BY_ENTIDADE_CODIGO = "SELECT d FROM Subdivisao d WHERE (d.subdivisaoPK.entidade = :entidadeId OR :entidadeId = '000') AND d.subdivisaoPK.codigo = :codigo";
    @EmbeddedId
    protected SubdivisaoPK subdivisaoPK;
    @FilterConfig(label="Nome", order=2)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @JoinColumns(value={@JoinColumn(name="DIVISAO_EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="DIVISAO_CODIGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Divisao divisao;
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Entidade entidade;
    @Size(max=3)
    @Column(name="DIVISAO_EMPRESA")
    private String divisaoEmpresa;
    @Size(max=6)
    @Column(name="DIVISAO_CODIGO")
    private String divisaoCodigo;
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String responsavelRegistro;
    @Size(max=18)
    @Column(name="IDENTIFICADOR")
    private String identificador;
    @Column(name="CODIGO", insertable=false, updatable=false)
    private String codigo;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DTEXTINCAO")
    private Date dataExtincao;
    @FilterConfigSelect(query="SELECT t FROM Trabalhador t WHERE concat(t.matricula, t.trabalhadorPK.registro, lower(t.nome)) LIKE lower('%'||:param||'%') AND t.situacao = '1' AND t.trabalhadorPK.entidade = :entidadeCodigo")
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Trabalhador responsavel;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="SUBDIVISAO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private SubdivisaoTcmgo tcmgo;

    public Subdivisao() {
        this.subdivisaoPK = new SubdivisaoPK();
    }

    public void postLoad() {
    }

    public Subdivisao(SubdivisaoPK subdivisaoPK) {
        this.subdivisaoPK = subdivisaoPK;
    }

    public Subdivisao(String entidade, String codigo) {
        this.subdivisaoPK = new SubdivisaoPK(entidade, codigo);
    }

    public SubdivisaoPK getSubdivisaoPK() {
        return this.subdivisaoPK;
    }

    public void setSubdivisaoPK(SubdivisaoPK subdivisaoPK) {
        this.subdivisaoPK = subdivisaoPK;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Trabalhador responsavel) {
        this.responsavelRegistro = responsavel != null ? responsavel.getTrabalhadorPK().getRegistro() : null;
        this.responsavel = responsavel;
    }

    public String getDivisaoEmpresa() {
        return this.divisaoEmpresa;
    }

    public void setDivisaoEmpresa(String divisaoEmpresa) {
        this.divisaoEmpresa = divisaoEmpresa;
    }

    public String getDivisaoCodigo() {
        return this.divisaoCodigo;
    }

    public void setDivisaoCodigo(String divisaoCodigo) {
        this.divisaoCodigo = divisaoCodigo;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.subdivisaoPK != null ? this.subdivisaoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Subdivisao)) {
            return false;
        }
        Subdivisao other = (Subdivisao)object;
        return (this.subdivisaoPK != null || other.subdivisaoPK == null) && (this.subdivisaoPK == null || this.subdivisaoPK.equals(other.subdivisaoPK));
    }

    public String toString() {
        return "entity.Subdivisao[ subdivisaoPK=" + this.subdivisaoPK + " ]";
    }

    @Override
    public String getHashId() {
        return this.subdivisaoPK.getCodigo();
    }

    public String getItemId() {
        return String.valueOf(this.hashCode());
    }

    public String getItemLabel() {
        return this.nome;
    }

    public Divisao getDivisao() {
        return this.divisao;
    }

    public void setDivisao(Divisao divisao) {
        this.divisao = divisao;
    }

    public String getCodigo() {
        if (this.subdivisaoPK != null) {
            this.codigo = this.subdivisaoPK.getCodigo();
        }
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public Date getDataExtincao() {
        return this.dataExtincao;
    }

    public void setDataExtincao(Date dataExtincao) {
        this.dataExtincao = dataExtincao;
    }
}

