/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SolicitacaoAlteracaoCadastral;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorDocumentoApresentado;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SOLICITACAO_ALT_CAD_DOC")
@Audited
public class SolicitacaoAlteracaoCadastralDoc
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(name="NOMEARQ")
    @Size(max=60)
    private String nome;
    @Column(name="HASHARQ")
    @Size(max=32)
    private String hash;
    @Basic(fetch=FetchType.LAZY)
    @Lob
    @Column(name="PDF")
    private byte[] pdf;
    @ManyToOne
    @JoinColumn(name="SOLICITACAO_ID", nullable=false)
    private SolicitacaoAlteracaoCadastral solicitacao;
    @Type(type="DocumentosApresentados")
    @Column(name="DOCUMENTOS_SELECIONADOS")
    private List<TrabalhadorDocumentoApresentado> documentosSelecionados;

    public String getLabelAllTipo() {
        if (this.documentosSelecionados != null && !this.documentosSelecionados.isEmpty()) {
            String label = "";
            int contador = 1;
            for (TrabalhadorDocumentoApresentado tipo : this.documentosSelecionados) {
                label = label + tipo.getLabel();
                if (contador < this.documentosSelecionados.size()) {
                    label = label + ", ";
                }
                ++contador;
            }
            return label;
        }
        return "";
    }

    public int getId() {
        return this.id;
    }

    public String getNome() {
        return this.nome;
    }

    public String getHash() {
        return this.hash;
    }

    public byte[] getPdf() {
        return this.pdf;
    }

    public SolicitacaoAlteracaoCadastral getSolicitacao() {
        return this.solicitacao;
    }

    public List<TrabalhadorDocumentoApresentado> getDocumentosSelecionados() {
        return this.documentosSelecionados;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setPdf(byte[] pdf) {
        this.pdf = pdf;
    }

    public void setSolicitacao(SolicitacaoAlteracaoCadastral solicitacao) {
        this.solicitacao = solicitacao;
    }

    public void setDocumentosSelecionados(List<TrabalhadorDocumentoApresentado> documentosSelecionados) {
        this.documentosSelecionados = documentosSelecionados;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolicitacaoAlteracaoCadastralDoc)) {
            return false;
        }
        SolicitacaoAlteracaoCadastralDoc other = (SolicitacaoAlteracaoCadastralDoc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$nome = this.getNome();
        String other$nome = other.getNome();
        if (this$nome == null ? other$nome != null : !this$nome.equals(other$nome)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        if (!Arrays.equals(this.getPdf(), other.getPdf())) {
            return false;
        }
        SolicitacaoAlteracaoCadastral this$solicitacao = this.getSolicitacao();
        SolicitacaoAlteracaoCadastral other$solicitacao = other.getSolicitacao();
        if (this$solicitacao == null ? other$solicitacao != null : !((Object)this$solicitacao).equals(other$solicitacao)) {
            return false;
        }
        List<TrabalhadorDocumentoApresentado> this$documentosSelecionados = this.getDocumentosSelecionados();
        List<TrabalhadorDocumentoApresentado> other$documentosSelecionados = other.getDocumentosSelecionados();
        return !(this$documentosSelecionados == null ? other$documentosSelecionados != null : !((Object)this$documentosSelecionados).equals(other$documentosSelecionados));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SolicitacaoAlteracaoCadastralDoc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $nome = this.getNome();
        result = result * 59 + ($nome == null ? 43 : $nome.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPdf());
        SolicitacaoAlteracaoCadastral $solicitacao = this.getSolicitacao();
        result = result * 59 + ($solicitacao == null ? 43 : ((Object)$solicitacao).hashCode());
        List<TrabalhadorDocumentoApresentado> $documentosSelecionados = this.getDocumentosSelecionados();
        result = result * 59 + ($documentosSelecionados == null ? 43 : ((Object)$documentosSelecionados).hashCode());
        return result;
    }

    public String toString() {
        return "SolicitacaoAlteracaoCadastralDoc(id=" + this.getId() + ", nome=" + this.getNome() + ", hash=" + this.getHash() + ", pdf=" + Arrays.toString(this.getPdf()) + ", solicitacao=" + this.getSolicitacao() + ", documentosSelecionados=" + this.getDocumentosSelecionados() + ")";
    }
}

