/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.DadoAlteravelFormulario;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoSituacao;
import br.com.fiorilli.sip.persistence.entity.SolicitacaoAlteracaoCadastralDoc;
import br.com.fiorilli.sip.persistence.entity.SolicitacaoAlteracaoCadastralFoto;
import br.com.fiorilli.sip.persistence.entity.SolicitacaoAlteracaoCadastralRegistro;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="SOLICITACAO_ALT_CAD")
@Audited
public class SolicitacaoAlteracaoCadastral
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR_FORM = "SELECT s FROM SolicitacaoAlteracaoCadastral s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK AND s.formulario = :formulario ORDER BY s.dataSolicitacao DESC";
    public static final String FIND_BY_TRABALHADOR_PERIOD = "SELECT s FROM SolicitacaoAlteracaoCadastral s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK \tAND s.dataSolicitacao BETWEEN :dataInicial AND :dataFinal";
    public static final String FIND_BY_TRABALHADOR_SITUACAO_PERIOD = "SELECT s FROM SolicitacaoAlteracaoCadastral s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK \tAND s.situacao = :situacao \tAND s.dataSolicitacao BETWEEN :dataInicial AND :dataFinal";
    @Id
    @Column(unique=true, nullable=false)
    private int id;
    @Column(nullable=false, length=32)
    private String protocolo;
    @Column(name="DATA_SOLICITACAO", nullable=false)
    private Date dataSolicitacao;
    @Column(name="FORM_ID")
    private int formulario;
    @Enumerated
    private SipwebSolicitacaoSituacao situacao;
    @OneToMany(mappedBy="solicitacao", cascade={CascadeType.PERSIST})
    private List<SolicitacaoAlteracaoCadastralRegistro> registrosList;
    @OneToMany(mappedBy="solicitacao", cascade={CascadeType.PERSIST})
    private List<SolicitacaoAlteracaoCadastralDoc> documentosApresentados;
    @OneToMany(mappedBy="solicitacao", cascade={CascadeType.PERSIST})
    private List<SolicitacaoAlteracaoCadastralFoto> fotosApresentadas;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="ENTIDADE", referencedColumnName="EMPRESA"), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO")})
    private Trabalhador trabalhador;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String potocolo) {
        this.protocolo = potocolo;
    }

    public List<SolicitacaoAlteracaoCadastralRegistro> getRegistrosList() {
        return this.registrosList;
    }

    public void setRegistrosList(List<SolicitacaoAlteracaoCadastralRegistro> solicitacaoAltCadRegs) {
        this.registrosList = solicitacaoAltCadRegs;
    }

    public SolicitacaoAlteracaoCadastralRegistro addSolicitacaoAltCadReg(SolicitacaoAlteracaoCadastralRegistro solicitacaoAltCadReg) {
        this.getRegistrosList().add(solicitacaoAltCadReg);
        solicitacaoAltCadReg.setSolicitacao(this);
        return solicitacaoAltCadReg;
    }

    public SolicitacaoAlteracaoCadastralRegistro removeSolicitacaoAltCadReg(SolicitacaoAlteracaoCadastralRegistro solicitacaoAltCadReg) {
        this.getRegistrosList().remove(solicitacaoAltCadReg);
        solicitacaoAltCadReg.setSolicitacao(null);
        return solicitacaoAltCadReg;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SolicitacaoAlteracaoCadastral other = (SolicitacaoAlteracaoCadastral)obj;
        return this.id == other.id;
    }

    public SipwebSolicitacaoSituacao getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SipwebSolicitacaoSituacao situacao) {
        this.situacao = situacao;
    }

    public void addRegistro(SolicitacaoAlteracaoCadastralRegistro registro) {
        if (this.registrosList == null) {
            this.registrosList = new ArrayList<SolicitacaoAlteracaoCadastralRegistro>();
        }
        this.registrosList.add(registro);
        registro.setSolicitacao(this);
    }

    public void removeRegistro(SolicitacaoAlteracaoCadastralRegistro registro) {
        if (this.registrosList != null && !this.registrosList.isEmpty()) {
            this.registrosList.remove(registro);
            registro.setSolicitacao(null);
        }
    }

    public void addDocumentoApresentado(SolicitacaoAlteracaoCadastralDoc documento) {
        if (this.documentosApresentados == null) {
            this.documentosApresentados = new ArrayList<SolicitacaoAlteracaoCadastralDoc>();
        }
        this.documentosApresentados.add(documento);
        documento.setSolicitacao(this);
    }

    public void addFotoApresentada(SolicitacaoAlteracaoCadastralFoto foto) {
        if (this.fotosApresentadas == null) {
            this.fotosApresentadas = new ArrayList<SolicitacaoAlteracaoCadastralFoto>();
        }
        this.fotosApresentadas.add(foto);
        foto.setSolicitacao(this);
    }

    public void removeDocumentoApresentado(SolicitacaoAlteracaoCadastralDoc documento) {
        if (this.documentosApresentados != null && !this.documentosApresentados.isEmpty()) {
            this.documentosApresentados.remove(documento);
            documento.setSolicitacao(null);
        }
    }

    public void removeFotoApresentada(SolicitacaoAlteracaoCadastralFoto foto) {
        if (this.fotosApresentadas != null && !this.fotosApresentadas.isEmpty()) {
            this.fotosApresentadas.remove(foto);
            foto.setSolicitacao(null);
        }
    }

    public DadoAlteravelFormulario getFormulario() {
        return DadoAlteravelFormulario.getEntity(this.formulario);
    }

    public void setFormulario(DadoAlteravelFormulario formularioId) {
        this.formulario = formularioId.getId();
    }

    public List<SolicitacaoAlteracaoCadastralDoc> getDocumentosApresentados() {
        return this.documentosApresentados;
    }

    public void setDocumentosApresentados(List<SolicitacaoAlteracaoCadastralDoc> documentosApresentados) {
        this.documentosApresentados = documentosApresentados;
    }

    public List<SolicitacaoAlteracaoCadastralFoto> getFotosApresentadas() {
        return this.fotosApresentadas;
    }

    public void setFotosApresentadas(List<SolicitacaoAlteracaoCadastralFoto> fotosApresentadas) {
        this.fotosApresentadas = fotosApresentadas;
    }
}

