/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.LicencaPremio;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoSituacao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPWEBSOLICITACAOLICPREM")
@Audited
public class SipwebSolicitacaoLicencaPremio
implements Serializable,
Cloneable {
    public static final String IS_MES_DUPLICADO = "SELECT CASE WHEN (count(s) > 0) THEN true ELSE false END FROM SipwebSolicitacaoLicencaPremio s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK AND s.pagamentoAno = :pagamentoAno AND s.pagamentoMes = :pagamentoMes AND s.situacaoRh <> 1";
    public static final String IS_GOZO_DUPLICADO = "SELECT CASE WHEN (count(s) > 0) THEN true ELSE false END FROM SipwebSolicitacaoLicencaPremio s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK AND s.gozoInicio = :gozoInicio AND s.gozoFim = :gozoFim AND s.situacaoRh <> 1";
    public static final String FIND_BY_TRABALHADOR = "SELECT s FROM SipwebSolicitacaoLicencaPremio s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY s.dataSolicitacao DESC";
    public static final String FIND_FOR_AVALIAR = "SELECT s FROM SipwebSolicitacaoLicencaPremio s WHERE s.hash = :hash AND s.situacaoResponsavel = 0";
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ID")
    private String protocolo;
    private short diasAbono;
    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false)
    private Date gozoFim;
    @Temporal(value=TemporalType.DATE)
    @Column(name="GOZOINI", nullable=false)
    private Date gozoInicio;
    @Column(name="PAGTOANO", nullable=false, length=4)
    private String pagamentoAno;
    @Column(name="PAGTOMES", nullable=false, length=2)
    private String pagamentoMes;
    @Enumerated
    @Column(name="SITUACAO", nullable=false)
    private SipwebSolicitacaoSituacao situacaoRh;
    @Column(name="TEXTO_RESPOSTA", length=100)
    private String textoResposta;
    @Column(name="TEXTO_SOLICITACAO", length=100)
    private String textoSolicitacao;
    @Column(name="TIMESTAMPRESPOSTA")
    private Date dataRespostaRh;
    @Column(name="TIMESTAMPSOLICITACAO", nullable=false)
    private Date dataSolicitacao;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_RESPONSAVEL", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador responsavel;
    @Column(name="DATA_RESP_RESPONSAVEL")
    private Date dataRespostaResponsavel;
    @Column(name="SITUACAO_RESPONSAVEL")
    @Enumerated
    private SipwebSolicitacaoSituacao situacaoResponsavel;
    @Column(name="PERIODO_AQUISITIVO")
    private Short periodoAquisitivoId;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", updatable=false, insertable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", updatable=false, insertable=false), @JoinColumn(name="PERIODO_AQUISITIVO", referencedColumnName="ITEM", updatable=false, insertable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private LicencaPremio periodoAquisitivo;
    @Column(length=32)
    private String hash;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeId;
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String trabalhadorRegistro;
    @Size(min=1, max=6)
    @Column(name="REGISTRO_RESPONSAVEL")
    private String responsavelRegistro;
    @Transient
    private String periodoGozo;
    @Transient
    private String referencia;

    public String getPeriodoGozo() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        return sdf.format(this.getGozoInicio()) + " - " + sdf.format(this.getGozoFim());
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String id) {
        this.protocolo = id;
    }

    public short getDiasAbono() {
        return this.diasAbono;
    }

    public void setDiasAbono(short diasAbono) {
        this.diasAbono = diasAbono;
    }

    public Date getGozoFim() {
        return this.gozoFim;
    }

    public void setGozoFim(Date gozoFim) {
        this.gozoFim = gozoFim;
    }

    public Date getGozoInicio() {
        return this.gozoInicio;
    }

    public void setGozoInicio(Date gozoInicio) {
        this.gozoInicio = gozoInicio;
    }

    public String getPagamentoAno() {
        return this.pagamentoAno;
    }

    public void setPagamentoAno(String pagamentoAno) {
        this.pagamentoAno = pagamentoAno;
    }

    public String getPagamentoMes() {
        return this.pagamentoMes;
    }

    public void setPagamentoMes(String pagamentoMes) {
        this.pagamentoMes = pagamentoMes;
    }

    public String getTextoResposta() {
        return this.textoResposta;
    }

    public void setTextoResposta(String textoResposta) {
        this.textoResposta = textoResposta;
    }

    public String getTextoSolicitacao() {
        return this.textoSolicitacao;
    }

    public void setTextoSolicitacao(String textoSolicitacao) {
        this.textoSolicitacao = textoSolicitacao;
    }

    public Date getDataRespostaRh() {
        return this.dataRespostaRh;
    }

    public void setDataRespostaRh(Date resposta) {
        this.dataRespostaRh = resposta;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setTimeStampSolicitacao(Date solicitacao) {
        this.dataSolicitacao = solicitacao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        this.trabalhadorRegistro = this.trabalhador.getTrabalhadorPK().getRegistro();
        this.entidadeId = this.trabalhador.getTrabalhadorPK().getEntidade();
    }

    public String getReferencia() {
        if (!(this.referencia == null || !this.referencia.isEmpty() || this.getPagamentoAno().isEmpty() && this.getPagamentoMes().isEmpty())) {
            return (this.getPagamentoMes().isEmpty() ? "  " : this.getPagamentoMes()) + "/" + this.getPagamentoAno();
        }
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
        this.setPagamentoMes(referencia.substring(0, 2));
        this.setPagamentoAno(referencia.substring(3, 7));
    }

    public SipwebSolicitacaoSituacao getSituacaoRh() {
        return this.situacaoRh;
    }

    public void setSituacaoRh(SipwebSolicitacaoSituacao situacao) {
        this.situacaoRh = situacao;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Trabalhador responsavel) {
        this.responsavelRegistro = responsavel != null ? this.responsavel.getTrabalhadorPK().getRegistro() : null;
        this.responsavel = responsavel;
    }

    public Date getDataRespostaResponsavel() {
        return this.dataRespostaResponsavel;
    }

    public void setDataRespostaResponsavel(Date dataRespostaResponsavel) {
        this.dataRespostaResponsavel = dataRespostaResponsavel;
    }

    public SipwebSolicitacaoSituacao getSituacaoResponsavel() {
        return this.situacaoResponsavel;
    }

    public void setSituacaoResponsavel(SipwebSolicitacaoSituacao situacaoResponsavel) {
        this.situacaoResponsavel = situacaoResponsavel;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getEntidadeId() {
        return this.entidadeId;
    }

    public void setEntidadeId(String entidadeId) {
        this.entidadeId = entidadeId;
    }

    public String getTrabalhadorRegistro() {
        return this.trabalhadorRegistro;
    }

    public void setTrabalhadorRegistro(String trabalhadorRegistro) {
        this.trabalhadorRegistro = trabalhadorRegistro;
    }

    public String getResponsavelRegistro() {
        return this.responsavelRegistro;
    }

    public void setResponsavelRegistro(String responsavelRegistro) {
        this.responsavelRegistro = responsavelRegistro;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public Short getPeriodoAquisitivoId() {
        return this.periodoAquisitivoId;
    }

    public void setPeriodoAquisitivoId(Short periodoAquisitivoId) {
        this.periodoAquisitivoId = periodoAquisitivoId;
    }

    public LicencaPremio getPeriodoAquisitivo() {
        return this.periodoAquisitivo;
    }

    public void setPeriodoAquisitivo(LicencaPremio periodo) {
        this.periodoAquisitivoId = periodo != null ? Short.valueOf(periodo.getLicencaPremioPK().getItem()) : null;
        this.periodoAquisitivo = periodo;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocolo == null ? 0 : this.protocolo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipwebSolicitacaoLicencaPremio other = (SipwebSolicitacaoLicencaPremio)obj;
        return !(this.protocolo == null ? other.protocolo != null : !this.protocolo.equals(other.protocolo));
    }
}

