/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.util.SIPUtil;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Ferias;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoSituacao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

@Entity
@Table(name="SIPWEBSOLICITACAOFERIAS")
@Audited
public class SipwebSolicitacaoFerias
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR = "SELECT s FROM SipwebSolicitacaoFerias s WHERE s.trabalhador = :trabalhador ORDER BY s.dataSolicitacao DESC";
    public static final String IS_GOZO_DUPLICADO = "SELECT s FROM SipwebSolicitacaoFerias s WHERE s.trabalhador = :trabalhador AND s.gozoInicio = :gozoInicio AND s.gozoFim = :gozoFim AND s.situacaoRh <> 1 AND s.protocolo <> :protocolo ";
    public static final String IS_MES_PAGAMENTO_DUPLICADO = "SELECT s FROM SipwebSolicitacaoFerias s WHERE s.trabalhador = :trabalhador AND s.pagamentoAno = :ano AND s.pagamentoMes = :mes AND s.situacaoRh <> 1";
    public static final String FIND_FOR_AVALIAR = "SELECT s FROM SipwebSolicitacaoFerias s WHERE s.hash = :hash AND s.situacaoResponsavel = 0";
    @Id
    @Column(name="ID")
    private String protocolo;
    private short diasAbono;
    @Column(name="GOZOFIM")
    @Temporal(value=TemporalType.DATE)
    private Date gozoFim;
    @Temporal(value=TemporalType.DATE)
    @Column(name="GOZOINI")
    private Date gozoInicio;
    @Column(name="PAGTOANO")
    private String pagamentoAno;
    @Column(name="PAGTOMES")
    private String pagamentoMes;
    @Column(name="TEXTO_RESPOSTA")
    private String textoResposta;
    @Column(name="TEXTO_SOLICITACAO")
    private String textoSolicitacao;
    @Column(name="TIMESTAMPRESPOSTA")
    private Date dataRespostaRh;
    @Column(name="TIMESTAMPSOLICITACAO")
    private Date dataSolicitacao;
    @Enumerated
    @Column(name="SITUACAO")
    private SipwebSolicitacaoSituacao situacaoRh;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_RESPONSAVEL", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador responsavel;
    @Column(name="DATA_RESP_RESPONSAVEL")
    private Date dataRespostaResponsavel;
    @Column(name="SITUACAO_RESPONSAVEL")
    @Enumerated
    private SipwebSolicitacaoSituacao situacaoResponsavel;
    @Column(length=32)
    private String hash;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="EMPRESA")
    private String entidadeId;
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO")
    private String trabalhadorRegistro;
    @Size(min=1, max=6)
    @Column(name="REGISTRO_RESPONSAVEL")
    private String responsavelRegistro;
    @JoinColumn(name="PERIODO_AQUISITIVO", referencedColumnName="CODIGO", updatable=false, insertable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Ferias periodoAquisitivo;
    @Column(name="PERIODO_AQUISITIVO")
    private Integer periodoAquisitivoCodigo;
    @Transient
    private double daysFerias;
    @Transient
    private String periodoGozo;
    @Transient
    @Pattern(regexp="(0?[1-9]|1[012])/((19|20)\\d\\d)")
    private String mesPagamento;

    public void setDaysFerias(double daysFerias) {
        try {
            int days = (int)daysFerias;
            this.setGozoFim(days > 0 && this.getGozoInicio() != null ? DateUtils.addDays((Date)this.getGozoInicio(), (int)(days - 1)) : null);
            this.daysFerias = days;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.daysFerias = daysFerias;
        }
    }

    public double getDaysFerias() {
        try {
            return this.getGozoInicio() != null && this.getGozoFim() != null ? SIPUtil.getDaysBetween((Date)this.getGozoInicio(), (Date)this.getGozoFim()) + 1.0 : 0.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.daysFerias;
        }
    }

    public String getPeriodoGozo() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        return sdf.format(this.gozoInicio) + " - " + sdf.format(this.gozoFim);
    }

    public String getMesPagamento() {
        this.mesPagamento = this.getPagamentoAno() != null && this.getPagamentoMes() != null ? this.getPagamentoMes() + "/" + this.getPagamentoAno() : null;
        return this.mesPagamento;
    }

    public void setMesPagamento(String mesPagamento) {
        this.mesPagamento = mesPagamento;
        if (!StringUtils.isEmpty((CharSequence)mesPagamento)) {
            this.setPagamentoMes(mesPagamento.substring(0, 2));
            this.setPagamentoAno(mesPagamento.substring(3, 7));
        }
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String id) {
        this.protocolo = id;
    }

    public short getDiasAbono() {
        return this.diasAbono;
    }

    public void setDiasAbono(short diasabono) {
        this.diasAbono = diasabono;
    }

    public Date getGozoFim() {
        return this.gozoFim;
    }

    public void setGozoFim(Date gozoFim) {
        this.gozoFim = gozoFim;
    }

    public Date getGozoInicio() {
        return this.gozoInicio;
    }

    public void setGozoInicio(Date gozoInicio) {
        this.gozoInicio = gozoInicio;
    }

    public String getPagamentoAno() {
        return this.pagamentoAno;
    }

    public void setPagamentoAno(String pagtoano) {
        this.pagamentoAno = pagtoano;
    }

    public String getPagamentoMes() {
        return this.pagamentoMes;
    }

    public void setPagamentoMes(String pagtomes) {
        this.pagamentoMes = pagtomes;
    }

    public String getTextoResposta() {
        return this.textoResposta;
    }

    public void setTextoResposta(String textoResposta) {
        this.textoResposta = textoResposta;
    }

    public String getTextoSolicitacao() {
        return this.textoSolicitacao;
    }

    public void setTextoSolicitacao(String textoSolicitacao) {
        this.textoSolicitacao = textoSolicitacao;
    }

    public Date getDataRespostaRh() {
        return this.dataRespostaRh;
    }

    public void setDataRespostaRh(Date timestampResposta) {
        this.dataRespostaRh = timestampResposta;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date timestampSolicitacao) {
        this.dataSolicitacao = timestampSolicitacao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        this.trabalhadorRegistro = trabalhador.getTrabalhadorPK().getRegistro();
        this.entidadeId = trabalhador.getTrabalhadorPK().getEntidade();
    }

    public SipwebSolicitacaoSituacao getSituacaoRh() {
        return this.situacaoRh;
    }

    public void setSituacaoRh(SipwebSolicitacaoSituacao situacao) {
        this.situacaoRh = situacao;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Trabalhador responsavel) {
        this.responsavelRegistro = responsavel != null ? responsavel.getTrabalhadorPK().getRegistro() : null;
        this.responsavel = responsavel;
    }

    public Date getDataRespostaResponsavel() {
        return this.dataRespostaResponsavel;
    }

    public void setDataRespostaResponsavel(Date dataRespostaResponsavel) {
        this.dataRespostaResponsavel = dataRespostaResponsavel;
    }

    public SipwebSolicitacaoSituacao getSituacaoResponsavel() {
        return this.situacaoResponsavel;
    }

    public void setSituacaoResponsavel(SipwebSolicitacaoSituacao situacaoResponsavel) {
        this.situacaoResponsavel = situacaoResponsavel;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getEntidadeId() {
        return this.entidadeId;
    }

    public void setEntidadeId(String entidadeId) {
        this.entidadeId = entidadeId;
    }

    public String getTrabalhadorRegistro() {
        return this.trabalhadorRegistro;
    }

    public void setTrabalhadorRegistro(String trabalhadorRegistro) {
        this.trabalhadorRegistro = trabalhadorRegistro;
    }

    public String getResponsavelRegistro() {
        return this.responsavelRegistro;
    }

    public void setResponsavelRegistro(String responsavelRegistro) {
        this.responsavelRegistro = responsavelRegistro;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocolo == null ? 0 : this.protocolo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipwebSolicitacaoFerias other = (SipwebSolicitacaoFerias)obj;
        return !(this.protocolo == null ? other.protocolo != null : !this.protocolo.equals(other.protocolo));
    }

    public Ferias getPeriodoAquisitivo() {
        return this.periodoAquisitivo;
    }

    public void setPeriodoAquisitivo(Ferias periodoAquisitivo) {
        this.periodoAquisitivo = periodoAquisitivo;
        this.periodoAquisitivoCodigo = periodoAquisitivo != null ? periodoAquisitivo.getCodigo() : null;
    }

    public Integer getPeriodoAquisitivoCodigo() {
        return this.periodoAquisitivoCodigo;
    }

    public void setPeriodoAquisitivoCodigo(Integer periodoAquisitivoCodigo) {
        this.periodoAquisitivoCodigo = periodoAquisitivoCodigo;
    }
}

