/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.commons.protocoloautenticacao.SipProtocoloAutenticacaoFactory;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoPdf;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoSituacao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPWEBSOLICITACAOFALTAABONADA")
@Audited
public class SipwebSolicitacaoFaltaAbonada
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR = "SELECT s FROM SipwebSolicitacaoFaltaAbonada s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY s.dataAbono DESC";
    public static final String FIND_BY_TRABALHADOR_AND_SITUACAO_AND_ANO = "SELECT s FROM SipwebSolicitacaoFaltaAbonada s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK \tAND extract(year from s.dataAbono) = :ano \tAND s.situacaoRh = :situacao";
    public static final String FIND_FOR_AVALIAR = "SELECT s FROM SipwebSolicitacaoFaltaAbonada s WHERE s.hash = :hash AND s.situacaoResponsavel = 0";
    public static final String COUNT_BY_TRAB_AND_SITUACAO_AND_ANO = "SELECT COUNT(s) FROM SipwebSolicitacaoFaltaAbonada s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK AND s.situacaoRh = :situacao AND YEAR(s.dataSolicitacao) = :ano";
    public static final String COUNT_BY_TRAB_AND_SITUACAO_AND_MES_AND_ANO = "SELECT COUNT(s) FROM SipwebSolicitacaoFaltaAbonada s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK AND s.situacaoRh = :situacao AND MONTH(s.dataSolicitacao) = :mes AND YEAR(s.dataSolicitacao) = :ano";
    @Id
    @Column(unique=true, nullable=false, length=16)
    private String protocolo;
    @Column(name="DATA_ABONO", nullable=false)
    private Date dataAbono;
    @Column(name="DATA_SOLICITACAO", nullable=false)
    private Date dataSolicitacao;
    @Column(length=100)
    private String motivo;
    @Column(name="DATA_RESP_RESPONSAVEL")
    private Date dataRespostaResponsavel;
    @Column(name="SITUACAO_RESPONSAVEL")
    @Enumerated
    private SipwebSolicitacaoSituacao situacaoResponsavel;
    @Column(name="DATA_RESP_RH")
    private Date dataRespostaRh;
    @Column(name="SITUACAO_RH")
    @Enumerated
    private SipwebSolicitacaoSituacao situacaoRh;
    @Column(length=32)
    private String hash;
    @NotNull
    @Size(min=1, max=3)
    @Column(name="ENTIDADE")
    private String entidadeId;
    @NotNull
    @Size(min=1, max=6)
    @Column(name="REGISTRO_TRABALHADOR")
    private String trabalhadorRegistro;
    @Size(min=1, max=6)
    @Column(name="REGISTRO_RESPONSAVEL")
    private String responsavelRegistro;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="ENTIDADE", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_TRABALHADOR", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="ENTIDADE", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO_RESPONSAVEL", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador responsavel;
    @OneToOne(mappedBy="solicitacaoFaltaAbonada", cascade={CascadeType.ALL}, orphanRemoval=true)
    private SipwebSolicitacaoPdf solicitacaoPdf;

    public SipwebSolicitacaoFaltaAbonada() {
    }

    public SipwebSolicitacaoFaltaAbonada(Date dataAbono, Date dataLancamento, Trabalhador trabalhador) {
        this.dataAbono = dataAbono;
        this.dataSolicitacao = dataLancamento;
        this.trabalhador = trabalhador;
        this.situacaoRh = SipwebSolicitacaoSituacao.APROVADA;
        this.situacaoResponsavel = SipwebSolicitacaoSituacao.APROVADA;
        this.protocolo = SipProtocoloAutenticacaoFactory.getNewProtocoloAutenticacao().toString();
    }

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
        if (this.solicitacaoPdf != null) {
            this.solicitacaoPdf.setProtocoloFaltaAbonada(protocolo);
            this.solicitacaoPdf.setSolicitacaoFaltaAbonada(this);
        }
    }

    public Date getDataAbono() {
        return this.dataAbono;
    }

    public void setDataAbono(Date dataAbono) {
        this.dataAbono = dataAbono;
    }

    public Date getDataRespostaResponsavel() {
        return this.dataRespostaResponsavel;
    }

    public void setDataRespostaResponsavel(Date dataRespostaResponsavel) {
        this.dataRespostaResponsavel = dataRespostaResponsavel;
    }

    public Date getDataRespostaRh() {
        return this.dataRespostaRh;
    }

    public void setDataRespostaRh(Date dataRespostaRh) {
        this.dataRespostaRh = dataRespostaRh;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        this.trabalhadorRegistro = trabalhador.getTrabalhadorPK().getRegistro();
        this.entidadeId = trabalhador.getTrabalhadorPK().getEntidade();
    }

    public void setSituacaoResponsavel(SipwebSolicitacaoSituacao situacaoResponsavel) {
        this.situacaoResponsavel = situacaoResponsavel;
    }

    public void setSituacaoRh(SipwebSolicitacaoSituacao situacaoRh) {
        this.situacaoRh = situacaoRh;
    }

    public SipwebSolicitacaoSituacao getSituacaoResponsavel() {
        return this.situacaoResponsavel;
    }

    public SipwebSolicitacaoSituacao getSituacaoRh() {
        return this.situacaoRh;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String obs) {
        this.motivo = obs;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Trabalhador responsavel) {
        this.responsavel = responsavel;
        this.responsavelRegistro = this.responsavel.getTrabalhadorPK().getRegistro();
    }

    public String getEntidadeId() {
        return this.entidadeId;
    }

    public void setEntidadeId(String entidadeId) {
        this.entidadeId = entidadeId;
    }

    public String getTrabalhadorRegistro() {
        return this.trabalhadorRegistro;
    }

    public void setTrabalhadorRegistro(String registroTrabalhador) {
        this.trabalhadorRegistro = registroTrabalhador;
    }

    public String getResponsavelRegistro() {
        return this.responsavelRegistro;
    }

    public void setResponsavelRegistro(String registroReponsavel) {
        this.responsavelRegistro = registroReponsavel;
    }

    public SipwebSolicitacaoPdf getSolicitacaoPdf() {
        return this.solicitacaoPdf;
    }

    public void setSolicitacaoPdf(SipwebSolicitacaoPdf solicitacaoPdf) {
        this.solicitacaoPdf = solicitacaoPdf;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocolo == null ? 0 : this.protocolo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipwebSolicitacaoFaltaAbonada other = (SipwebSolicitacaoFaltaAbonada)obj;
        return !(this.protocolo == null ? other.protocolo != null : !this.protocolo.equals(other.protocolo));
    }
}

