/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoSituacao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="SIPWEBSOLICITACAOCURSOEXTRA")
@Audited
public class SipwebSolicitacaoCursoExtra
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR = "SELECT s FROM SipwebSolicitacaoCursoExtra s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK ORDER BY s.dataSolicitacao DESC";
    public static final String FIND_BY_HASH = "SELECT s FROM SipwebSolicitacaoCursoExtra s WHERE s.hash = :hash AND s.situacaoResponsavel = '0'";
    @Id
    @Column(unique=true, nullable=false, length=16)
    private String protocolo;
    @Column(name="EMPRESA", nullable=false, length=3)
    private String entidadeId;
    @Column(length=150)
    private String motivo;
    @Column(name="NOME_CURSO", length=150)
    private String nomeCurso;
    @Column(name="NOME_INSTITUICAO", length=150)
    private String nomeInstituicao;
    @Column(name="REGISTRO", nullable=false, length=6)
    private String trabalhadorRegistro;
    @Column(name="RESPONSAVEL", length=6)
    private String responsavelRegistro;
    @Column(length=32)
    private String hash;
    @Enumerated
    @Column(name="SITUACAO_RESPONSAVEL")
    private SipwebSolicitacaoSituacao situacaoResponsavel;
    @Enumerated
    @Column(name="SITUACAO_RH")
    private SipwebSolicitacaoSituacao situacaoRh;
    @Temporal(value=TemporalType.DATE)
    @Column(name="TIMESTAMP_INICIO_CURSO", nullable=false)
    private Date dataInicioCurso;
    @Column(name="TIMESTAMP_RESP_RESPONSAVEL")
    private Date dataRespostaResponsavel;
    @Column(name="TIMESTAMP_RESP_RH")
    private Date dataRespostaRh;
    @Column(length=100, name="RESPOSTA_RH")
    private String respostaRh;
    @Column(name="TIMESTAMP_SOLICITACAO", nullable=false)
    private Date dataSolicitacao;
    @Temporal(value=TemporalType.DATE)
    @Column(name="TIMESTAMP_TERMINO_CURSO", nullable=false)
    private Date dataTerminoCurso;
    @Column(name="CARGA_HORARIA", nullable=false)
    private Integer cargaHoraria;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="RESPONSAVEL", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador responsavel;

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public String getEntidadeId() {
        return this.entidadeId;
    }

    public void setEntidadeId(String empresa) {
        this.entidadeId = empresa;
    }

    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public String getNomeCurso() {
        return this.nomeCurso;
    }

    public void setNomeCurso(String nomeCurso) {
        this.nomeCurso = nomeCurso;
    }

    public String getNomeInstituicao() {
        return this.nomeInstituicao;
    }

    public void setNomeInstituicao(String nomeInstituicao) {
        this.nomeInstituicao = nomeInstituicao;
    }

    public String getTrabalhadorRegistro() {
        return this.trabalhadorRegistro;
    }

    public void setTrabalhadorRegistro(String registro) {
        this.trabalhadorRegistro = registro;
    }

    public String getResponsavelRegistro() {
        return this.responsavelRegistro;
    }

    public void setResponsavelRegistro(String responsavel) {
        this.responsavelRegistro = responsavel;
    }

    public Date getDataInicioCurso() {
        return this.dataInicioCurso;
    }

    public void setDataInicioCurso(Date dataInicioCurso) {
        this.dataInicioCurso = dataInicioCurso;
    }

    public Date getDataTerminoCurso() {
        return this.dataTerminoCurso;
    }

    public void setDataTerminoCurso(Date dataTerminoCurso) {
        this.dataTerminoCurso = dataTerminoCurso;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocolo == null ? 0 : this.protocolo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipwebSolicitacaoCursoExtra other = (SipwebSolicitacaoCursoExtra)obj;
        return !(this.protocolo == null ? other.protocolo != null : !this.protocolo.equals(other.protocolo));
    }

    public SipwebSolicitacaoSituacao getSituacaoResponsavel() {
        return this.situacaoResponsavel;
    }

    public void setSituacaoResponsavel(SipwebSolicitacaoSituacao situacaoResponsavel) {
        this.situacaoResponsavel = situacaoResponsavel;
    }

    public SipwebSolicitacaoSituacao getSituacaoRh() {
        return this.situacaoRh;
    }

    public void setSituacaoRh(SipwebSolicitacaoSituacao situacaoRh) {
        this.situacaoRh = situacaoRh;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.entidadeId = trabalhador.getTrabalhadorPK().getEntidade();
        this.trabalhadorRegistro = trabalhador.getTrabalhadorPK().getRegistro();
        this.trabalhador = trabalhador;
    }

    public Trabalhador getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(Trabalhador responsavel) {
        this.responsavelRegistro = responsavel.getTrabalhadorPK().getRegistro();
        this.responsavel = responsavel;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getRespostaRh() {
        return this.respostaRh;
    }

    public void setRespostaRh(String respostaRh) {
        this.respostaRh = respostaRh;
    }

    public Date getDataRespostaResponsavel() {
        return this.dataRespostaResponsavel;
    }

    public void setDataRespostaResponsavel(Date dataRespostaResponsavel) {
        this.dataRespostaResponsavel = dataRespostaResponsavel;
    }

    public Date getDataRespostaRh() {
        return this.dataRespostaRh;
    }

    public void setDataRespostaRh(Date dataRespostaRh) {
        this.dataRespostaRh = dataRespostaRh;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Integer getCargaHoraria() {
        return this.cargaHoraria;
    }

    public void setCargaHoraria(Integer cargaHoraria) {
        this.cargaHoraria = cargaHoraria;
    }
}

