/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoPdf;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoSituacao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.time.DateUtils;

@Entity
@Table(name="SIPWEBSOLICITACAOAFASTAMENTO")
@Audited
public class SipwebSolicitacaoAfastamento
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PROTOCOLO")
    @NotNull
    private String protocolo;
    @Column(name="EMPRESA")
    @NotNull
    private String entidade;
    @Column(name="REGISTRO")
    @NotNull
    private String registro;
    @Column(name="DATA_AFASTAMENTO")
    @Temporal(value=TemporalType.DATE)
    @NotNull
    private Date dataAfastamento;
    @Column(name="DIAS")
    @NotNull
    private Short dias;
    @Column(name="DATA_SOLICITACAO")
    @Temporal(value=TemporalType.TIMESTAMP)
    @NotNull
    private Date dataSolicitacao = new Date();
    @Enumerated
    @Column(name="SITUACAO_RH")
    private SipwebSolicitacaoSituacao situacaoRh = SipwebSolicitacaoSituacao.PENDENTE;
    @Column(name="DATA_RESPOSTA_RH")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dataRespostaRh;
    @Column(name="RESPOSTA_RH", length=100)
    private String respostaRh;
    @Column(length=32)
    private String hash;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @OneToOne(mappedBy="solicitacaoAfastamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private SipwebSolicitacaoPdf solicitacaoPdf;

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
        if (this.solicitacaoPdf != null) {
            this.solicitacaoPdf.setProtocoloAfastamento(protocolo);
            this.solicitacaoPdf.setSolicitacaoAfastamento(this);
        }
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Date getDataAfastamento() {
        return this.dataAfastamento;
    }

    public void setDataAfastamento(Date dataAfastamento) {
        this.dataAfastamento = dataAfastamento;
    }

    public Short getDias() {
        return this.dias;
    }

    public void setDias(Short dias) {
        this.dias = dias;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public SipwebSolicitacaoSituacao getSituacaoRh() {
        return this.situacaoRh;
    }

    public void setSituacaoRh(SipwebSolicitacaoSituacao situacaoRh) {
        this.situacaoRh = situacaoRh;
    }

    public Date getDataRespostaRh() {
        return this.dataRespostaRh;
    }

    public void setDataRespostaRh(Date dataRespostaRh) {
        this.dataRespostaRh = dataRespostaRh;
    }

    public String getRespostaRh() {
        return this.respostaRh;
    }

    public void setRespostaRh(String respostaRh) {
        this.respostaRh = respostaRh;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public SipwebSolicitacaoPdf getSolicitacaoPdf() {
        return this.solicitacaoPdf;
    }

    public void setSolicitacaoPdf(SipwebSolicitacaoPdf solicitacaoPdf) {
        this.solicitacaoPdf = solicitacaoPdf;
    }

    public Date getDataRetorno() {
        return this.dias != null && this.dias > 0 && this.dataAfastamento != null ? DateUtils.addDays((Date)this.dataAfastamento, (int)this.dias.shortValue()) : null;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SipwebSolicitacaoAfastamento that = (SipwebSolicitacaoAfastamento)o;
        return Objects.equals(this.protocolo, that.protocolo);
    }

    public int hashCode() {
        return Objects.hashCode(this.protocolo);
    }
}

