/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoSituacao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="SIPWEBSOLICITACAOADIANTAMENTO")
@Audited
public class SipwebSolicitacaoAdiantamento
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String IS_THERE_PENDENTE = "SELECT CASE WHEN COUNT(s) > 0 THEN true ELSE false END FROM SipwebSolicitacaoAdiantamento s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK AND s.situacao = '0'";
    public static final String FIND_BY_CPF = "select s from SipwebSolicitacaoAdiantamento s join fetch s.trabalhador t where t.documentosPessoais.cpf = :cpf order by s.situacao";
    @Id
    @Column(unique=true, nullable=false, length=16)
    private String protocolo;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_SOLICITACAO", nullable=false)
    private Date dataSolicitacao;
    @Column(name="PAGAMENTO_ANO", nullable=false, length=4)
    private String pagamentoAno;
    @Column(name="PAGAMENTO_MES", nullable=false, length=2)
    private String pagamentoMes;
    @Column(name="REPOSTA_RH", length=100)
    private String respostaRh;
    @Column(name="VALOR_ADIANTAMENTO")
    private Integer valorAdiantamento;
    @Enumerated
    private SipwebSolicitacaoSituacao situacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="ENTIDADE", referencedColumnName="EMPRESA"), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO")})
    private Trabalhador trabalhador;
    @Transient
    private String referencia;

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public String getPagamentoAno() {
        return this.pagamentoAno;
    }

    public void setPagamentoAno(String pagamentoAno) {
        this.pagamentoAno = pagamentoAno;
    }

    public String getPagamentoMes() {
        return this.pagamentoMes;
    }

    public void setPagamentoMes(String pagamentoMes) {
        this.pagamentoMes = pagamentoMes;
    }

    public String getRespostaRh() {
        return this.respostaRh;
    }

    public void setRespostaRh(String respostaRh) {
        this.respostaRh = respostaRh;
    }

    public SipwebSolicitacaoSituacao getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SipwebSolicitacaoSituacao situacao) {
        this.situacao = situacao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public String getReferencia() {
        if (!(this.referencia == null || !this.referencia.isEmpty() || this.getPagamentoAno().isEmpty() && this.getPagamentoMes().isEmpty())) {
            return (this.getPagamentoMes().isEmpty() ? "  " : this.getPagamentoMes()) + "/" + this.getPagamentoAno();
        }
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
        this.setPagamentoMes(referencia.substring(0, 2));
        this.setPagamentoAno(referencia.substring(3, 7));
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocolo == null ? 0 : this.protocolo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipwebSolicitacaoAdiantamento other = (SipwebSolicitacaoAdiantamento)obj;
        return !(this.protocolo == null ? other.protocolo != null : !this.protocolo.equals(other.protocolo));
    }

    public Integer getValorAdiantamento() {
        return this.valorAdiantamento;
    }

    public void setValorAdiantamento(Integer valorAdiantamento) {
        this.valorAdiantamento = valorAdiantamento;
    }
}

