/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SipwebSolicitacaoSituacao;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;

@Entity
@Table(name="SIPWEBSOLICITACAO13SALARIO")
@Audited
public class SipwebSolicitacao13Salario
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_TRABALHADOR = "SELECT s FROM SipwebSolicitacao13Salario s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK AND s.pagamentoAno = :pagamentoAno ORDER BY s.dataSolicitacao DESC";
    public static final String TOTAL_ADIANTAMENTO_SOLICITADO_P1 = "SELECT COALESCE(SUM(s.porcentagem), 0) FROM SipwebSolicitacao13Salario s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK AND s.pagamentoAno = :anoAtual and s.situacao = 1";
    public static final String TOTAL_ADIANTAMENTO_SOLICITADO_P2 = "SELECT COALESCE(SUM(m.porcentagem), 0) FROM Referencia r JOIN r.movimentoList m WHERE m.trabalhador.trabalhadorPK = :trabalhadorPK AND m.evento.eventoPK.codigo = '912' AND r.mes.mesPK.ano = :anoAtual";
    public static final String IS_THERE_SOLICITACAO = "SELECT CASE WHEN COUNT(s) > 0 THEN true ELSE false END FROM SipwebSolicitacao13Salario s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK AND s.pagamentoAno = :pagamentoAno AND s.pagamentoMes = :pagamentoMes AND s.situacao <> 2";
    @Id
    @Column(unique=true, nullable=false, length=16)
    private String protocolo;
    @Column(name="DATA_SOLICITACAO", nullable=false)
    private Date dataSolicitacao;
    @Pattern(regexp="^\\d{4}$")
    @Column(name="PAGAMENTO_ANO", nullable=false, length=4)
    private String pagamentoAno;
    @Pattern(regexp="^(0?[1-9]|1[012])$")
    @Column(name="PAGAMENTO_MES", nullable=false, length=2)
    private String pagamentoMes;
    @Max(value=100L)
    @Min(value=0L)
    private double porcentagem;
    @Column(name="RESPOSTA_RH", length=100)
    private String respostaRh;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="ENTIDADE", referencedColumnName="EMPRESA"), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO")})
    private Trabalhador trabalhador;
    @Enumerated
    private SipwebSolicitacaoSituacao situacao;

    public String getProtocolo() {
        return this.protocolo;
    }

    public void setProtocolo(String protocolo) {
        this.protocolo = protocolo;
    }

    public Date getDataSolicitacao() {
        return this.dataSolicitacao;
    }

    public void setDataSolicitacao(Date dataSolicitacao) {
        this.dataSolicitacao = dataSolicitacao;
    }

    public String getPagamentoAno() {
        return this.pagamentoAno;
    }

    public void setPagamentoAno(String pagamentoAno) {
        this.pagamentoAno = pagamentoAno;
    }

    public String getPagamentoMes() {
        return this.pagamentoMes;
    }

    public void setPagamentoMes(String pagamentoMes) {
        this.pagamentoMes = pagamentoMes;
    }

    public double getPorcentagem() {
        return this.porcentagem;
    }

    public void setPorcentagem(double porcentagem) {
        this.porcentagem = porcentagem;
    }

    public String getRespostaRh() {
        return this.respostaRh;
    }

    public void setRespostaRh(String respostaRh) {
        this.respostaRh = respostaRh;
    }

    public SipwebSolicitacaoSituacao getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SipwebSolicitacaoSituacao situacao) {
        this.situacao = situacao;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.protocolo == null ? 0 : this.protocolo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipwebSolicitacao13Salario other = (SipwebSolicitacao13Salario)obj;
        return !(this.protocolo == null ? other.protocolo != null : !this.protocolo.equals(other.protocolo));
    }

    public String toString() {
        return "SipwebSolicitacao13Salario [protocolo=" + this.protocolo + ", trabalhador=" + this.trabalhador + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

