/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfigParameter;
import br.com.fiorilli.filter.annotations.FilterConfigParameters;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.entity.Divisao;
import br.com.fiorilli.sip.persistence.entity.DivisaoPK;
import br.com.fiorilli.sip.persistence.entity.Entidade;
import br.com.fiorilli.sip.persistence.entity.GrupoPonto;
import br.com.fiorilli.sip.persistence.entity.Referencia;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.enums.TipoRelatorio;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SIPWEB_PDF_ASSINADO")
@FilterConfigType(query="SELECT $R{[s.id],[s]} FROM SipwebPdfAssinado s LEFT JOIN FETCH s.trabalhador t LEFT JOIN FETCH s.referencia r WHERE s.empresa = :entidadeCodigo    AND $P{[mes], [r.mesCodigo], [:mes]}    AND $P{[ano], [r.ano], [:ano]}    AND $P{[tipoRelatorio], [s.tipoRelatorio], [:tipoRelatorio]}    AND $P{[assinaturaResponsavel], [s.assinaturaResponsavel], [:assinaturaResponsavel]}    AND $P{[registro], [t.trabalhadorPK.registro], [:registro]}    AND $P{[matricula], [t.matricula], [:matricula]}    AND $P{[nome], [t.nome], [:nome]}    AND $P{[divisao], [t.divisao], [:divisao]}    AND $P{[grupoPonto], [t.grupoPonto], [:grupoPonto]}    AND $P{[divisoesPerfil], [t.divisao.divisaoPK], [:divisoesPerfil]} ", rootEntityAlias="s", displayField=4)
@FilterConfigParameters(value={@FilterConfigParameter(fieldClass=String.class, id="mes", label="M\u00eas", order=1), @FilterConfigParameter(fieldClass=String.class, id="ano", label="Ano", order=2), @FilterConfigParameter(fieldClass=Integer.class, id="tipoRelatorio", label="Tipo de Documento", inputType=FilterInputType.SELECT_ONE_MENU, condition=FilterCondition.IGUAL, enumClass=TipoRelatorio.class, enumLabel="descricao", order=3), @FilterConfigParameter(fieldClass=Boolean.class, id="assinaturaResponsavel", label="Assinado pelo Respons\u00e1vel", inputType=FilterInputType.SELECT_ONE_MENU_BOOLEAN, order=4), @FilterConfigParameter(fieldClass=Divisao.class, id="divisao", label="Divis\u00e3o", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT d FROM Divisao d WHERE UPPER(concat(d.divisaoPK.codigo, d.nome)) LIKE UPPER('%'||:param||'%') AND d.divisaoPK.entidade = :entidadeCodigo", order=8), @FilterConfigParameter(fieldClass=GrupoPonto.class, id="grupoPonto", label="Grupo", inputType=FilterInputType.AUTO_COMPLETE, query="SELECT g FROM GrupoPonto g where g.grupoPontoPK.entidade = :entidadeCodigo AND concat(g.grupoPontoPK.codigo, g.nome) LIKE concat('%', :param, '%') ", order=9), @FilterConfigParameter(fieldClass=String.class, id="registro", label="Registro", inputType=FilterInputType.NUMBER, order=5), @FilterConfigParameter(fieldClass=Integer.class, id="matricula", label="Matr\u00edcula", inputType=FilterInputType.NUMBER, order=6), @FilterConfigParameter(fieldClass=String.class, id="nome", label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE, order=7), @FilterConfigParameter(fieldClass=DivisaoPK.class, id="divisoesPerfil", label="Divis\u00f5es Perfil", condition=FilterCondition.SEQUENCIA, hide=true, disable=true)})
public class SipwebPdfAssinado
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_SIPWEB_PDF_ASSINADO";
    public static final String SQL_FILTER = "SELECT $R{[s.id],[s]} FROM SipwebPdfAssinado s LEFT JOIN FETCH s.trabalhador t LEFT JOIN FETCH s.referencia r WHERE s.empresa = :entidadeCodigo    AND $P{[mes], [r.mesCodigo], [:mes]}    AND $P{[ano], [r.ano], [:ano]}    AND $P{[tipoRelatorio], [s.tipoRelatorio], [:tipoRelatorio]}    AND $P{[assinaturaResponsavel], [s.assinaturaResponsavel], [:assinaturaResponsavel]}    AND $P{[registro], [t.trabalhadorPK.registro], [:registro]}    AND $P{[matricula], [t.matricula], [:matricula]}    AND $P{[nome], [t.nome], [:nome]}    AND $P{[divisao], [t.divisao], [:divisao]}    AND $P{[grupoPonto], [t.grupoPonto], [:grupoPonto]}    AND $P{[divisoesPerfil], [t.divisao.divisaoPK], [:divisoesPerfil]} ";
    public static final String SQL_CHECK_SIGNATURE_RESPONSAVEL = "SELECT s FROM SipwebPdfAssinado s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK    AND s.referenciaCodigo = :referenciaCodigo    AND s.tipoRelatorio = :tipoRelatorio    AND s.assinaturaResponsavel = :assinaturaResponsavel";
    public static final String SQL_EXISTS = "SELECT s.id FROM SipwebPdfAssinado s WHERE s.trabalhador.trabalhadorPK = :trabalhadorPK    AND s.referenciaCodigo = :referenciaCodigo    AND s.tipoRelatorio = :tipoRelatorio";
    @Id
    @Column
    @Basic(optional=false)
    @NotNull
    private Integer id;
    @Column
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=3)
    private String empresa;
    @Column
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=6)
    private String registro;
    @Column(name="REFERENCIA")
    @Basic(optional=false)
    @NotNull
    private Integer referenciaCodigo;
    @Column(name="TIPO_RELATORIO")
    @Enumerated
    @NotNull
    private TipoRelatorio tipoRelatorio;
    @Lob
    @Column
    private byte[] pdf;
    @Column(name="NOME_PDF")
    private String nomePdf;
    @Column(name="ASSINATURA_RESPONSAVEL")
    @Type(type="BooleanTypeSip")
    private Boolean assinaturaResponsavel;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="EMPRESA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Entidade entidade;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    @JoinColumn(name="REFERENCIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Referencia referencia;
    @Transient
    private Boolean selecionado;

    public SipwebPdfAssinado() {
    }

    public SipwebPdfAssinado(String empresa, String registro, Integer referenciaCodigo, TipoRelatorio tipoRelatorio, byte[] pdf, String nomePdf) {
        this.empresa = empresa;
        this.registro = registro;
        this.referenciaCodigo = referenciaCodigo;
        this.tipoRelatorio = tipoRelatorio;
        this.pdf = pdf;
        this.nomePdf = nomePdf;
        this.assinaturaResponsavel = false;
    }

    public SipwebPdfAssinado(String empresa, String registro, Integer referenciaCodigo, TipoRelatorio tipoRelatorio, byte[] pdf, String nomePdf, Boolean assinaturaResponsavel) {
        this.empresa = empresa;
        this.registro = registro;
        this.referenciaCodigo = referenciaCodigo;
        this.tipoRelatorio = tipoRelatorio;
        this.pdf = pdf;
        this.nomePdf = nomePdf;
        this.assinaturaResponsavel = assinaturaResponsavel;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(String empresa) {
        this.empresa = empresa;
    }

    public String getRegistro() {
        return this.registro;
    }

    public void setRegistro(String registro) {
        this.registro = registro;
    }

    public Integer getReferenciaCodigo() {
        return this.referenciaCodigo;
    }

    public void setReferenciaCodigo(Integer referenciaCodigo) {
        this.referenciaCodigo = referenciaCodigo;
    }

    public TipoRelatorio getTipoRelatorio() {
        return this.tipoRelatorio;
    }

    public void setTipoRelatorio(TipoRelatorio tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
    }

    public byte[] getPdf() {
        return this.pdf;
    }

    public void setPdf(byte[] pdf) {
        this.pdf = pdf;
    }

    public String getNomePdf() {
        return this.nomePdf;
    }

    public void setNomePdf(String nomePdf) {
        this.nomePdf = nomePdf;
    }

    public Boolean getAssinaturaResponsavel() {
        return this.assinaturaResponsavel;
    }

    public void setAssinaturaResponsavel(Boolean assinaturaResponsavel) {
        this.assinaturaResponsavel = assinaturaResponsavel;
    }

    public Entidade getEntidade() {
        return this.entidade;
    }

    public void setEntidade(Entidade entidade) {
        this.entidade = entidade;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public Referencia getReferencia() {
        return this.referencia;
    }

    public void setReferencia(Referencia referencia) {
        this.referencia = referencia;
    }

    public Boolean getSelecionado() {
        return this.selecionado;
    }

    public void setSelecionado(Boolean selecionado) {
        this.selecionado = selecionado;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SipwebPdfAssinado that = (SipwebPdfAssinado)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toLog() {
        return String.format("ID=%d,EMPRESA=%s,REGISTRO=%s,REFERENCIA=%d,TIPO_RELATORIO=%s,NOME_PDF=%s", this.id, this.empresa, this.registro, this.referenciaCodigo, this.tipoRelatorio.getDescricao(), this.nomePdf);
    }
}

