/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CodigoVerbaTceRo;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.SiproEventoPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPRO_EVENTO")
@Audited
public class SiproEvento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT ro FROM SiproEvento ro LEFT JOIN FETCH ro.evento e WHERE e.eventoPK = :pk ";
    @EmbeddedId
    protected SiproEventoPK siproEventoPK;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento evento;
    @Size(min=1, max=3)
    @Column(name="EMPRESA", insertable=false, updatable=false)
    private String entidade;
    @Size(min=1, max=3)
    @Column(name="EVENTO", insertable=false, updatable=false)
    private String codigoEvento;
    @NotNull
    @Column(name="CODIGO_OPCOES")
    private Integer codigo;

    public static SiproEvento createInitialized(String codigoEntidade, String codigoEvento) {
        SiproEvento s = new SiproEvento();
        s.getSiproEventoPK().setEntidade(codigoEntidade);
        s.getSiproEventoPK().setEvento(codigoEvento);
        return s;
    }

    public SiproEvento() {
    }

    public SiproEvento(SiproEventoPK siproEventoPK) {
        this.siproEventoPK = siproEventoPK;
    }

    public SiproEvento(String entidade, String evento) {
        this.siproEventoPK = new SiproEventoPK(entidade, evento);
    }

    public SiproEventoPK getSiproEventoPK() {
        if (this.siproEventoPK == null) {
            this.siproEventoPK = new SiproEventoPK();
        }
        return this.siproEventoPK;
    }

    public void setSiproEventoPK(SiproEventoPK siproEventoPK) {
        this.siproEventoPK = siproEventoPK;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento eventos) {
        this.evento = eventos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.siproEventoPK == null ? 0 : this.siproEventoPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiproEvento other = (SiproEvento)obj;
        return !(this.siproEventoPK == null ? other.siproEventoPK != null : !this.siproEventoPK.equals(other.siproEventoPK));
    }

    public String toString() {
        return "SiproEvento [siproEventoPK=" + this.siproEventoPK + "]";
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String codigoEvento) {
        this.codigoEvento = codigoEvento;
    }

    public CodigoVerbaTceRo getCodigo() {
        return CodigoVerbaTceRo.toEntity(this.codigo);
    }

    public void setCodigo(CodigoVerbaTceRo codigo) {
        this.codigo = codigo.getId();
    }
}

