/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.SiproCargoPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPRO_CARGO")
@Audited
public class SiproCargo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected SiproCargoPK siproCargoPK;
    @Size(max=2)
    @Column(name="FREQ_CARGA_HORARIA")
    private String freqCargaHoraria;
    @Size(max=2)
    @Column(name="QTD_PLANTAO_MES")
    private String qtdPlantaoMes;
    @Size(max=2)
    @Column(name="CARGA_PLANTAO")
    private String cargaPlantao;
    @Column(name="VALOR_PLANTAO")
    private Double valorPlantao;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CARGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    private Cargo cargos;

    public SiproCargo() {
    }

    public SiproCargo(SiproCargoPK siproCargoPK) {
        this.siproCargoPK = siproCargoPK;
    }

    public SiproCargo(String entidade, String cargo) {
        this.siproCargoPK = new SiproCargoPK(entidade, cargo);
    }

    public SiproCargoPK getSiproCargoPK() {
        return this.siproCargoPK;
    }

    public void setSiproCargoPK(SiproCargoPK siproCargoPK) {
        this.siproCargoPK = siproCargoPK;
    }

    public String getFreqCargaHoraria() {
        return this.freqCargaHoraria;
    }

    public void setFreqCargaHoraria(String freqCargaHoraria) {
        this.freqCargaHoraria = freqCargaHoraria;
    }

    public String getQtdPlantaoMes() {
        return this.qtdPlantaoMes;
    }

    public void setQtdPlantaoMes(String qtdPlantaoMes) {
        this.qtdPlantaoMes = qtdPlantaoMes;
    }

    public String getCargaPlantao() {
        return this.cargaPlantao;
    }

    public void setCargaPlantao(String cargaPlantao) {
        this.cargaPlantao = cargaPlantao;
    }

    public Double getValorPlantao() {
        return this.valorPlantao;
    }

    public void setValorPlantao(Double valorPlantao) {
        this.valorPlantao = valorPlantao;
    }

    public Cargo getCargos() {
        return this.cargos;
    }

    public void setCargos(Cargo cargos) {
        this.cargos = cargos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.siproCargoPK != null ? this.siproCargoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SiproCargo)) {
            return false;
        }
        SiproCargo other = (SiproCargo)object;
        return (this.siproCargoPK != null || other.siproCargoPK == null) && (this.siproCargoPK == null || this.siproCargoPK.equals(other.siproCargoPK));
    }

    public String toString() {
        return "entity.SiproCargo[ siproCargoPK=" + this.siproCargoPK + " ]";
    }
}

