/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.CodigoEventoTceRn;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.SiprnEventoPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPRN_EVENTO")
@Audited
public class SiprnEvento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT rn FROM SiprnEvento rn LEFT JOIN FETCH rn.eventos e WHERE e.eventoPK = :pk";
    @EmbeddedId
    protected SiprnEventoPK siprnEventoPK;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento eventos;
    @Size(min=1, max=3)
    @Column(name="EMPRESA", insertable=false, updatable=false)
    private String entidade;
    @Size(min=1, max=3)
    @Column(name="EVENTO", insertable=false, updatable=false)
    private String codigoEvento;
    @NotNull
    @Column(name="CODIGO")
    private Integer codigo;

    public static SiprnEvento createInitialized(String codigoEntidade, String codigoEvento) {
        SiprnEvento s = new SiprnEvento();
        s.getSiprnEventoPK().setEntidade(codigoEntidade);
        s.getSiprnEventoPK().setEvento(codigoEvento);
        return s;
    }

    public SiprnEvento() {
    }

    public SiprnEvento(SiprnEventoPK siprnEventoPK) {
        this.siprnEventoPK = siprnEventoPK;
    }

    public SiprnEvento(String entidade, String evento, int codigo) {
        this.siprnEventoPK = new SiprnEventoPK(entidade, evento);
    }

    public SiprnEventoPK getSiprnEventoPK() {
        if (this.siprnEventoPK == null) {
            this.siprnEventoPK = new SiprnEventoPK();
        }
        return this.siprnEventoPK;
    }

    public void setSiprnEventoPK(SiprnEventoPK siprnEventoPK) {
        this.siprnEventoPK = siprnEventoPK;
    }

    public Evento getEventos() {
        return this.eventos;
    }

    public void setEventos(Evento eventos) {
        this.eventos = eventos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.siprnEventoPK != null ? this.siprnEventoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SiprnEvento)) {
            return false;
        }
        SiprnEvento other = (SiprnEvento)object;
        return (this.siprnEventoPK != null || other.siprnEventoPK == null) && (this.siprnEventoPK == null || this.siprnEventoPK.equals(other.siprnEventoPK));
    }

    public String toString() {
        return "entity.SiprnEvento[ siprnEventoPK=" + this.siprnEventoPK + " ]";
    }

    public CodigoEventoTceRn getCodigo() {
        return CodigoEventoTceRn.toEntity(this.codigo);
    }

    public void setCodigo(CodigoEventoTceRn codigo) {
        this.codigo = codigo.getId();
    }
}

