/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ClassificacaoTcePe;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.SippeEventoPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPPE_EVENTO")
@Audited
public class SippeEvento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT pe FROM SippeEvento pe LEFT JOIN FETCH pe.eventos e WHERE e.eventoPK = :pk";
    @EmbeddedId
    protected SippeEventoPK sippeEventoPK;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(fetch=FetchType.LAZY)
    private Evento eventos;
    @Size(min=1, max=3)
    @Column(name="EMPRESA", insertable=false, updatable=false)
    private String entidade;
    @Size(min=1, max=3)
    @Column(name="EVENTO", insertable=false, updatable=false)
    private String codigoEvento;
    @Size(min=1, max=6)
    @Column(name="CODIGO")
    private String codigo;

    public static SippeEvento createInitialized(String codigoEntidade, String codigoEvento) {
        SippeEvento s = new SippeEvento();
        s.getSippeEventoPK().setEntidade(codigoEntidade);
        s.getSippeEventoPK().setEvento(codigoEvento);
        return s;
    }

    public SippeEvento() {
    }

    public SippeEvento(SippeEventoPK sippeEventoPK) {
        this.sippeEventoPK = sippeEventoPK;
    }

    public SippeEvento(String entidade, String evento, String codigo) {
        this.sippeEventoPK = new SippeEventoPK(entidade, evento);
        this.codigo = codigo;
    }

    public SippeEventoPK getSippeEventoPK() {
        if (this.sippeEventoPK == null) {
            this.sippeEventoPK = new SippeEventoPK();
        }
        return this.sippeEventoPK;
    }

    public void setSippeEventoPK(SippeEventoPK sippeEventoPK) {
        this.sippeEventoPK = sippeEventoPK;
    }

    public Evento getEventos() {
        return this.eventos;
    }

    public void setEventos(Evento eventos) {
        this.eventos = eventos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.sippeEventoPK != null ? this.sippeEventoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SippeEvento)) {
            return false;
        }
        SippeEvento other = (SippeEvento)object;
        return (this.sippeEventoPK != null || other.sippeEventoPK == null) && (this.sippeEventoPK == null || this.sippeEventoPK.equals(other.sippeEventoPK));
    }

    public String toString() {
        return "entity.SippeEvento[ sippeEventoPK=" + this.sippeEventoPK + " ]";
    }

    public String getEntidade() {
        return this.entidade;
    }

    public void setEntidade(String entidade) {
        this.entidade = entidade;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String codigoEvento) {
        this.codigoEvento = codigoEvento;
    }

    public ClassificacaoTcePe getCodigo() {
        return ClassificacaoTcePe.toEntity(this.codigo);
    }

    public void setCodigo(ClassificacaoTcePe codigo) {
        this.codigo = codigo.getId();
    }
}

