/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="SIPMT_TRABALHADOR")
@Audited
public class SipmtTrabalhador
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected TrabalhadorPK sipmtTrabalhadorPK;
    @Size(max=1)
    @Column(name="CODIGO")
    private String codigo;
    @Size(max=51)
    @Column(name="CODIGO_DOTACAO_ORCAMENTARIA")
    private String codigoDotacaoOrcamentaria;
    @Size(max=50)
    @Column(name="EM_DISPOSICAO_LOCAL")
    private String empresaOrigem;
    @Column(name="EM_DISPOSICAO_ORIGEM")
    private Integer origem;
    @Size(max=7)
    @Column(name="EM_DISPOSICAO_UG_ORIGEM")
    private String ugOrigem;
    @Type(type="BooleanTypeSip")
    @Column(name="EM_DISPOSICAO_ONUS")
    private Boolean onus;
    @Size(max=10)
    @Column(name="REGISTRO_TCE")
    private String registroTce;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;

    public SipmtTrabalhador() {
    }

    public SipmtTrabalhador(TrabalhadorPK sipmtTrabalhadorPK) {
        this.sipmtTrabalhadorPK = sipmtTrabalhadorPK;
    }

    public SipmtTrabalhador(String entidade, String registro) {
        this.sipmtTrabalhadorPK = new TrabalhadorPK(entidade, registro);
    }

    public TrabalhadorPK getSipmtTrabalhadorPK() {
        return this.sipmtTrabalhadorPK;
    }

    public void setSipmtTrabalhadorPK(TrabalhadorPK sipmtTrabalhadorPK) {
        this.sipmtTrabalhadorPK = sipmtTrabalhadorPK;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public String getCodigoDotacaoOrcamentaria() {
        return this.codigoDotacaoOrcamentaria;
    }

    public void setCodigoDotacaoOrcamentaria(String codigoDotacaoOrcamentaria) {
        this.codigoDotacaoOrcamentaria = codigoDotacaoOrcamentaria;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.sipmtTrabalhadorPK != null ? this.sipmtTrabalhadorPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SipmtTrabalhador)) {
            return false;
        }
        SipmtTrabalhador other = (SipmtTrabalhador)object;
        return (this.sipmtTrabalhadorPK != null || other.sipmtTrabalhadorPK == null) && (this.sipmtTrabalhadorPK == null || this.sipmtTrabalhadorPK.equals(other.sipmtTrabalhadorPK));
    }

    public String toString() {
        return "entity.SipmtTrabalhador[ sipmtTrabalhadorPK=" + this.sipmtTrabalhadorPK + " ]";
    }

    public String getEmpresaOrigem() {
        return this.empresaOrigem;
    }

    public void setEmpresaOrigem(String empresaOrigem) {
        this.empresaOrigem = empresaOrigem;
    }

    public Integer getOrigem() {
        return this.origem;
    }

    public void setOrigem(Integer origem) {
        this.origem = origem;
    }

    public String getUgOrigem() {
        return this.ugOrigem;
    }

    public void setUgOrigem(String ugOrigem) {
        this.ugOrigem = ugOrigem;
    }

    public Boolean getOnus() {
        return this.onus;
    }

    public void setOnus(Boolean onus) {
        this.onus = onus;
    }

    public String getRegistroTce() {
        return this.registroTce;
    }

    public void setRegistroTce(String registroTce) {
        this.registroTce = registroTce;
    }
}

