/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.ClassificacaoTceMt;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.SipmtEventoPK;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPMT_EVENTO")
@Audited
public class SipmtEvento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT mt FROM SipmtEvento mt LEFT JOIN FETCH mt.eventos e WHERE e.eventoPK = :pk ";
    @EmbeddedId
    protected SipmtEventoPK sipmtEventoPK;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=1)
    @Column(name="TIPO")
    private String tipo;
    @Enumerated(value=EnumType.STRING)
    @Column(name="COD_TCE")
    private ClassificacaoTceMt codTce;
    @Size(max=1)
    @Column(name="NAT_TCE")
    private String natTce;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @OneToOne(optional=false, fetch=FetchType.LAZY)
    private Evento eventos;

    public SipmtEvento() {
    }

    public SipmtEvento(SipmtEventoPK sipmtEventoPK) {
        this.sipmtEventoPK = sipmtEventoPK;
    }

    public SipmtEvento(SipmtEventoPK sipmtEventoPK, String tipo) {
        this.sipmtEventoPK = sipmtEventoPK;
        this.tipo = tipo;
    }

    public SipmtEvento(String entidade, String evento) {
        this.sipmtEventoPK = new SipmtEventoPK(entidade, evento);
    }

    public SipmtEventoPK getSipmtEventoPK() {
        if (this.sipmtEventoPK == null) {
            this.sipmtEventoPK = new SipmtEventoPK();
        }
        return this.sipmtEventoPK;
    }

    public void setSipmtEventoPK(SipmtEventoPK sipmtEventoPK) {
        this.sipmtEventoPK = sipmtEventoPK;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public ClassificacaoTceMt getCodTce() {
        return this.codTce;
    }

    public void setCodTce(ClassificacaoTceMt codTce) {
        this.codTce = codTce;
    }

    public ClassificacaoTceMt getNatTce() {
        return ClassificacaoTceMt.getValueNatTce(this.natTce);
    }

    public void setNatTce(ClassificacaoTceMt natTce) {
        this.natTce = natTce.getNatTce();
    }

    public Evento getEventos() {
        return this.eventos;
    }

    public void setEventos(Evento eventos) {
        this.eventos = eventos;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sipmtEventoPK == null ? 0 : this.sipmtEventoPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SipmtEvento other = (SipmtEvento)obj;
        return !(this.sipmtEventoPK == null ? other.sipmtEventoPK != null : !this.sipmtEventoPK.equals(other.sipmtEventoPK));
    }

    public String toString() {
        return "SipmtEvento [sipmtEventoPK=" + this.sipmtEventoPK + "]";
    }
}

