/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Cargo;
import br.com.fiorilli.sip.persistence.entity.RegimeCargoTceMt;
import br.com.fiorilli.sip.persistence.entity.SipmtCargosPK;
import br.com.fiorilli.sip.persistence.entity.TipoCargoTceMt;
import br.com.fiorilli.sip.persistence.entity.TipoMovimentoTceMt;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPMT_CARGOS")
@Audited
public class SipmtCargos
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected SipmtCargosPK sipmtCargosPK;
    @Column(name="TIPO")
    private String tipo;
    @Size(max=2)
    @Column(name="ESCOLA")
    private String escola;
    @Size(max=10)
    @Column(name="CODIGO_UG")
    private String codigoUg;
    @Column(name="TIPO_MOVIM")
    private String tipoMovim;
    @Column(name="DT_CONTROLE")
    @Temporal(value=TemporalType.DATE)
    private Date dtControle;
    @Column(name="REGIMECARGO")
    private RegimeCargoTceMt regimecargo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="CODIGO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Cargo cargos;

    public SipmtCargos() {
    }

    public SipmtCargos(SipmtCargosPK sipmtCargosPK) {
        this.sipmtCargosPK = sipmtCargosPK;
    }

    public SipmtCargos(String entidade, String codigo) {
        this.sipmtCargosPK = new SipmtCargosPK(entidade, codigo);
    }

    public SipmtCargosPK getSipmtCargosPK() {
        if (this.sipmtCargosPK == null) {
            this.sipmtCargosPK = new SipmtCargosPK();
        }
        return this.sipmtCargosPK;
    }

    public void setSipmtCargosPK(SipmtCargosPK sipmtCargosPK) {
        this.sipmtCargosPK = sipmtCargosPK;
    }

    public TipoCargoTceMt getTipo() {
        return TipoCargoTceMt.toEntity(this.tipo);
    }

    public void setTipo(TipoCargoTceMt tipo) {
        this.tipo = tipo.getId();
    }

    public String getEscola() {
        return this.escola;
    }

    public void setEscola(String escola) {
        this.escola = escola;
    }

    public String getCodigoUg() {
        return this.codigoUg;
    }

    public void setCodigoUg(String codigoUg) {
        this.codigoUg = codigoUg;
    }

    public TipoMovimentoTceMt getTipoMovim() {
        return TipoMovimentoTceMt.toEntity(this.tipoMovim);
    }

    public void setTipoMovim(TipoMovimentoTceMt tipoMovim) {
        this.tipoMovim = tipoMovim.getId();
    }

    public Date getDtControle() {
        return this.dtControle;
    }

    public void setDtControle(Date dtControle) {
        this.dtControle = dtControle;
    }

    public RegimeCargoTceMt getRegimecargo() {
        return this.regimecargo;
    }

    public void setRegimecargo(RegimeCargoTceMt regimecargo) {
        this.regimecargo = regimecargo;
    }

    public Cargo getCargos() {
        return this.cargos;
    }

    public void setCargos(Cargo cargos) {
        this.cargos = cargos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.sipmtCargosPK != null ? this.sipmtCargosPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SipmtCargos)) {
            return false;
        }
        SipmtCargos other = (SipmtCargos)object;
        return (this.sipmtCargosPK != null || other.sipmtCargosPK == null) && (this.sipmtCargosPK == null || this.sipmtCargosPK.equals(other.sipmtCargosPK));
    }

    public String toString() {
        return "entity.SipmtCargos[ sipmtCargosPK=" + this.sipmtCargosPK + " ]";
    }
}

