/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.BeneficioTceMs;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.SipmsEventoPK;
import br.com.fiorilli.sip.persistence.entity.TipoRemuneracaoTceMs;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPMS_EVENTO")
@Audited
public class SipmsEvento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_EVENTO = "SELECT ms FROM SipmsEvento ms LEFT JOIN FETCH ms.eventos e WHERE e.eventoPK = :pk ";
    @EmbeddedId
    protected SipmsEventoPK sipmsEventoPK;
    @Basic(optional=false)
    @NotNull
    @Column(name="CODIGO")
    private int codigo;
    @Size(max=15)
    @Column(name="LEI_AUTORIZADORA")
    private String leiAutorizadora;
    @Column(name="TIPOEVENTO")
    private Integer tipoevento;
    @Size(max=30)
    @Column(name="OUTROS")
    private String outros;
    @Size(max=1)
    @Column(name="NATUREZA")
    private String natureza;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Evento eventos;

    public SipmsEvento() {
    }

    public SipmsEvento(SipmsEventoPK sipmsEventoPK) {
        this.sipmsEventoPK = sipmsEventoPK;
    }

    public SipmsEvento(SipmsEventoPK sipmsEventoPK, int codigo) {
        this.sipmsEventoPK = sipmsEventoPK;
        this.codigo = codigo;
    }

    public SipmsEvento(String entidade, String evento) {
        this.sipmsEventoPK = new SipmsEventoPK(entidade, evento);
    }

    public SipmsEventoPK getSipmsEventoPK() {
        if (this.sipmsEventoPK == null) {
            this.sipmsEventoPK = new SipmsEventoPK();
        }
        return this.sipmsEventoPK;
    }

    public void setSipmsEventoPK(SipmsEventoPK sipmsEventoPK) {
        this.sipmsEventoPK = sipmsEventoPK;
    }

    public BeneficioTceMs getCodigo() {
        return BeneficioTceMs.toEntity(this.codigo);
    }

    public void setCodigo(BeneficioTceMs codigo) {
        this.codigo = codigo.getId();
    }

    public String getLeiAutorizadora() {
        return this.leiAutorizadora;
    }

    public void setLeiAutorizadora(String leiAutorizadora) {
        this.leiAutorizadora = leiAutorizadora;
    }

    public TipoRemuneracaoTceMs getTipoevento() {
        return TipoRemuneracaoTceMs.toEntity(this.tipoevento);
    }

    public void setTipoevento(TipoRemuneracaoTceMs tipoevento) {
        this.tipoevento = tipoevento.getId();
    }

    public String getOutros() {
        return this.outros;
    }

    public void setOutros(String outros) {
        this.outros = outros;
    }

    public String getNatureza() {
        return this.natureza;
    }

    public void setNatureza(String natureza) {
        this.natureza = natureza;
    }

    public Evento getEventos() {
        return this.eventos;
    }

    public void setEventos(Evento eventos) {
        this.eventos = eventos;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.sipmsEventoPK != null ? this.sipmsEventoPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SipmsEvento)) {
            return false;
        }
        SipmsEvento other = (SipmsEvento)object;
        return (this.sipmsEventoPK != null || other.sipmsEventoPK == null) && (this.sipmsEventoPK == null || this.sipmsEventoPK.equals(other.sipmsEventoPK));
    }

    public String toString() {
        return "entity.SipmsEvento[ sipmsEventoPK=" + this.sipmsEventoPK + " ]";
    }
}

