/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.entity.SipLogSistema;
import br.com.fiorilli.sip.persistence.entity.SiplogAction;
import br.com.fiorilli.sip.persistence.entity.SiplogBlob;
import br.com.fiorilli.sip.persistence.entity.SiplogTable;
import br.com.fiorilli.sip.persistence.entity.Usuario;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPLOG")
public class Siplog
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_SIPLOG";
    @Id
    @Basic(optional=false)
    @NotNull
    @Column(name="ID")
    private Double id;
    @Column(name="LOGDATE")
    @Temporal(value=TemporalType.DATE)
    private Date date;
    @Column(name="LOGHOUR")
    @Temporal(value=TemporalType.TIME)
    private Date hour;
    @Size(max=16384)
    @Column(name="LOGTEXT")
    private String text;
    @Column(name="CHAVE")
    @Size(max=60)
    private String chave;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USERID", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Usuario user;
    @Column(name="USERID")
    @NotNull(message="Usu\u00e1rio do Log \u00e9 Obrigat\u00f3ria")
    private Integer userId;
    @JoinColumn(name="TABLEID", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private SiplogTable table;
    @Column(name="TABLEID")
    private Integer tableId;
    @Enumerated
    @NotNull(message="Action do Log \u00e9 Obrigat\u00f3ria")
    @Column(name="actionid")
    private SiplogAction action;
    @Enumerated
    @Column(name="SISTEMA")
    private SipLogSistema sistema;
    @Column(name="USER_IP")
    private String userIp;
    @OneToOne(cascade={CascadeType.ALL}, mappedBy="log", fetch=FetchType.LAZY)
    private SiplogBlob blob;
    public static final String FIND_BY_CHAVE_TABLENAME = "SELECT         sl FROM         Siplog sl INNER JOIN         sl.table slt WHERE         sl.chave = :chave AND     slt.nome = :tableName ";

    public Siplog() {
    }

    public Siplog(Date date, String text, String chave, Integer tableId) {
        this.date = date;
        this.text = text;
        this.chave = chave;
        this.tableId = tableId;
    }

    public Siplog(Double id) {
        this.id = id;
    }

    public Double getId() {
        return this.id;
    }

    public void setId(Double id) {
        this.id = id;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date logdate) {
        this.date = logdate;
    }

    public Date getHour() {
        return this.hour;
    }

    public void setHour(Date loghour) {
        this.hour = loghour;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String logtext) {
        this.text = logtext;
    }

    public Usuario getUser() {
        return this.user;
    }

    public void setUser(Usuario user) {
        this.userId = user != null ? user.getCodigo() : null;
        this.user = user;
    }

    public SiplogTable getTable() {
        return this.table;
    }

    public void setTable(SiplogTable table) {
        this.tableId = table != null ? table.getCodigo() : null;
        this.table = table;
    }

    public final SiplogAction getAction() {
        return this.action;
    }

    public final void setAction(SiplogAction action) {
        this.action = action;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIP) {
        this.userIp = userIP;
    }

    public SiplogBlob getBlob() {
        return this.blob;
    }

    public void setBlob(SiplogBlob siplogBlob) {
        this.blob = siplogBlob;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.id != null ? this.id.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Siplog)) {
            return false;
        }
        Siplog other = (Siplog)object;
        return (this.id != null || other.id == null) && (this.id == null || this.id.equals(other.id));
    }

    public String toString() {
        return "entity.Siplog[ id=" + this.id + " ]";
    }

    public Integer getTableId() {
        return this.tableId;
    }

    public void setTableId(Integer tableId) {
        this.tableId = tableId;
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public static SiplogBuilder builder() {
        return new SiplogBuilder();
    }

    public Siplog(Double id, Date date, Date hour, String text, String chave, Usuario user, Integer userId, SiplogTable table, Integer tableId, SiplogAction action, SipLogSistema sistema, String userIp, SiplogBlob blob) {
        this.id = id;
        this.date = date;
        this.hour = hour;
        this.text = text;
        this.chave = chave;
        this.user = user;
        this.userId = userId;
        this.table = table;
        this.tableId = tableId;
        this.action = action;
        this.sistema = sistema;
        this.userIp = userIp;
        this.blob = blob;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String chave) {
        this.chave = chave;
    }

    public SipLogSistema getSistema() {
        return this.sistema;
    }

    public void setSistema(SipLogSistema sistema) {
        this.sistema = sistema;
    }

    public static class SiplogBuilder {
        private Double id;
        private Date date;
        private Date hour;
        private String text;
        private String chave;
        private Usuario user;
        private Integer userId;
        private SiplogTable table;
        private Integer tableId;
        private SiplogAction action;
        private SipLogSistema sistema;
        private String userIp;
        private SiplogBlob blob;

        SiplogBuilder() {
        }

        public SiplogBuilder id(Double id) {
            this.id = id;
            return this;
        }

        public SiplogBuilder date(Date date) {
            this.date = date;
            return this;
        }

        public SiplogBuilder hour(Date hour) {
            this.hour = hour;
            return this;
        }

        public SiplogBuilder text(String text) {
            this.text = text;
            return this;
        }

        public SiplogBuilder chave(String chave) {
            this.chave = chave;
            return this;
        }

        public SiplogBuilder user(Usuario user) {
            this.user = user;
            return this;
        }

        public SiplogBuilder userId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public SiplogBuilder table(SiplogTable table) {
            this.table = table;
            return this;
        }

        public SiplogBuilder tableId(Integer tableId) {
            this.tableId = tableId;
            return this;
        }

        public SiplogBuilder action(SiplogAction action) {
            this.action = action;
            return this;
        }

        public SiplogBuilder sistema(SipLogSistema sistema) {
            this.sistema = sistema;
            return this;
        }

        public SiplogBuilder userIp(String userIp) {
            this.userIp = userIp;
            return this;
        }

        public SiplogBuilder blob(SiplogBlob blob) {
            this.blob = blob;
            return this;
        }

        public Siplog build() {
            return new Siplog(this.id, this.date, this.hour, this.text, this.chave, this.user, this.userId, this.table, this.tableId, this.action, this.sistema, this.userIp, this.blob);
        }

        public String toString() {
            return "Siplog.SiplogBuilder(id=" + this.id + ", date=" + this.date + ", hour=" + this.hour + ", text=" + this.text + ", chave=" + this.chave + ", user=" + this.user + ", userId=" + this.userId + ", table=" + this.table + ", tableId=" + this.tableId + ", action=" + (Object)((Object)this.action) + ", sistema=" + (Object)((Object)this.sistema) + ", userIp=" + this.userIp + ", blob=" + this.blob + ")";
        }
    }
}

