/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPWEB_REQUERIMENTOS")
@FilterConfigType(autoFilter=true)
public class SipWebRequerimento
implements Serializable {
    public static final String GENERATOR = "GEN_SIPWEB_REQUERIMENTOS";
    public static final String SQL_FIND_ALL = "SELECT r FROM SipWebRequerimento r";
    @Id
    @Column(name="ID")
    @NotNull
    private Integer id;
    @Column(name="ASSUNTO", length=150)
    @NotNull
    @FilterConfig(label="Assunto", condition=FilterCondition.CONTENHA, inputType=FilterInputType.TEXT)
    private String assunto;
    @Lob
    @Size(max=0x7FFFFFFF)
    @Column(name="TEXTO_PADRAO")
    private String textoPadrao;
    @Transient
    private String textoFinal;

    public SipWebRequerimento() {
    }

    public SipWebRequerimento(Integer id, String assunto, String textoPadrao) {
        this.id = id;
        this.assunto = assunto;
        this.textoPadrao = textoPadrao;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getAssunto() {
        return this.assunto;
    }

    public void setAssunto(String assunto) {
        this.assunto = assunto;
    }

    public String getTextoPadrao() {
        return this.textoPadrao;
    }

    public void setTextoPadrao(String textoPadrao) {
        this.textoPadrao = textoPadrao;
    }

    public String getTextoFinal() {
        return this.textoFinal;
    }

    public void setTextoFinal(String textoFinal) {
        this.textoFinal = textoFinal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SipWebRequerimento that = (SipWebRequerimento)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.assunto, that.assunto);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.assunto);
    }
}

