/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SipWebNotificaTrabalhadorFiltro;
import br.com.fiorilli.sip.persistence.entity.SipWebNotificaTrabalhadorPK;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="SIPWEB_NOTIFICA_TRABALHADOR")
@FilterConfigType(autoFilter=true)
@Audited
public class SipWebNotificaTrabalhador
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected SipWebNotificaTrabalhadorPK sipWebNotificaTrabalhadorPK;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=100)
    @Column(name="DESCRICAO")
    @FilterConfig(label="Descri\u00e7\u00e3o", condition=FilterCondition.CONTENHA, inputType=FilterInputType.TEXT)
    private String descricao;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=1024)
    @Column(name="MENSAGEM")
    private String mensagem;
    @Column(name="DATA_VENCIMENTO")
    @Temporal(value=TemporalType.DATE)
    private Date dataVencimento;
    @Basic(optional=false)
    @NotNull
    @Size(min=1, max=1)
    @Column(name="ATIVO")
    private String ativo;
    @Basic(optional=false)
    @NotNull
    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    private Date dataCadastro;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="notificacaoTrabalhador")
    private List<SipWebNotificaTrabalhadorFiltro> filtros;

    public SipWebNotificaTrabalhador(String empresa, Integer id, String descricao, String mensagem) {
        this.sipWebNotificaTrabalhadorPK = new SipWebNotificaTrabalhadorPK(empresa, id);
        this.descricao = descricao;
        this.mensagem = mensagem;
    }

    public boolean isAtivoChecked() {
        return this.ativo != null && "S".equals(this.ativo);
    }

    public void setAtivoChecked(boolean checked) {
        this.ativo = checked ? "S" : "N";
    }

    public String getDescricaoAtivo() {
        return this.getAtivo() != null && "S".equals(this.getAtivo()) ? "Sim" : "N\u00e3o";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SipWebNotificaTrabalhador that = (SipWebNotificaTrabalhador)o;
        return Objects.equals(this.sipWebNotificaTrabalhadorPK, that.sipWebNotificaTrabalhadorPK);
    }

    public int hashCode() {
        return Objects.hash(this.sipWebNotificaTrabalhadorPK);
    }

    public SipWebNotificaTrabalhadorPK getSipWebNotificaTrabalhadorPK() {
        return this.sipWebNotificaTrabalhadorPK;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public String getAtivo() {
        return this.ativo;
    }

    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public List<SipWebNotificaTrabalhadorFiltro> getFiltros() {
        return this.filtros;
    }

    public void setSipWebNotificaTrabalhadorPK(SipWebNotificaTrabalhadorPK sipWebNotificaTrabalhadorPK) {
        this.sipWebNotificaTrabalhadorPK = sipWebNotificaTrabalhadorPK;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    public void setAtivo(String ativo) {
        this.ativo = ativo;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setFiltros(List<SipWebNotificaTrabalhadorFiltro> filtros) {
        this.filtros = filtros;
    }

    public SipWebNotificaTrabalhador() {
    }
}

