/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SiopeCategoria;
import br.com.fiorilli.sip.persistence.entity.SiopeLocalExercicio;
import br.com.fiorilli.sip.persistence.entity.Trabalhador;
import br.com.fiorilli.sip.persistence.entity.TrabalhadorPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="SIOPE_TRABALHADOR")
@Audited
public class SiopeTrabalhador
implements Serializable {
    private static final long serialVersionUID = 1L;
    @EmbeddedId
    protected TrabalhadorPK siopeTrabalhadorPK;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="REGISTRO", referencedColumnName="REGISTRO", insertable=false, updatable=false)})
    private Trabalhador trabalhador;
    @JoinColumn(name="CATEGORIA", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private SiopeCategoria categoria;
    @Column(name="CATEGORIA")
    private Integer categoriaCodigo;
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="LOCAL_EXERCICIO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private SiopeLocalExercicio localExercicio;
    @Column(name="LOCAL_EXERCICIO")
    private String localExercicioCodigo;

    public SiopeTrabalhador() {
    }

    public SiopeTrabalhador(TrabalhadorPK siopeTrabalhadorPK) {
        this.siopeTrabalhadorPK = siopeTrabalhadorPK;
    }

    public SiopeTrabalhador(String entidade, String registro) {
        this.siopeTrabalhadorPK = new TrabalhadorPK(entidade, registro);
    }

    public TrabalhadorPK getSiopeTrabalhadorPK() {
        if (this.siopeTrabalhadorPK == null) {
            this.siopeTrabalhadorPK = new TrabalhadorPK();
        }
        return this.siopeTrabalhadorPK;
    }

    public void setSiopeTrabalhadorPK(TrabalhadorPK siopeTrabalhadorPK) {
        this.siopeTrabalhadorPK = siopeTrabalhadorPK;
    }

    public Trabalhador getTrabalhador() {
        return this.trabalhador;
    }

    public void setTrabalhador(Trabalhador trabalhador) {
        this.trabalhador = trabalhador;
        if (trabalhador != null) {
            this.getSiopeTrabalhadorPK().setEntidade(trabalhador.getTrabalhadorPK().getEntidade());
            this.getSiopeTrabalhadorPK().setRegistro(trabalhador.getTrabalhadorPK().getRegistro());
        } else {
            this.getSiopeTrabalhadorPK().setEntidade(null);
            this.getSiopeTrabalhadorPK().setRegistro(null);
        }
    }

    public SiopeCategoria getCategoria() {
        return this.categoria;
    }

    public void setCategoria(SiopeCategoria categoria) {
        this.categoria = categoria;
        this.categoriaCodigo = categoria != null ? categoria.getCodigo() : null;
    }

    public Integer getCategoriaCodigo() {
        return this.categoriaCodigo;
    }

    public void setCategoriaCodigo(Integer categoriaCodigo) {
        this.categoriaCodigo = categoriaCodigo;
    }

    public SiopeLocalExercicio getLocalExercicio() {
        return this.localExercicio;
    }

    public void setLocalExercicio(SiopeLocalExercicio localExercicio) {
        this.localExercicio = localExercicio;
        this.localExercicioCodigo = localExercicio != null ? localExercicio.getSiopeLocalExercicioPK().getCodigo() : null;
    }

    public String getLocalExercicioCodigo() {
        return this.localExercicioCodigo;
    }

    public void setLocalExercicioCodigo(String localExercicioCodigo) {
        this.localExercicioCodigo = localExercicioCodigo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.siopeTrabalhadorPK == null ? 0 : this.siopeTrabalhadorPK.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiopeTrabalhador other = (SiopeTrabalhador)obj;
        return !(this.siopeTrabalhadorPK == null ? other.siopeTrabalhadorPK != null : !this.siopeTrabalhadorPK.equals(other.siopeTrabalhadorPK));
    }

    public String toString() {
        return "SiopeTrabalhador [siopeTrabalhadorPK=" + this.siopeTrabalhadorPK + "]";
    }
}

