/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SiopeTipoCategoria;
import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@FilterConfigType(autoFilter=true)
@Entity
@Table(name="SIOPE_CATEGORIA")
@Audited
public class SiopeCategoria
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_SIOPE_CATEGORIA";
    @Basic(optional=false)
    @NotNull
    @Id
    @Column(name="CODIGO")
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE)
    private Integer codigo;
    @Size(max=256)
    @Column(name="NOME")
    @FilterConfig(label="Nome", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE)
    private String nome;
    @JoinColumn(name="CODIGO_TIPO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private SiopeTipoCategoria tipoCategoria;
    @Column(name="CODIGO_TIPO")
    @FilterConfig(label="Tipo de Categoria", inputType=FilterInputType.TEXT, condition=FilterCondition.COMECE)
    private Integer tipoCategoriaCodigo;

    public SiopeCategoria() {
    }

    public SiopeCategoria(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public Integer getTipoCategoriaCodigo() {
        return this.tipoCategoriaCodigo;
    }

    public void setTipoCategoriaCodigo(Integer tipoCategoriaCodigo) {
        this.tipoCategoriaCodigo = tipoCategoriaCodigo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigo == null ? 0 : this.codigo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiopeCategoria other = (SiopeCategoria)obj;
        return !(this.codigo == null ? other.codigo != null : !this.codigo.equals(other.codigo));
    }

    public String toString() {
        return "SiopeCategoria [codigo=" + this.codigo + "]";
    }

    public SiopeTipoCategoria getTipoCategoria() {
        return this.tipoCategoria;
    }

    public void setTipoCategoria(SiopeTipoCategoria tipoCategoria) {
        this.tipoCategoria = tipoCategoria;
        this.tipoCategoriaCodigo = tipoCategoria != null ? tipoCategoria.getCodigo() : null;
    }
}

