/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Evento;
import br.com.fiorilli.sip.persistence.entity.Sindicato;
import br.com.fiorilli.sip.persistence.entity.SindicatoEventoPK;
import java.io.Serializable;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="SINDICATO_EVENTOS")
@Audited
public class SindicatoEvento
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_SINDICATO = "SELECT s FROM SindicatoEvento s JOIN FETCH s.evento WHERE s.sindicato.codigo = :sindicatoId ORDER BY s.evento.nome";
    @EmbeddedId
    private SindicatoEventoPK id = new SindicatoEventoPK();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="SINDICATO", referencedColumnName="CODIGO", insertable=false, updatable=false)
    private Sindicato sindicato;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="EMPRESA", referencedColumnName="EMPRESA", insertable=false, updatable=false), @JoinColumn(name="EVENTO", referencedColumnName="CODIGO", insertable=false, updatable=false)})
    private Evento evento;

    public SindicatoEventoPK getId() {
        return this.id;
    }

    public void setId(SindicatoEventoPK id) {
        this.id = id;
    }

    public Sindicato getSindicato() {
        return this.sindicato;
    }

    public void setSindicato(Sindicato sindicatoBean) {
        if (sindicatoBean != null) {
            this.id.setSindicatoCodigo(sindicatoBean.getCodigo());
        } else {
            this.id.setSindicatoCodigo(0);
        }
        this.sindicato = sindicatoBean;
    }

    public Evento getEvento() {
        return this.evento;
    }

    public void setEvento(Evento evento) {
        if (evento != null) {
            this.id.setEvento(evento.getEventoPK().getCodigo());
            this.id.setEmpresa(evento.getEventoPK().getEntidade());
        } else {
            this.id.setEvento(null);
            this.id.setEmpresa(null);
        }
        this.evento = evento;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SindicatoEvento)) {
            return false;
        }
        SindicatoEvento other = (SindicatoEvento)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "SindicatoEvento [id=" + this.id + "]";
    }
}

