/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.filter.annotations.FilterConfig;
import br.com.fiorilli.filter.annotations.FilterConfigEnum;
import br.com.fiorilli.filter.annotations.FilterConfigType;
import br.com.fiorilli.filter.model.FilterCondition;
import br.com.fiorilli.filter.model.FilterInputType;
import br.com.fiorilli.filter.service.Filterable;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Endereco;
import br.com.fiorilli.sip.persistence.entity.IdentificadorTipo;
import br.com.fiorilli.sip.persistence.entity.SindicatoEvento;
import br.com.fiorilli.sip.persistence.entity.SindicatoTipo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@FilterConfigType(rootQueryType=Sindicato.class)
@Entity
@Table(name="SINDICATO")
@Audited
public class Sindicato
implements Serializable,
Filterable {
    private static final long serialVersionUID = 1L;
    public static final String GENERATOR = "GEN_SINDICATO";
    public static final String FIND_FOR_FILTER = "SELECT s FROM Sindicato s WHERE UPPER(s.nome) LIKE UPPER('%'||:param||'%') ORDER BY s.nome";
    public static final String GET_FETCHED_BY_ID = "SELECT s FROM Sindicato s JOIN FETCH s.eventos WHERE s.codigo = :codigo";
    @FilterConfig(label="C\u00f3digo", inputType=FilterInputType.NUMBER)
    @Id
    @Basic(optional=false)
    @Column(name="CODIGO")
    private Integer codigo;
    @FilterConfig(label="Nome", condition=FilterCondition.COMECE)
    @Size(max=60)
    @Column(name="NOME")
    private String nome;
    @Size(max=18)
    @Column(name="CNPJ")
    private String cnpj;
    @FilterConfig(label="Tipo", order=2, inputType=FilterInputType.SELECT_ONE_MENU)
    @FilterConfigEnum(enumClass=SindicatoTipo.class, enumId="codigo", itemLabel="descricao")
    @Size(max=2)
    @Column(name="TIPO")
    private String tipo;
    @Embedded
    private Endereco endereco;
    @Size(max=11)
    @Column(name="TELEFONE")
    private String telefone;
    @Size(max=12)
    @Column(name="CODIGO_SINDICAL")
    private String codigoSindical;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="sindicato", fetch=FetchType.LAZY, orphanRemoval=true)
    private List<SindicatoEvento> eventos;

    @PostLoad
    public void postLoad() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
    }

    public Sindicato() {
        this.eventos = new ArrayList<SindicatoEvento>();
    }

    public Sindicato(Integer codigo) {
        this.codigo = codigo;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public void setCodigo(Integer codigo) {
        this.codigo = codigo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getTipo() {
        return this.tipo;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public Endereco getEndereco() {
        if (this.endereco == null) {
            this.endereco = new Endereco();
        }
        return this.endereco;
    }

    public void setEndereco(Endereco endereco) {
        this.endereco = endereco;
    }

    public String getTelefone() {
        return this.telefone;
    }

    public void setTelefone(String telefone) {
        this.telefone = telefone;
    }

    public String getCodigoSindical() {
        return this.codigoSindical;
    }

    public void setCodigoSindical(String codigoSindical) {
        this.codigoSindical = codigoSindical;
    }

    public IdentificadorTipo getTipoIdentificador() {
        return IdentificadorTipo.getCnpj();
    }

    public List<SindicatoEvento> getEventos() {
        this.eventos.size();
        return this.eventos;
    }

    public void setEventos(List<SindicatoEvento> eventos) {
        this.eventos = eventos;
    }

    public SindicatoEvento addEvento(SindicatoEvento sindicatoEvento) {
        this.eventos.add(sindicatoEvento);
        if (this.getCodigo() != null) {
            sindicatoEvento.setSindicato(this);
        }
        return sindicatoEvento;
    }

    public SindicatoEvento removeEvento(SindicatoEvento sindicatoEvento) {
        this.eventos.remove(sindicatoEvento);
        sindicatoEvento.setSindicato(null);
        return sindicatoEvento;
    }

    public String toString() {
        return "entity.Sindicato[ codigo=" + this.codigo + " ]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.codigo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sindicato other = (Sindicato)obj;
        return this.codigo == other.codigo;
    }

    public String getItemId() {
        return String.valueOf(this.codigo);
    }

    public String getItemLabel() {
        return this.nome;
    }
}

