/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.Fpas;
import br.com.fiorilli.sip.persistence.entity.SatPK;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Size;

@Entity
@Table(name="SAT")
@Audited
public class Sat
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FIND_BY_CODIGO = "SELECT s FROM Sat s JOIN FETCH s.fpas WHERE s.satPK.satCodigo = :satCodigo";
    @EmbeddedId
    protected SatPK satPK;
    @Size(max=240)
    @Column(name="SITUACAO")
    private String situacao;
    @Column(name="PORC")
    private Double porcentagem;
    @JoinColumn(name="CODFPAS", referencedColumnName="CODIGO", insertable=false, updatable=false)
    @ManyToOne(optional=false, fetch=FetchType.LAZY)
    private Fpas fpas;

    public Sat() {
    }

    public Sat(SatPK satPK) {
        this.satPK = satPK;
    }

    public Sat(String codfpas, String codsat) {
        this.satPK = new SatPK(codfpas, codsat);
    }

    public SatPK getSatPK() {
        return this.satPK;
    }

    public void setSatPK(SatPK satPK) {
        this.satPK = satPK;
    }

    public String getSituacao() {
        return this.situacao;
    }

    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    public Double getPorcentagem() {
        return this.porcentagem;
    }

    public void setPorcentagem(Double porc) {
        this.porcentagem = porc;
    }

    public Fpas getFpas() {
        return this.fpas;
    }

    public void setFpas(Fpas fpas) {
        this.fpas = fpas;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.satPK != null ? this.satPK.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Sat)) {
            return false;
        }
        Sat other = (Sat)object;
        return (this.satPK != null || other.satPK == null) && (this.satPK == null || this.satPK.equals(other.satPK));
    }

    public String toString() {
        return "entity.Sat[ satPK=" + this.satPK + " ]";
    }
}

