/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.AliquotaNacional;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SalarioFamiliaNacionalPK;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="SALFAMNACIONAL")
@Audited
public class SalarioFamiliaNacional
implements Serializable,
AliquotaNacional {
    private static final long serialVersionUID = 7186333352698719132L;
    @EmbeddedId
    protected SalarioFamiliaNacionalPK pk;
    @Column(name="DE")
    private BigDecimal de;
    @Column(name="ATE")
    private BigDecimal ate;
    @Column(name="VALOR")
    private BigDecimal valor;
    @Column(name="MES", insertable=false, updatable=false)
    private String mes;
    @Column(name="ANO", insertable=false, updatable=false)
    private String ano;
    @Column(name="FAIXA", insertable=false, updatable=false)
    private Short faixa;

    public SalarioFamiliaNacional() {
        this.pk = new SalarioFamiliaNacionalPK();
    }

    public SalarioFamiliaNacional(SalarioFamiliaNacionalPK pk) {
        this.pk = pk;
    }

    public SalarioFamiliaNacional(String ano, String mes, short faixa) {
        this.pk = new SalarioFamiliaNacionalPK(ano, mes, faixa);
    }

    public SalarioFamiliaNacionalPK getPk() {
        return this.pk;
    }

    public void setPk(SalarioFamiliaNacionalPK salarioFamiliaNacionalPK) {
        this.pk = salarioFamiliaNacionalPK;
    }

    @Override
    public BigDecimal getDe() {
        return this.de;
    }

    @Override
    public void setDe(BigDecimal de) {
        this.de = de;
    }

    @Override
    public BigDecimal getAte() {
        return this.ate;
    }

    public void setAte(BigDecimal ate) {
        this.ate = ate;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pk != null ? this.pk.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SalarioFamiliaNacional)) {
            return false;
        }
        SalarioFamiliaNacional other = (SalarioFamiliaNacional)object;
        return (this.pk != null || other.pk == null) && (this.pk == null || this.pk.equals(other.pk));
    }

    public String toString() {
        return "SalarioFamiliaNacional [mes=" + this.mes + "/" + this.ano + ", faixa=" + this.faixa + ", de=" + NumberFormat.getCurrencyInstance().format(this.de) + ", ate=" + NumberFormat.getCurrencyInstance().format(this.ate) + ", valor=" + NumberFormat.getCurrencyInstance().format(this.valor) + "]";
    }

    @Override
    public Short getFaixa() {
        return this.pk.getFaixa();
    }

    @Override
    public String getAno() {
        return this.pk.getAno();
    }

    @Override
    public String getMes() {
        return this.pk.getMes();
    }

    @Override
    public void setFaixa(Short faixa) {
        this.pk.setFaixa(faixa);
    }

    @Override
    public void setAno(String ano) {
        this.pk.setAno(ano);
    }

    @Override
    public void setMes(String mes) {
        this.pk.setMes(mes);
    }
}

