/*
 * Decompiled with CFR 0.152.
 */
package br.com.fiorilli.sip.persistence.entity;

import br.com.fiorilli.sip.persistence.api.AliquotaMunicipal;
import br.com.fiorilli.sip.persistence.auditoria.Audited;
import br.com.fiorilli.sip.persistence.entity.SalarioFamiliaMunicipalPK;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="SALFAMMUNICIPAL")
@Audited
public class SalarioFamiliaMunicipal
implements Serializable,
AliquotaMunicipal {
    private static final long serialVersionUID = 3760558323068950314L;
    @EmbeddedId
    protected SalarioFamiliaMunicipalPK pk;
    @Column(name="DE")
    private BigDecimal de;
    @Column(name="ATE")
    private BigDecimal ate;
    @Column(name="VALOR")
    private BigDecimal valor;
    @Column(name="MES", insertable=false, updatable=false)
    private String mes;
    @Column(name="ANO", insertable=false, updatable=false)
    private String ano;
    @Column(name="FAIXA", insertable=false, updatable=false)
    private Short faixa;
    @Column(name="EMPRESA", insertable=false, updatable=false)
    private String entidade;

    public SalarioFamiliaMunicipal() {
        this.pk = new SalarioFamiliaMunicipalPK();
    }

    public SalarioFamiliaMunicipal(SalarioFamiliaMunicipalPK pk) {
        this.pk = pk;
    }

    public SalarioFamiliaMunicipal(String entidade, String ano, String mes, short faixa) {
        this.pk = new SalarioFamiliaMunicipalPK(entidade, ano, mes, faixa);
    }

    public SalarioFamiliaMunicipalPK getPk() {
        return this.pk;
    }

    public void setPk(SalarioFamiliaMunicipalPK pk) {
        this.pk = pk;
    }

    @Override
    public BigDecimal getDe() {
        return this.de;
    }

    @Override
    public void setDe(BigDecimal de) {
        this.de = de;
    }

    @Override
    public BigDecimal getAte() {
        return this.ate;
    }

    public void setAte(BigDecimal ate) {
        this.ate = ate;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    @Override
    public Short getFaixa() {
        return this.pk.getFaixa();
    }

    @Override
    public String getAno() {
        return this.pk.getAno();
    }

    @Override
    public String getMes() {
        return this.pk.getMes();
    }

    @Override
    public void setFaixa(Short faixa) {
        this.pk.setFaixa(faixa);
    }

    @Override
    public void setAno(String ano) {
        this.pk.setAno(ano);
    }

    @Override
    public void setMes(String mes) {
        this.pk.setMes(mes);
    }

    @Override
    public String getEntidade() {
        return this.pk.getEntidade();
    }

    @Override
    public void setEntidade(String entidadeCodigo) {
        this.pk.setEntidade(entidadeCodigo);
    }

    public int hashCode() {
        int hash = 0;
        return hash += this.pk != null ? this.pk.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SalarioFamiliaMunicipal)) {
            return false;
        }
        SalarioFamiliaMunicipal other = (SalarioFamiliaMunicipal)object;
        return (this.pk != null || other.pk == null) && (this.pk == null || this.pk.equals(other.pk));
    }

    public String toString() {
        return "SalarioFamiliaMunicipal [mes=" + this.mes + "/" + this.ano + ", faixa=" + this.faixa + ", de=" + NumberFormat.getCurrencyInstance().format(this.de) + ", ate=" + NumberFormat.getCurrencyInstance().format(this.ate) + ", valor=" + NumberFormat.getCurrencyInstance().format(this.valor) + "]";
    }
}

